/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiExtensionsListener;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.VradiMainUIHandler;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.entities.WikittyExtension;

public class FormMenu
extends JMenu
implements VradiExtensionsListener {
    private static final Log log = LogFactory.getLog(FormMenu.class);
    protected VradiMainUIHandler handler;
    protected List<JMenuItem> items = new ArrayList<JMenuItem>();

    public FormMenu(VradiMainUIHandler handler) {
        this.handler = handler;
        this.updateMenus();
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    protected void updateMenus() {
        for (JMenuItem item : this.items) {
            this.remove(item);
        }
        List<WikittyExtension> forms = null;
        try {
            forms = VradiService.getVradiDataService().getAllFormTypes();
        }
        catch (VradiException eee) {
            log.error((Object)"cant get all forms type", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        Collections.sort(forms, VradiComparators.EXTENSION_COMPARATOR);
        for (final WikittyExtension form : forms) {
            JMenuItem item = new JMenuItem(I18n._((String)"vradi.menu.form.new", (Object[])new Object[]{form.getName()}));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FormMenu.this.handler.createForm(form);
                }
            });
            this.items.add(item);
            this.add(item);
        }
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        this.updateMenus();
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        this.updateMenus();
    }
}

