/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.admin.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.vradi.entities.XmlFieldBinding;

public class XmlStreamFieldTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected final List<XmlFieldBinding> data = new ArrayList<XmlFieldBinding>();
    protected boolean valueIsAdjusting;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    public void clear() {
        this.data.clear();
        if (!this.isValueIsAdjusting()) {
            this.fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public List<XmlFieldBinding> getBindings() {
        return new ArrayList<XmlFieldBinding>(this.data);
    }

    public void setBindings(Collection<XmlFieldBinding> bindings) {
        this.data.clear();
        this.data.addAll(bindings);
        if (this.isValueIsAdjusting()) {
            int firstRow = this.data.size() - bindings.size();
            int lastRow = this.data.size() - 1;
            this.fireTableRowsInserted(firstRow, lastRow);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (this.ensureColumnIndex(columnIndex) && this.ensureRowIndex(rowIndex)) {
            XmlFieldBinding value = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    result = value.getFormField();
                    break;
                }
                case 1: {
                    result = value.getXmlField();
                    break;
                }
                case 2: {
                    result = value.getDefaultValue();
                }
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.ensureColumnIndex(columnIndex) && this.ensureRowIndex(rowIndex)) {
            XmlFieldBinding binding = this.data.get(rowIndex);
            if (columnIndex == 1) {
                Object[] values = (Object[])value;
                binding.clearXmlField();
                for (Object v : values) {
                    binding.addXmlField(String.valueOf(v));
                }
            } else if (columnIndex == 2) {
                binding.setDefaultValue(String.valueOf(value));
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    protected boolean ensureRowIndex(int rowIndex) {
        return rowIndex < this.getRowCount();
    }

    protected boolean ensureColumnIndex(int columnIndex) {
        return columnIndex < this.getColumnCount();
    }
}

