/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.solr.common.util.FileUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.SnapPuller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapShooter {
    private static final Logger LOG = LoggerFactory.getLogger((String)SnapShooter.class.getName());
    private String snapDir = null;
    private SolrCore solrCore;
    private SimpleFSLockFactory lockFactory;
    public static final String SNAP_DIR = "snapDir";
    public static final String DATE_FMT = "yyyyMMddHHmmss";

    public SnapShooter(SolrCore core, String location) throws IOException {
        this.solrCore = core;
        if (location == null) {
            this.snapDir = core.getDataDir();
        } else {
            File base = new File(core.getCoreDescriptor().getInstanceDir());
            this.snapDir = FileUtils.resolvePath((File)base, (String)location).getAbsolutePath();
            File dir = new File(this.snapDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        this.lockFactory = new SimpleFSLockFactory(this.snapDir);
    }

    void createSnapAsync(final IndexCommit indexCommit, final ReplicationHandler replicationHandler) {
        replicationHandler.core.getDeletionPolicy().saveCommitPoint(indexCommit.getVersion());
        new Thread(){

            public void run() {
                SnapShooter.this.createSnapshot(indexCommit, replicationHandler);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createSnapshot(IndexCommit indexCommit, ReplicationHandler replicationHandler) {
        details = new NamedList();
        details.add("startTime", (Object)new Date().toString());
        snapShotDir = null;
        directoryName = null;
        lock = null;
        try {
            block12: {
                block11: {
                    fmt = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
                    directoryName = "snapshot." + fmt.format(new Date());
                    lock = this.lockFactory.makeLock(directoryName + ".lock");
                    if (!lock.isLocked()) break block11;
                    var11_9 = null;
                    replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getVersion());
                    replicationHandler.snapShootDetails = details;
                    if (lock == null) return;
                    ** GOTO lbl60
                }
                snapShotDir = new File(this.snapDir, directoryName);
                if (snapShotDir.mkdir()) break block12;
                SnapShooter.LOG.warn("Unable to create snapshot directory: " + snapShotDir.getAbsolutePath());
                ** GOTO lbl66
            }
            files = indexCommit.getFileNames();
            fileCopier = new FileCopier(this.solrCore.getDeletionPolicy(), indexCommit);
            fileCopier.copyFiles(files, snapShotDir);
            details.add("fileCount", (Object)files.size());
            details.add("status", (Object)"success");
            details.add("snapshotCompletedAt", (Object)new Date().toString());
            ** GOTO lbl76
        }
        catch (Exception e) {
            SnapPuller.delTree(snapShotDir);
            SnapShooter.LOG.error("Exception while creating snapshot", (Throwable)e);
            details.add("snapShootException", (Object)e.getMessage());
            var11_12 = null;
            replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getVersion());
            replicationHandler.snapShootDetails = details;
            if (lock == null) return;
            try {
                lock.release();
                return;
            }
            catch (IOException e) {
                SnapShooter.LOG.error("Unable to release snapshoot lock: " + directoryName + ".lock");
                return;
            }
        }
        {
            catch (Throwable var10_21) {
                var11_13 = null;
                replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getVersion());
                replicationHandler.snapShootDetails = details;
                if (lock == null) throw var10_21;
                ** try [egrp 2[TRYBLOCK] [8 : 331->339)] { 
lbl55:
                // 1 sources

                lock.release();
                throw var10_21;
lbl57:
                // 1 sources

                catch (IOException e) {
                    SnapShooter.LOG.error("Unable to release snapshoot lock: " + directoryName + ".lock");
                }
                throw var10_21;
            }
lbl60:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [8 : 331->339)] { 
lbl61:
            // 1 sources

            lock.release();
            return;
lbl63:
            // 1 sources

            catch (IOException e) {
                SnapShooter.LOG.error("Unable to release snapshoot lock: " + directoryName + ".lock");
            }
            return;
lbl66:
            // 1 sources

            var11_10 = null;
            replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getVersion());
            replicationHandler.snapShootDetails = details;
            if (lock == null) return;
            ** try [egrp 2[TRYBLOCK] [8 : 331->339)] { 
lbl71:
            // 1 sources

            lock.release();
            return;
lbl73:
            // 1 sources

            catch (IOException e) {
                SnapShooter.LOG.error("Unable to release snapshoot lock: " + directoryName + ".lock");
            }
            return;
lbl76:
            // 1 sources

            var11_11 = null;
            replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getVersion());
            replicationHandler.snapShootDetails = details;
            if (lock == null) return;
            try {}
            catch (IOException e) {}
            SnapShooter.LOG.error("Unable to release snapshoot lock: " + directoryName + ".lock");
            return;
            lock.release();
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileCopier {
        private static final int DEFAULT_BUFFER_SIZE = 32768;
        private byte[] buffer = new byte[32768];
        private IndexCommit indexCommit;
        private IndexDeletionPolicyWrapper delPolicy;

        public FileCopier(IndexDeletionPolicyWrapper delPolicy, IndexCommit commit) {
            this.delPolicy = delPolicy;
            this.indexCommit = commit;
        }

        public void copyFiles(Collection<String> files, File destDir) throws IOException {
            for (String indexFile : files) {
                File source = new File(SnapShooter.this.solrCore.getIndexDir(), indexFile);
                this.copyFile(source, new File(destDir, source.getName()), true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyFile(File source, File destination, boolean preserveFileDate) throws IOException {
            if (!source.exists()) {
                String message = "File " + source + " does not exist";
                throw new FileNotFoundException(message);
            }
            if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            if (destination.exists() && !destination.canWrite()) {
                String message = "Unable to open file " + destination + " for writing.";
                throw new IOException(message);
            }
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                input = new FileInputStream(source);
                output = new FileOutputStream(destination);
                int count = 0;
                int n = 0;
                int rcnt = 0;
                while (-1 != (n = input.read(this.buffer))) {
                    output.write(this.buffer, 0, n);
                    count += n;
                    ++rcnt;
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    IOUtils.closeQuietly((InputStream)input);
                    Object var12_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_17 = null;
                    IOUtils.closeQuietly((OutputStream)output);
                    throw throwable2;
                }
                IOUtils.closeQuietly((OutputStream)output);
                throw throwable;
            }
            try {
                IOUtils.closeQuietly((InputStream)input);
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                IOUtils.closeQuietly((OutputStream)output);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
            if (source.length() != destination.length()) {
                String message = "Failed to copy full contents from " + source + " to " + destination;
                throw new IOException(message);
            }
            if (preserveFileDate) {
                destination.setLastModified(source.lastModified());
            }
        }
    }
}

