/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.search;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.chorem.vradi.services.search.QueryHandler;
import org.chorem.vradi.services.search.UnsupportedQueryException;

public class LuceneQueryParser {
    private static final Log log = LogFactory.getLog(LuceneQueryParser.class);
    protected final QueryHandler termsFactory;
    protected BooleanClause booleanClause = null;

    public LuceneQueryParser(QueryHandler termsFactory) {
        this.termsFactory = termsFactory;
    }

    public synchronized void parse(Query query) throws UnsupportedQueryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("parse: " + query));
        }
        if (query instanceof BooleanQuery) {
            this.render((BooleanQuery)query);
        } else if (query instanceof PrefixQuery) {
            this.render((PrefixQuery)query);
        } else if (query instanceof TermQuery) {
            this.render((TermQuery)query);
        } else if (query instanceof PhraseQuery) {
            this.render((PhraseQuery)query);
        } else if (query instanceof WildcardQuery) {
            this.render((WildcardQuery)query);
        } else if (query instanceof TermRangeQuery) {
            this.render((TermRangeQuery)query);
        } else {
            throw new UnsupportedQueryException(query);
        }
    }

    protected void render(BooleanQuery query) throws UnsupportedQueryException {
        BooleanClause[] booleanClauses = query.getClauses();
        this.booleanClause = booleanClauses[0];
        this.termsFactory.group(this.booleanClause);
        for (int i = 0; i < booleanClauses.length; ++i) {
            this.booleanClause = booleanClauses[i];
            this.parse(this.booleanClause.getQuery());
        }
        this.termsFactory.ungroup();
    }

    protected void render(TermQuery query) {
        this.termsFactory.termQuery(query, this.booleanClause);
    }

    protected void render(PrefixQuery query) {
        this.termsFactory.prefixQuery(query, this.booleanClause);
    }

    protected void render(WildcardQuery query) {
        this.termsFactory.wildcardQuery(query, this.booleanClause);
    }

    protected void render(TermRangeQuery query) {
        this.termsFactory.rangeQuery(query, this.booleanClause);
    }

    protected void render(PhraseQuery query) {
        Term term;
        Term[] terms = query.getTerms();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < terms.length; ++i) {
            term = terms[i];
            sb.append(term.text()).append(" ");
        }
        String toString = sb.toString().trim();
        term = new Term(terms[0].field(), toString);
        this.render(new TermQuery(term));
    }
}

