/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.managers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.beans.SendingHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.FileService;
import org.chorem.vradi.services.FileServiceImpl;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.managers.FormTypeManager;
import org.chorem.vradi.services.managers.TemplateManager;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MailingManager {
    private static final Log log = LogFactory.getLog(MailingManager.class);
    protected static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    protected ApplicationConfig config;
    protected WikittyProxy wikittyProxy;
    protected FileService fileService;
    protected FormTypeManager formTypeManager;

    public MailingManager(ApplicationConfig config, WikittyProxy wikittyProxy, FormTypeManager formTypeManager) {
        this.config = config;
        this.wikittyProxy = wikittyProxy;
        this.fileService = new FileServiceImpl(config);
        this.formTypeManager = formTypeManager;
    }

    public String postMail(String recipient, String subject, String message, List<Form> forms, boolean receptionProof, Collection<File> attachedFiles) throws VradiException {
        String result;
        if (StringUtils.isBlank((String)recipient) || message == null && (forms == null || forms.isEmpty())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n._((String)"Nothing to send : %s", (Object[])new Object[]{recipient}));
            }
            return null;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", VradiServiceConfigurationHelper.getSmtpHost(this.config));
        props.put("mail.smtp.port", (Object)VradiServiceConfigurationHelper.getSmtpPort(this.config));
        javax.mail.Session session = javax.mail.Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(VradiServiceConfigurationHelper.getMailUser(MailingManager.this.config), VradiServiceConfigurationHelper.getMailPassword(MailingManager.this.config));
            }
        });
        MimeMessage msg = new MimeMessage(session);
        try {
            FileDataSource source;
            MimeBodyPart msgCurrentPdfPart;
            InternetAddress addressFrom = new InternetAddress(VradiServiceConfigurationHelper.getMailFrom(this.config), VradiServiceConfigurationHelper.getMailFromName(this.config));
            msg.setFrom((Address)addressFrom);
            InternetAddress addressTo = new InternetAddress(recipient);
            msg.addRecipient(Message.RecipientType.TO, (Address)addressTo);
            if (receptionProof) {
                msg.addHeader("Return-Receipt-To", VradiServiceConfigurationHelper.getMailFrom(this.config));
                msg.addHeader("Disposition-Notification-To", VradiServiceConfigurationHelper.getMailFrom(this.config));
            }
            MimeMultipart multiparts = new MimeMultipart();
            MimeBodyPart msgBodyPart = new MimeBodyPart();
            msgBodyPart.setText(message);
            multiparts.addBodyPart((BodyPart)msgBodyPart);
            int count = 0;
            if (forms != null) {
                for (Form form : forms) {
                    File formFile = this.getGeneratedPdfFile(form);
                    if (formFile.exists()) {
                        msgCurrentPdfPart = new MimeBodyPart();
                        msgCurrentPdfPart.setHeader("Content-Type", "application/pdf");
                        source = new FileDataSource(formFile);
                        msgCurrentPdfPart.setDataHandler(new DataHandler((DataSource)source));
                        msgCurrentPdfPart.setFileName(formFile.getName());
                        multiparts.addBodyPart((BodyPart)msgCurrentPdfPart);
                        ++count;
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("No pdf attachment found for form : " + form.getObjet()));
                }
            }
            if (count == 0) {
                throw new VradiException(I18n._((String)"vradi.error.sending.noAttachedPDF", (Object[])new Object[0]));
            }
            if (attachedFiles != null && !attachedFiles.isEmpty()) {
                for (File file : attachedFiles) {
                    String mineType;
                    try {
                        mineType = this.getMineType(file);
                    }
                    catch (Exception eee) {
                        log.error((Object)("Failled to get mine type of file : " + file.getName()), (Throwable)eee);
                        mineType = "application/octet-stream";
                    }
                    msgCurrentPdfPart = new MimeBodyPart();
                    msgCurrentPdfPart.setHeader("Content-Type", mineType);
                    source = new FileDataSource(file);
                    msgCurrentPdfPart.setDataHandler(new DataHandler((DataSource)source));
                    msgCurrentPdfPart.setFileName(file.getName());
                    multiparts.addBodyPart((BodyPart)msgCurrentPdfPart);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Sending with attached file : " + file.getName()));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"Sending with no attached file");
            }
            msg.setContent((Multipart)multiparts);
            msg.setSubject(subject);
            try {
                Transport.send((Message)msg);
            }
            catch (MessagingException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Cant send mail", (Throwable)eee);
                }
                if (eee.getCause() instanceof SendFailedException) {
                    SendFailedException exception = (SendFailedException)eee.getCause();
                    throw new VradiException(I18n._((String)"SMTP fail to send mail :\n(%s)", (Object[])new Object[]{exception.getLocalizedMessage()}), eee);
                }
                throw new VradiException("Can't send message", eee);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("MessageID: " + msg.getMessageID()));
            }
            result = msg.getMessageID();
        }
        catch (MessagingException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
            throw new VradiException(I18n._((String)"vradi.error.sending.send", (Object[])new Object[]{eee.getMessage()}));
        }
        catch (UnsupportedEncodingException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
            throw new VradiException(I18n._((String)"vradi.error.sending.generation", (Object[])new Object[]{eee.getMessage()}));
        }
        return result;
    }

    public void receiveMails() throws VradiException {
        try {
            Message[] messages;
            Properties props = new Properties();
            String imapHost = VradiServiceConfigurationHelper.getImapHost(this.config);
            if (imapHost == null) {
                log.warn((Object)"imap is not configured, abording");
                return;
            }
            final String mailUser = VradiServiceConfigurationHelper.getMailUser(this.config);
            int imapPort = VradiServiceConfigurationHelper.getImapPort(this.config);
            props.put("mail.imap.host", imapHost);
            props.put("mail.imap.auth", "true");
            props.put("mail.imap.user", mailUser);
            props.put("mail.imap.port", (Object)imapPort);
            props.put("mail.store.protocol", "imap");
            javax.mail.Session session = javax.mail.Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mailUser, VradiServiceConfigurationHelper.getMailPassword(MailingManager.this.config));
                }
            });
            Store store = session.getStore("imap");
            store.connect(imapHost, mailUser, VradiServiceConfigurationHelper.getMailPassword(this.config));
            Folder folder = store.getFolder("INBOX");
            folder.open(2);
            FlagTerm flagTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            for (Message message : messages = folder.search((SearchTerm)flagTerm)) {
                if (message.getContentType().startsWith("multipart/")) {
                    boolean markAsRead = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Testing message " + Arrays.toString(message.getHeader("Message-ID")) + " as multipart"));
                    }
                    Multipart multiPart = (Multipart)message.getContent();
                    String errorMessage = null;
                    String errorMessageId = null;
                    String originalMessageID = null;
                    for (int index = 0; index < multiPart.getCount(); ++index) {
                        String content;
                        BodyPart bodyPart = multiPart.getBodyPart(index);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Part " + index + " : " + bodyPart.getContentType()));
                        }
                        if ("message/delivery-status".equals(bodyPart.getContentType())) {
                            content = this.getStreamContent(bodyPart.getInputStream());
                            errorMessage = this.getHeaderValueInContent("Diagnostic-Code", content);
                        }
                        if ("text/rfc822-headers".equals(bodyPart.getContentType())) {
                            content = this.getStreamContent(bodyPart.getInputStream());
                            errorMessageId = this.getHeaderValueInContent("Message-ID", content);
                        }
                        if (!bodyPart.getContentType().startsWith("message/disposition-notification")) continue;
                        content = this.getStreamContent(bodyPart.getInputStream());
                        originalMessageID = this.getHeaderValueInContent("Original-Message-ID", content);
                    }
                    if (StringUtils.isNotEmpty(errorMessage) && StringUtils.isNotEmpty(errorMessageId)) {
                        Sending sending;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Error message received for message " + errorMessageId));
                            log.info((Object)(" error description : " + errorMessage));
                        }
                        if ((sending = MailingManager.getSendingByMessageID(errorMessageId, this.wikittyProxy)) != null) {
                            sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
                            this.wikittyProxy.store((BusinessEntity)sending);
                            markAsRead = true;
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't find sending for message id : " + errorMessageId));
                        }
                    } else if (StringUtils.isNotEmpty(originalMessageID)) {
                        Sending sending;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Proof notification received for message " + originalMessageID));
                        }
                        if ((sending = MailingManager.getSendingByMessageID(originalMessageID, this.wikittyProxy)) != null) {
                            if (VradiConstants.SendingStatus.isWaitingReceptionProof(sending)) {
                                sending.setStatus(VradiConstants.SendingStatus.RECEIVED.getValue());
                                sending.setReceptionDate(new Date());
                                this.wikittyProxy.store((BusinessEntity)sending);
                                this.setValidEmailForUser(sending);
                                markAsRead = true;
                            } else if (log.isWarnEnabled()) {
                                log.warn((Object)"Received a reception proof for a sending with non reception proof waiting status");
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't find sending for message id : " + originalMessageID));
                        }
                    }
                    message.setFlag(Flags.Flag.SEEN, markAsRead);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Mail inbox contains non multipart mails !");
            }
            folder.close(true);
            store.close();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't recieve messages", (Throwable)e);
            }
            throw new VradiException("Can't recieve messages", e);
        }
    }

    protected void setValidEmailForUser(Sending sending) {
        String userId = sending.getUser();
        User user = (User)this.wikittyProxy.restore(User.class, userId);
        if (user != null && !user.getValidEmail()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("User email " + user.getEmail() + " has been validated"));
            }
            user.setValidEmail(true);
            this.wikittyProxy.store((BusinessEntity)user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStreamContent(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            inputStream.close();
        }
        return sb.toString();
    }

    protected String getHeaderValueInContent(String headerName, String content) {
        String result = null;
        String headerText = headerName + ":";
        int firstIndex = content.indexOf(headerText) + headerText.length();
        int lastIndex = content.indexOf("\n", firstIndex);
        if (lastIndex == -1) {
            lastIndex = content.length();
        }
        result = content.substring(firstIndex, lastIndex);
        result = result.trim();
        return result;
    }

    protected static Sending getSendingByMessageID(String messageID, WikittyProxy proxy) {
        Sending result = null;
        Search search = Search.query();
        search.eq(Element.ELT_EXTENSION, "Sending").eq("Sending.messageId", messageID);
        Criteria criteria = search.criteria();
        PagedResult sendingsResult = proxy.findAllByCriteria(Sending.class, criteria);
        List sendingList = sendingsResult.getAll();
        if (sendingList.size() == 1) {
            result = (Sending)sendingList.get(0);
        }
        return result;
    }

    public File getGeneratedPdfFile(Form form) {
        String filename = form.getWikittyId() + "-" + form.getWikittyVersion() + ".pdf";
        File pdfDir = VradiServiceConfigurationHelper.getPdfDir(this.config);
        File result = new File(pdfDir, filename);
        return result;
    }

    protected String getMineType(File file) throws IOException, SAXException, TikaException {
        FileInputStream is = new FileInputStream(file);
        BodyContentHandler contenthandler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        metadata.set("resourceName", file.getName());
        AutoDetectParser parser = new AutoDetectParser();
        parser.parse((InputStream)is, (ContentHandler)contenthandler, metadata);
        String result = metadata.get("Content-Type");
        log.info((Object)("Mine type of " + file.getName() + " is : " + result));
        return result;
    }

    public void generatePDFForSession(String sessionId) throws VradiException {
        ArrayList<String> formsIdsToGenerate = new ArrayList<String>();
        Session session = (Session)this.wikittyProxy.restore(Session.class, sessionId);
        Set<String> sendingIds = session.getSending();
        if (sendingIds == null) {
            return;
        }
        for (String id : sendingIds) {
            Set<String> formsIds;
            Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, id);
            if (sending == null || (formsIds = SendingHelper.extractForms(this.wikittyProxy, sending.getGroupForms())) == null) continue;
            for (String formId : formsIds) {
                if (formsIdsToGenerate.contains(formId)) continue;
                formsIdsToGenerate.add(formId);
            }
        }
        for (String formId : formsIdsToGenerate) {
            try {
                this.generatePDF(formId, true);
            }
            catch (VradiException eee) {
                throw new VradiException("An error occurred while generating PDF file for form : " + formId, eee);
            }
        }
    }

    public String generatePDF(String formId, boolean force) throws VradiException {
        String uri = null;
        String extensionName = null;
        Form form = (Form)this.wikittyProxy.restore(Form.class, formId);
        for (String ext : form.getExtensionNames()) {
            if (ext.equals("Infogene") || ext.equals("Form")) continue;
            extensionName = ext;
            break;
        }
        WikittyExtension extension = this.formTypeManager.getFormType(extensionName);
        String template = extension.getTagValue(VradiConstants.FormTypeTemplateEnum.FIELD_TEMPLATE_ATTRIBUTE.getValue());
        File templateFile = this.formTypeManager.getTemplate(extensionName, template);
        Map<String, String> fieldMap = this.formTypeManager.getAssociatedFields(extension.getName(), template);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating PDF file for form " + form.getWikittyId() + " (template = " + template + ")"));
        }
        try {
            List<Form> currentForms = Collections.singletonList(form);
            List<File> filesToAdd = this.generateFilledDocumentInPDF(templateFile, currentForms, fieldMap, force);
            if (filesToAdd != null && !filesToAdd.isEmpty()) {
                uri = filesToAdd.get(0).getName();
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate pdf", (Throwable)ex);
            }
            throw new VradiException("Can't generate pdf", ex);
        }
        return uri;
    }

    protected List<File> generateFilledDocumentInPDF(File template, List<Form> forms, Map<String, String> fieldBindings, boolean replace) throws VradiException {
        ArrayList<File> generatedPDFList = null;
        if (template == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Try to generate form pdf without template");
            }
        } else if (fieldBindings == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No association field found, abording");
            }
        } else {
            TemplateManager templateManager = new TemplateManager(this.config, template);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (Map.Entry<String, String> binding : fieldBindings.entrySet()) {
                String fieldFQName = binding.getValue();
                if (fieldFQName == null || fieldFQName.indexOf(".") <= 0) continue;
                int dot = fieldFQName.indexOf(".");
                String[] fqField = new String[]{fieldFQName.substring(0, dot), fieldFQName.substring(dot + 1)};
                map.put(binding.getKey(), fqField);
            }
            generatedPDFList = new ArrayList<File>();
            for (Form form : forms) {
                File f = this.generateFilledDocumentInPDF(templateManager, form, map, replace);
                generatedPDFList.add(f);
            }
        }
        return generatedPDFList;
    }

    protected File generateFilledDocumentInPDF(TemplateManager templateManager, Form form, Map<String, String[]> fieldBindings, boolean replace) throws VradiException {
        File result = this.getGeneratedPdfFile(form);
        if (!replace && result.exists()) {
            return result;
        }
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> binding : fieldBindings.entrySet()) {
            String[] fqField = binding.getValue();
            Object value = form.getField(fqField[0], fqField[1]);
            fieldValues.put(binding.getKey(), value);
        }
        ArrayList<String> formUrls = new ArrayList<String>();
        if (form.getFiles() != null) {
            for (String file : form.getFiles()) {
                String formUrl = this.fileService.getFormEmbeddedUrl(file, form.getWikittyId());
                formUrls.add(formUrl);
            }
        }
        templateManager.generateDoc(result.getPath(), fieldValues, formUrls.toArray(new String[formUrls.size()]));
        return result;
    }

    public String sendMessages(String sessionId) throws VradiException {
        Session session = (Session)this.wikittyProxy.restore(Session.class, sessionId);
        if (VradiConstants.SessionStatus.isSent(session)) {
            return "";
        }
        if (VradiConstants.SessionStatus.isToRestart(session)) {
            log.info((Object)"Session was stopped or in error, resume sending");
            session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
            session.setSessionLogs("");
            session = (Session)this.wikittyProxy.store((BusinessEntity)session);
        }
        Set<String> filesNames = session.getFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (filesNames != null) {
            for (String fileName : filesNames) {
                File file = this.fileService.downloadSessionAttachment(fileName, sessionId);
                files.add(file);
                log.info((Object)("Files founds for session : " + session.getSessionDate() + " : " + (file == null ? "not found" : file.getName())));
            }
        }
        ArrayList<String> sessionLogger = new ArrayList<String>();
        Set<String> sendingIds = session.getSending();
        if (sendingIds != null) {
            for (String sendingId : sendingIds) {
                String log;
                Sending sending;
                if (VradiConstants.SessionStatus.isStopped(session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId()))) {
                    MailingManager.log.warn((Object)"Sending stopped by user");
                    sessionLogger.add(I18n._((String)"vradi.error.session.stopped", (Object[])new Object[]{session.getNum(), DateUtil.formatDate((Date)session.getSessionDate(), (String)"dd/MM/yyyy")}));
                }
                if ((sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId)) == null) continue;
                if (VradiConstants.SendingStatus.isSent(sending)) {
                    if (!MailingManager.log.isDebugEnabled()) continue;
                    MailingManager.log.debug((Object)("Sending " + sendingId + " already sent, skip"));
                    continue;
                }
                if (!VradiConstants.SendingStatus.isToSend(sending) || (log = this.sendMessage(sendingId, session.getParagraph(), null, false, files)) == null) continue;
                sessionLogger.add(log);
            }
        }
        String formatedLogs = this.formatSessionLog(sessionLogger);
        if (sessionLogger.isEmpty()) {
            session.setStatus(VradiConstants.SessionStatus.SENT.getValue());
            session.setSessionLogs("");
        } else {
            session.setStatus(VradiConstants.SessionStatus.ERROR.getValue());
            session.setSessionLogs(formatedLogs);
        }
        session.setSessionDate(new Date());
        this.wikittyProxy.store((BusinessEntity)session);
        return formatedLogs;
    }

    protected String formatSessionLog(List<String> logs) {
        return StringUtils.join(logs, (String)",\n");
    }

    public String sendMessage(String sendingId, String sessionParagraph, String email, boolean reSend, Collection<File> filesToAttach) throws VradiException {
        String messageId;
        Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId);
        User user = (User)this.wikittyProxy.restore(User.class, sending.getUser());
        if (!reSend && !VradiConstants.SendingStatus.isToSend(sending)) {
            return null;
        }
        Set<String> formsIds = SendingHelper.extractForms(this.wikittyProxy, sending.getGroupForms());
        if (formsIds.isEmpty()) {
            sending.setStatus(VradiConstants.SendingStatus.DELETED.getValue());
            this.wikittyProxy.store((BusinessEntity)sending);
            return null;
        }
        if (StringUtils.isBlank((String)email) && StringUtils.isBlank((String)(email = user.getEmail()))) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("User " + user.getName() + " has not valid email (skip current mail sending)"));
            }
            sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
            this.wikittyProxy.store((BusinessEntity)sending);
            return I18n._((String)"vradi.error.sending.emailIsBlank", (Object[])new Object[]{user.getName()});
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending message to " + email));
        }
        String subject = VradiServiceConfigurationHelper.getOfferMailSubject(this.config);
        String message = sessionParagraph + "\n\n" + sending.getParagraph();
        List forms = this.wikittyProxy.restore(Form.class, new ArrayList<String>(formsIds));
        boolean receptionProof = sending.getReceptionProof();
        try {
            messageId = this.postMail(email, subject, message, forms, receptionProof, filesToAttach);
        }
        catch (VradiException eee) {
            log.error((Object)("Failed to send sending for email : " + email), (Throwable)eee);
            sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
            this.wikittyProxy.store((BusinessEntity)sending);
            return I18n._((String)"vradi.error.sending.failedToSend", (Object[])new Object[]{user.getName(), eee.getMessage()});
        }
        sending.setMessageId(messageId);
        sending.setStatus(receptionProof ? VradiConstants.SendingStatus.WAITING_RECEPTION_PROOF.getValue() : VradiConstants.SendingStatus.SENT.getValue());
        this.wikittyProxy.store((BusinessEntity)sending);
        return null;
    }
}

