/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Byte;;
import [Ljava.lang.Character;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Short;;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.runtime.ClosureListener;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;

public class MetaClassHelper {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static Class[] EMPTY_TYPE_ARRAY = new Class[0];
    protected static final Object[] ARRAY_WITH_NULL = new Object[]{null};
    protected static final Logger log = Logger.getLogger(MetaClassHelper.class.getName());
    private static final int MAX_ARG_LEN = 12;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean accessibleToConstructor(Class at, Constructor constructor) {
        boolean accessible = false;
        if (Modifier.isPublic(constructor.getModifiers())) {
            accessible = true;
        } else if (Modifier.isPrivate(constructor.getModifiers())) {
            accessible = at.getName().equals(constructor.getName());
        } else if (Modifier.isProtected(constructor.getModifiers())) {
            if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() == null) {
                accessible = true;
            } else if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() != null) {
                accessible = false;
            } else if (at.getPackage() != null && constructor.getDeclaringClass().getPackage() == null) {
                accessible = false;
            } else if (at.getPackage().equals(constructor.getDeclaringClass().getPackage())) {
                accessible = true;
            } else {
                boolean flag = false;
                for (Class clazz = at; !flag && clazz != null; clazz = clazz.getSuperclass()) {
                    if (clazz.equals(constructor.getDeclaringClass())) {
                        flag = true;
                        break;
                    }
                    if (clazz.equals(class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) break;
                }
                accessible = flag;
            }
        } else if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() == null) {
            accessible = true;
        } else if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() != null) {
            accessible = false;
        } else if (at.getPackage() != null && constructor.getDeclaringClass().getPackage() == null) {
            accessible = false;
        } else if (at.getPackage().equals(constructor.getDeclaringClass().getPackage())) {
            accessible = true;
        }
        return accessible;
    }

    public static Object[] asWrapperArray(Object parameters, Class componentType) {
        Object[] ret;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        ret = null;
                                        if (componentType != Boolean.TYPE) break block8;
                                        boolean[] array = (boolean[])parameters;
                                        ret = new Object[array.length];
                                        for (int i = 0; i < array.length; ++i) {
                                            ret[i] = new Boolean(array[i]);
                                        }
                                        break block9;
                                    }
                                    if (componentType != Character.TYPE) break block10;
                                    char[] array = (char[])parameters;
                                    ret = new Object[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        ret[i] = new Character(array[i]);
                                    }
                                    break block9;
                                }
                                if (componentType != Byte.TYPE) break block11;
                                byte[] array = (byte[])parameters;
                                ret = new Object[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    ret[i] = new Byte(array[i]);
                                }
                                break block9;
                            }
                            if (componentType != Integer.TYPE) break block12;
                            int[] array = (int[])parameters;
                            ret = new Object[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                ret[i] = new Integer(array[i]);
                            }
                            break block9;
                        }
                        if (componentType != Short.TYPE) break block13;
                        short[] array = (short[])parameters;
                        ret = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            ret[i] = new Short(array[i]);
                        }
                        break block9;
                    }
                    if (componentType != Long.TYPE) break block14;
                    long[] array = (long[])parameters;
                    ret = new Object[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        ret[i] = new Long(array[i]);
                    }
                    break block9;
                }
                if (componentType != Double.TYPE) break block15;
                double[] array = (double[])parameters;
                ret = new Object[array.length];
                for (int i = 0; i < array.length; ++i) {
                    ret[i] = new Double(array[i]);
                }
                break block9;
            }
            if (componentType != Float.TYPE) break block9;
            float[] array = (float[])parameters;
            ret = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                ret[i] = new Float(array[i]);
            }
        }
        return ret;
    }

    public static Object asPrimitiveArray(List list, Class parameterType) {
        Class<?> arrayType = parameterType.getComponentType();
        Object objArray = Array.newInstance(arrayType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (arrayType.isPrimitive()) {
                if (obj instanceof Integer) {
                    Array.setInt(objArray, i, (Integer)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    Array.setDouble(objArray, i, (Double)obj);
                    continue;
                }
                if (obj instanceof Boolean) {
                    Array.setBoolean(objArray, i, (Boolean)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    Array.setLong(objArray, i, (Long)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    Array.setFloat(objArray, i, ((Float)obj).floatValue());
                    continue;
                }
                if (obj instanceof Character) {
                    Array.setChar(objArray, i, ((Character)obj).charValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    Array.setByte(objArray, i, (Byte)obj);
                    continue;
                }
                if (!(obj instanceof Short)) continue;
                Array.setShort(objArray, i, (Short)obj);
                continue;
            }
            Array.set(objArray, i, obj);
        }
        return objArray;
    }

    protected static Class autoboxType(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }

    public static int calculateParameterDistance(Class[] arguments, Class[] parameters) {
        int dist = 0;
        block0: for (int i = 0; i < arguments.length; ++i) {
            Class clazz;
            if (parameters[i] == arguments[i]) continue;
            if (parameters[i].isInterface()) {
                dist += 3;
                continue;
            }
            if (arguments[i] != null) {
                if (MetaClassHelper.autoboxType(parameters[i]) == MetaClassHelper.autoboxType(arguments[i])) {
                    ++dist;
                    continue;
                }
                if (arguments[i].isPrimitive() || parameters[i].isPrimitive()) {
                    dist += 2;
                    continue;
                }
                ++dist;
                clazz = arguments[i];
                while (clazz != null && clazz != parameters[i]) {
                    if (clazz == (class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString) && parameters[i] == (class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String)) {
                        dist += 2;
                        continue block0;
                    }
                    clazz = clazz.getSuperclass();
                    dist += 3;
                }
                continue;
            }
            --dist;
            clazz = parameters[i];
            if (clazz.isPrimitive()) {
                dist += 2;
                continue;
            }
            while (clazz != (class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) {
                clazz = clazz.getSuperclass();
                dist += 2;
            }
        }
        return dist;
    }

    public static String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
    }

    public static Object chooseEmptyMethodParams(List methods) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 0) continue;
            return method;
        }
        return null;
    }

    public static Object chooseMostGeneralMethodWith1NullParam(List methods) {
        Class closestClass = null;
        Object answer = null;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Class theType;
            Object method = iter.next();
            Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 1 || (theType = paramTypes[0]).isPrimitive() || closestClass != null && !MetaClassHelper.isAssignableFrom(theType, closestClass)) continue;
            closestClass = theType;
            answer = method;
        }
        return answer;
    }

    protected static Object coerceGString(Object argument, Class clazz) {
        if (clazz != String.class) {
            return argument;
        }
        if (!(argument instanceof GString)) {
            return argument;
        }
        return argument.toString();
    }

    protected static Object coerceNumber(Object argument, Class param) {
        if ((Number.class.isAssignableFrom(param) || param.isPrimitive()) && argument instanceof Number) {
            Object oldArgument = argument;
            boolean wasDouble = false;
            boolean wasFloat = false;
            if (param == Byte.class || param == Byte.TYPE) {
                argument = new Byte(((Number)argument).byteValue());
            } else if (param == Double.class || param == Double.TYPE) {
                wasDouble = true;
                argument = new Double(((Number)argument).doubleValue());
            } else if (param == Float.class || param == Float.TYPE) {
                wasFloat = true;
                argument = new Float(((Number)argument).floatValue());
            } else if (param == Integer.class || param == Integer.TYPE) {
                argument = new Integer(((Number)argument).intValue());
            } else if (param == Long.class || param == Long.TYPE) {
                argument = new Long(((Number)argument).longValue());
            } else if (param == Short.class || param == Short.TYPE) {
                argument = new Short(((Number)argument).shortValue());
            } else if (param == BigDecimal.class) {
                argument = new BigDecimal(String.valueOf((Number)argument));
            } else if (param == BigInteger.class) {
                argument = new BigInteger(String.valueOf((Number)argument));
            }
            if (oldArgument instanceof BigDecimal) {
                BigDecimal oldbd = (BigDecimal)oldArgument;
                boolean throwException = false;
                if (wasDouble) {
                    Double d = (Double)argument;
                    if (d.isInfinite()) {
                        throwException = true;
                    }
                } else if (wasFloat) {
                    Float f = (Float)argument;
                    if (f.isInfinite()) {
                        throwException = true;
                    }
                } else {
                    BigDecimal newbd = new BigDecimal(String.valueOf((Number)argument));
                    boolean bl = throwException = !oldArgument.equals(newbd);
                }
                if (throwException) {
                    throw new IllegalArgumentException(param + " out of range while converting from BigDecimal");
                }
            }
        }
        return argument;
    }

    protected static Object coerceArray(Object argument, Class param) {
        if (!param.isArray()) {
            return argument;
        }
        Class<?> argumentClass = argument.getClass();
        if (!argumentClass.isArray()) {
            return argument;
        }
        Class<?> paramComponent = param.getComponentType();
        if (paramComponent.isPrimitive()) {
            if (paramComponent == Boolean.TYPE && argumentClass == Boolean;.class) {
                argument = InvokerHelper.convertToBooleanArray(argument);
            } else if (paramComponent == Byte.TYPE && argumentClass == Byte;.class) {
                argument = InvokerHelper.convertToByteArray(argument);
            } else if (paramComponent == Character.TYPE && argumentClass == Character;.class) {
                argument = InvokerHelper.convertToCharArray(argument);
            } else if (paramComponent == Short.TYPE && argumentClass == Short;.class) {
                argument = InvokerHelper.convertToShortArray(argument);
            } else if (paramComponent == Integer.TYPE && argumentClass == Integer;.class) {
                argument = InvokerHelper.convertToIntArray(argument);
            } else if (paramComponent == Long.TYPE && (argumentClass == Long;.class || argumentClass == Integer;.class)) {
                argument = InvokerHelper.convertToLongArray(argument);
            } else if (paramComponent == Float.TYPE && (argumentClass == Float;.class || argumentClass == Integer;.class)) {
                argument = InvokerHelper.convertToFloatArray(argument);
            } else if (paramComponent == Double.TYPE && (argumentClass == Double;.class || argumentClass == Float;.class || BigDecimal.class.isAssignableFrom(argumentClass))) {
                argument = InvokerHelper.convertToDoubleArray(argument);
            }
        } else if (paramComponent == String.class && argument instanceof GString[]) {
            GString[] strings = (GString[])argument;
            String[] ret = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ret[i] = strings[i].toString();
            }
            argument = ret;
        }
        return argument;
    }

    public static boolean containsMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Class[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            Class[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static Class[] convertToTypeArray(Object[] args) {
        if (args == null) {
            return null;
        }
        int s = args.length;
        Class[] ans = new Class[s];
        for (int i = 0; i < s; ++i) {
            Object o = args[i];
            ans[i] = o != null ? o.getClass() : null;
        }
        return ans;
    }

    public static Object createListenerProxy(Class listenerType, String listenerMethodName, Closure closure) {
        ClosureListener handler = new ClosureListener(listenerMethodName, closure);
        return Proxy.newProxyInstance(listenerType.getClassLoader(), new Class[]{listenerType}, (InvocationHandler)handler);
    }

    public static Object doConstructorInvoke(Constructor constructor, Object[] argumentArray) {
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(constructor.getDeclaringClass(), constructor.getName(), argumentArray);
        }
        argumentArray = MetaClassHelper.coerceArgumentsToClasses(argumentArray, constructor.getParameterTypes());
        try {
            return constructor.newInstance(argumentArray);
        }
        catch (InvocationTargetException e) {
            throw new InvokerInvocationException(e);
        }
        catch (IllegalArgumentException e) {
            throw MetaClassHelper.createExceptionText("failed to invoke constructor: ", constructor, argumentArray, e, false);
        }
        catch (IllegalAccessException e) {
            throw MetaClassHelper.createExceptionText("could not access constructor: ", constructor, argumentArray, e, false);
        }
        catch (Exception e) {
            throw MetaClassHelper.createExceptionText("failed to invoke constructor: ", constructor, argumentArray, e, true);
        }
    }

    private static GroovyRuntimeException createExceptionText(String init, Constructor constructor, Object[] argumentArray, Throwable e, boolean setReason) {
        throw new GroovyRuntimeException(init + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, setReason ? e : null);
    }

    public static Object[] coerceArgumentsToClasses(Object[] argumentArray, Class[] paramTypes) {
        if (argumentArray == null) {
            argumentArray = EMPTY_ARRAY;
        } else if (paramTypes.length == 1 && argumentArray.length == 0) {
            argumentArray = MetaClassHelper.isVargsMethod(paramTypes, argumentArray) ? new Object[]{Array.newInstance(paramTypes[0].getComponentType(), 0)} : ARRAY_WITH_NULL;
        } else if (MetaClassHelper.isVargsMethod(paramTypes, argumentArray)) {
            argumentArray = MetaClassHelper.fitToVargs(argumentArray, paramTypes);
        }
        for (int i = 0; i < argumentArray.length; ++i) {
            Class parameterType;
            Object argument = argumentArray[i];
            if (argument == null || (parameterType = paramTypes[i]).isInstance(argument)) continue;
            argument = MetaClassHelper.coerceGString(argument, parameterType);
            argument = MetaClassHelper.coerceNumber(argument, parameterType);
            argumentArray[i] = argument = MetaClassHelper.coerceArray(argument, parameterType);
        }
        return argumentArray;
    }

    private static Object makeCommonArray(Object[] arguments, int offset, Class fallback) {
        Class<?> baseClass = null;
        for (int i = offset; i < arguments.length; ++i) {
            if (arguments[i] == null) continue;
            Class<?> argClass = arguments[i].getClass();
            if (baseClass == null) {
                baseClass = argClass;
                continue;
            }
            while (baseClass != (class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object) && !baseClass.isAssignableFrom(argClass)) {
                baseClass = baseClass.getSuperclass();
            }
        }
        if (baseClass == null) {
            baseClass = fallback;
        }
        Object result = MetaClassHelper.makeArray(null, baseClass, arguments.length - offset);
        System.arraycopy(arguments, offset, result, 0, arguments.length - offset);
        return result;
    }

    private static Object makeArray(Object obj, Class secondary, int length) {
        Class<?> baseClass = secondary;
        if (obj != null) {
            baseClass = obj.getClass();
        }
        return Array.newInstance(baseClass, length);
    }

    private static Object[] fitToVargs(Object[] argumentArray, Class[] paramTypes) {
        Class vargsClass = MetaClassHelper.autoboxType(paramTypes[paramTypes.length - 1].getComponentType());
        if (argumentArray.length == paramTypes.length - 1) {
            Object vargs;
            Object[] newArgs = new Object[paramTypes.length];
            System.arraycopy(argumentArray, 0, newArgs, 0, argumentArray.length);
            newArgs[newArgs.length - 1] = vargs = MetaClassHelper.makeArray(null, vargsClass, 0);
            return newArgs;
        }
        if (argumentArray.length == paramTypes.length) {
            Object lastArgument = argumentArray[argumentArray.length - 1];
            if (lastArgument != null && !lastArgument.getClass().isArray()) {
                Object vargs = MetaClassHelper.makeArray(lastArgument, vargsClass, 1);
                System.arraycopy(argumentArray, argumentArray.length - 1, vargs, 0, 1);
                argumentArray[argumentArray.length - 1] = vargs;
                return argumentArray;
            }
            return argumentArray;
        }
        if (argumentArray.length > paramTypes.length) {
            Object vargs;
            Object[] newArgs = new Object[paramTypes.length];
            System.arraycopy(argumentArray, 0, newArgs, 0, paramTypes.length - 1);
            int numberOfVargs = argumentArray.length - paramTypes.length;
            newArgs[newArgs.length - 1] = vargs = MetaClassHelper.makeCommonArray(argumentArray, paramTypes.length - 1, vargsClass);
            return newArgs;
        }
        throw new GroovyBugError("trying to call a vargs method without enough arguments");
    }

    private static GroovyRuntimeException createExceptionText(String init, MetaMethod method, Object object, Object[] args, Throwable reason, boolean setReason) {
        return new GroovyRuntimeException(init + method + " on: " + object + " with arguments: " + InvokerHelper.toString(args) + " reason: " + reason, setReason ? reason : null);
    }

    public static Object doMethodInvoke(Object object, MetaMethod method, Object[] argumentArray) {
        Class[] paramTypes = method.getParameterTypes();
        argumentArray = MetaClassHelper.coerceArgumentsToClasses(argumentArray, paramTypes);
        try {
            return method.invoke(object, argumentArray);
        }
        catch (InvocationTargetException e) {
            throw new InvokerInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw MetaClassHelper.createExceptionText("could not access method: ", method, object, argumentArray, e, true);
        }
        catch (IllegalArgumentException e) {
            boolean setReason = e.getClass() != IllegalArgumentException.class;
            throw MetaClassHelper.createExceptionText("failed to invoke method: ", method, object, argumentArray, e, setReason);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw MetaClassHelper.createExceptionText("failed to invoke method: ", method, object, argumentArray, e, true);
        }
    }

    protected static String getClassName(Object object) {
        return object instanceof Class ? ((Class)object).getName() : object.getClass().getName();
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        return new MethodClosure(object, methodName);
    }

    public static Class[] getParameterTypes(Object methodOrConstructor) {
        if (methodOrConstructor instanceof MetaMethod) {
            MetaMethod method = (MetaMethod)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrConstructor;
            return constructor.getParameterTypes();
        }
        throw new IllegalArgumentException("Must be a Method or Constructor");
    }

    protected static boolean isAssignableFrom(Class classToTransformTo, Class classToTransformFrom) {
        if (classToTransformFrom == null) {
            return true;
        }
        if ((classToTransformTo = MetaClassHelper.autoboxType(classToTransformTo)) == (classToTransformFrom = MetaClassHelper.autoboxType(classToTransformFrom))) {
            return true;
        }
        if (classToTransformTo == Integer.class ? classToTransformFrom == Integer.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == BigInteger.class : (classToTransformTo == Double.class ? classToTransformFrom == Double.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == Float.class || classToTransformFrom == BigDecimal.class || classToTransformFrom == BigInteger.class : (classToTransformTo == BigDecimal.class ? classToTransformFrom == Double.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == Float.class || classToTransformFrom == BigDecimal.class || classToTransformFrom == BigInteger.class : (classToTransformTo == BigInteger.class ? classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == BigInteger.class : (classToTransformTo == Long.class ? classToTransformFrom == Long.class || classToTransformFrom == Integer.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class : (classToTransformTo == Float.class ? classToTransformFrom == Float.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class : (classToTransformTo == Short.class ? classToTransformFrom == Short.class || classToTransformFrom == Byte.class : classToTransformTo == String.class && (classToTransformFrom == String.class || GString.class.isAssignableFrom(classToTransformFrom))))))))) {
            return true;
        }
        boolean answer = classToTransformTo.isAssignableFrom(classToTransformFrom);
        return answer;
    }

    public static boolean isGenericSetMethod(MetaMethod method) {
        return method.getName().equals("set") && method.getParameterTypes().length == 2;
    }

    protected static boolean isSuperclass(Class claszz, Class superclass) {
        while (claszz != null) {
            if (claszz == superclass) {
                return true;
            }
            claszz = claszz.getSuperclass();
        }
        return false;
    }

    public static boolean isValidMethod(Class[] paramTypes, Class[] arguments, boolean includeCoerce) {
        if (arguments == null) {
            return true;
        }
        int size = arguments.length;
        if ((size >= paramTypes.length || size == paramTypes.length - 1) && paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isArray()) {
            for (int i = 0; i < paramTypes.length - 1; ++i) {
                if (MetaClassHelper.isAssignableFrom(paramTypes[i], arguments[i])) continue;
                return false;
            }
            Class<?> clazz = paramTypes[paramTypes.length - 1].getComponentType();
            for (int i = paramTypes.length; i < size; ++i) {
                if (MetaClassHelper.isAssignableFrom(clazz, arguments[i])) continue;
                return false;
            }
            return true;
        }
        if (paramTypes.length == size) {
            for (int i = 0; i < size; ++i) {
                if (MetaClassHelper.isAssignableFrom(paramTypes[i], arguments[i])) continue;
                return false;
            }
            return true;
        }
        return paramTypes.length == 1 && size == 0;
    }

    public static boolean isValidMethod(Object method, Class[] arguments, boolean includeCoerce) {
        Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
        return MetaClassHelper.isValidMethod(paramTypes, arguments, includeCoerce);
    }

    public static boolean isVargsMethod(Class[] paramTypes, Object[] arguments) {
        if (paramTypes.length == 0) {
            return false;
        }
        if (!paramTypes[paramTypes.length - 1].isArray()) {
            return false;
        }
        if (paramTypes.length - 1 == arguments.length) {
            return true;
        }
        if (paramTypes.length - 1 > arguments.length) {
            return false;
        }
        if (arguments.length > paramTypes.length) {
            return true;
        }
        Object last = arguments[arguments.length - 1];
        if (last == null) {
            return true;
        }
        Class<?> clazz = last.getClass();
        return !clazz.equals(paramTypes[paramTypes.length - 1]);
    }

    public static void logMethodCall(Object object, String methodName, Object[] arguments) {
        String className = MetaClassHelper.getClassName(object);
        String logname = "methodCalls." + className + "." + methodName;
        Logger objLog = Logger.getLogger(logname);
        if (!objLog.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer msg = new StringBuffer(methodName);
        msg.append("(");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                msg.append(MetaClassHelper.normalizedValue(arguments[i]));
                if (++i >= arguments.length) continue;
                msg.append(",");
            }
        }
        msg.append(")");
        objLog.logp(Level.FINER, className, msg.toString(), "called from MetaClass.invokeMethod");
    }

    protected static String normalizedValue(Object argument) {
        String value;
        try {
            value = argument.toString();
            if (value.length() > 12) {
                value = value.substring(0, 10) + "..";
            }
            if (argument instanceof String) {
                value = "'" + value + "'";
            }
        }
        catch (Exception e) {
            value = MetaClassHelper.shortName(argument);
        }
        return value;
    }

    public static boolean parametersAreCompatible(Class[] arguments, Class[] parameters) {
        if (arguments.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (MetaClassHelper.isAssignableFrom(parameters[i], arguments[i])) continue;
            return false;
        }
        return true;
    }

    protected static String shortName(Object object) {
        if (object == null || object.getClass() == null) {
            return "unknownClass";
        }
        String name = MetaClassHelper.getClassName(object);
        if (name == null) {
            return "unknownClassName";
        }
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos < 0 || lastDotPos >= name.length() - 1) {
            return name;
        }
        return name.substring(lastDotPos + 1);
    }

    public static Class[] wrap(Class[] classes) {
        Class[] wrappedArguments = new Class[classes.length];
        for (int i = 0; i < wrappedArguments.length; ++i) {
            Class c = classes[i];
            if (c == null) continue;
            if (c.isPrimitive()) {
                if (c == Integer.TYPE) {
                    c = class$java$lang$Integer == null ? MetaClassHelper.class$("java.lang.Integer") : class$java$lang$Integer;
                } else if (c == Byte.TYPE) {
                    c = class$java$lang$Byte == null ? MetaClassHelper.class$("java.lang.Byte") : class$java$lang$Byte;
                } else if (c == Long.TYPE) {
                    c = class$java$lang$Long == null ? MetaClassHelper.class$("java.lang.Long") : class$java$lang$Long;
                } else if (c == Double.TYPE) {
                    c = class$java$lang$Double == null ? MetaClassHelper.class$("java.lang.Double") : class$java$lang$Double;
                } else if (c == Float.TYPE) {
                    c = class$java$lang$Float == null ? MetaClassHelper.class$("java.lang.Float") : class$java$lang$Float;
                }
            } else if (MetaClassHelper.isSuperclass(c, class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString)) {
                c = class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String;
            }
            wrappedArguments[i] = c;
        }
        return wrappedArguments;
    }
}

