/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry.shape;

import org.apache.lucene.spatial.geometry.shape.Point2D;
import org.apache.lucene.spatial.geometry.shape.Vector2D;

public class LineSegment {
    public final Point2D A = new Point2D();
    public final Point2D B = new Point2D();

    public LineSegment() {
        this.A.set(0.0, 0.0);
        this.B.set(0.0, 0.0);
    }

    public LineSegment(Point2D p1, Point2D p2) {
        this.A.set(p1);
        this.B.set(p2);
    }

    public double distance(Point2D P, Point2D closestPt) {
        Vector2D v;
        Vector2D w;
        double n;
        if (closestPt == null) {
            closestPt = new Point2D();
        }
        if ((n = (w = new Vector2D(this.A, P)).dot(v = new Vector2D(this.A, this.B))) <= 0.0) {
            closestPt.set(this.A);
            return w.norm();
        }
        double d = v.dot(v);
        if (d <= n) {
            closestPt.set(this.B);
            return new Vector2D(this.B, P).norm();
        }
        closestPt.set(v.mult(n / d));
        closestPt.add(this.A);
        return new Vector2D(closestPt, P).norm();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.A == null ? 0 : this.A.hashCode());
        result = 31 * result + (this.B == null ? 0 : this.B.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineSegment other = (LineSegment)obj;
        if (this.A == null ? other.A != null : !this.A.equals(other.A)) {
            return false;
        }
        return !(this.B == null ? other.B != null : !this.B.equals(other.B));
    }
}

