/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.lucene.analysis.Token;
import org.apache.solr.spelling.RankedSpellPossibility;
import org.apache.solr.spelling.SpellCheckCorrection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PossibilityIterator
implements Iterator<RankedSpellPossibility> {
    private List<List<SpellCheckCorrection>> possibilityList = new ArrayList<List<SpellCheckCorrection>>();
    private List<RankedSpellPossibility> rankedPossibilityList = new ArrayList<RankedSpellPossibility>();
    private Iterator<RankedSpellPossibility> rankedPossibilityIterator;
    private int[] correctionIndex;
    private boolean done = false;

    private PossibilityIterator() {
        throw new AssertionError((Object)"You shan't go here.");
    }

    public PossibilityIterator(Map<Token, LinkedHashMap<String, Integer>> suggestions) {
        for (Map.Entry<Token, LinkedHashMap<String, Integer>> entry : suggestions.entrySet()) {
            Token token = entry.getKey();
            ArrayList<SpellCheckCorrection> possibleCorrections = new ArrayList<SpellCheckCorrection>();
            for (Map.Entry<String, Integer> entry1 : entry.getValue().entrySet()) {
                SpellCheckCorrection correction = new SpellCheckCorrection();
                correction.setOriginal(token);
                correction.setCorrection(entry1.getKey());
                correction.setNumberOfOccurences(entry1.getValue());
                possibleCorrections.add(correction);
            }
            this.possibilityList.add(possibleCorrections);
        }
        int wrapSize = this.possibilityList.size();
        if (wrapSize == 0) {
            this.done = true;
        } else {
            this.correctionIndex = new int[wrapSize];
            for (int i = 0; i < wrapSize; ++i) {
                int suggestSize = this.possibilityList.get(i).size();
                if (suggestSize == 0) {
                    this.done = true;
                    break;
                }
                this.correctionIndex[i] = 0;
            }
        }
        while (this.internalHasNext()) {
            this.rankedPossibilityList.add(this.internalNext());
        }
        Collections.sort(this.rankedPossibilityList);
        this.rankedPossibilityIterator = this.rankedPossibilityList.iterator();
    }

    private boolean internalHasNext() {
        return !this.done;
    }

    private RankedSpellPossibility internalNext() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        ArrayList<SpellCheckCorrection> possibleCorrection = new ArrayList<SpellCheckCorrection>();
        int rank = 0;
        for (int i = 0; i < this.correctionIndex.length; ++i) {
            List<SpellCheckCorrection> singleWordPossibilities = this.possibilityList.get(i);
            SpellCheckCorrection singleWordPossibility = singleWordPossibilities.get(this.correctionIndex[i]);
            rank += this.correctionIndex[i];
            if (i == this.correctionIndex.length - 1) {
                int n = i;
                this.correctionIndex[n] = this.correctionIndex[n] + 1;
                if (this.correctionIndex[i] == singleWordPossibilities.size()) {
                    this.correctionIndex[i] = 0;
                    if (this.correctionIndex.length == 1) {
                        this.done = true;
                    }
                    for (int ii = i - 1; ii >= 0; --ii) {
                        int n2 = ii;
                        this.correctionIndex[n2] = this.correctionIndex[n2] + 1;
                        if (this.correctionIndex[ii] < this.possibilityList.get(ii).size() || ii <= 0) break;
                        this.correctionIndex[ii] = 0;
                    }
                }
            }
            possibleCorrection.add(singleWordPossibility);
        }
        if (this.correctionIndex[0] == this.possibilityList.get(0).size()) {
            this.done = true;
        }
        RankedSpellPossibility rsl = new RankedSpellPossibility();
        rsl.setCorrections(possibleCorrection);
        rsl.setRank(rank);
        return rsl;
    }

    @Override
    public boolean hasNext() {
        return this.rankedPossibilityIterator.hasNext();
    }

    @Override
    public RankedSpellPossibility next() {
        return this.rankedPossibilityIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

