/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.SessionHelper;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;

public abstract class SessionAbstract
extends BusinessEntityImpl
implements Session {
    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionSession;

    @Override
    public Date getSessionDate() {
        Date value = SessionHelper.getSessionDate(this.getWikitty());
        return value;
    }

    @Override
    public void setSessionDate(Date sessionDate) {
        Date oldValue = this.getSessionDate();
        SessionHelper.setSessionDate(this.getWikitty(), sessionDate);
        this.getPropertyChangeSupport().firePropertyChange("sessionDate", oldValue, this.getSessionDate());
    }

    @Override
    public int getNum() {
        int value = SessionHelper.getNum(this.getWikitty());
        return value;
    }

    @Override
    public void setNum(int num) {
        int oldValue = this.getNum();
        SessionHelper.setNum(this.getWikitty(), num);
        this.getPropertyChangeSupport().firePropertyChange("num", oldValue, this.getNum());
    }

    @Override
    public int getStatus() {
        int value = SessionHelper.getStatus(this.getWikitty());
        return value;
    }

    @Override
    public void setStatus(int status) {
        int oldValue = this.getStatus();
        SessionHelper.setStatus(this.getWikitty(), status);
        this.getPropertyChangeSupport().firePropertyChange("status", oldValue, this.getStatus());
    }

    @Override
    public String getParagraph() {
        String value = SessionHelper.getParagraph(this.getWikitty());
        return value;
    }

    @Override
    public void setParagraph(String paragraph) {
        String oldValue = this.getParagraph();
        SessionHelper.setParagraph(this.getWikitty(), paragraph);
        this.getPropertyChangeSupport().firePropertyChange("paragraph", oldValue, this.getParagraph());
    }

    @Override
    public String getSessionLogs() {
        String value = SessionHelper.getSessionLogs(this.getWikitty());
        return value;
    }

    @Override
    public void setSessionLogs(String sessionLogs) {
        String oldValue = this.getSessionLogs();
        SessionHelper.setSessionLogs(this.getWikitty(), sessionLogs);
        this.getPropertyChangeSupport().firePropertyChange("sessionLogs", oldValue, this.getSessionLogs());
    }

    @Override
    public Set<String> getFiles() {
        Set<String> result = SessionHelper.getFiles(this.getWikitty());
        return result;
    }

    @Override
    public void setFiles(Set<String> files) {
        Set<String> oldValue = this.getFiles();
        SessionHelper.setFiles(this.getWikitty(), files);
        this.getPropertyChangeSupport().firePropertyChange("files", oldValue, this.getFiles());
    }

    @Override
    public void addAllFiles(Set<String> files) {
        Set<String> oldValue = this.getFiles();
        SessionHelper.addAllFiles(this.getWikitty(), files);
        this.getPropertyChangeSupport().firePropertyChange("files", oldValue, this.getFiles());
    }

    @Override
    public void addFiles(String element) {
        SessionHelper.addFiles(this.getWikitty(), element);
        this.getPropertyChangeSupport().firePropertyChange("files", null, this.getFiles());
    }

    @Override
    public void removeFiles(String element) {
        SessionHelper.removeFiles(this.getWikitty(), element);
        this.getPropertyChangeSupport().firePropertyChange("files", null, this.getFiles());
    }

    @Override
    public void clearFiles() {
        SessionHelper.clearFiles(this.getWikitty());
        this.getPropertyChangeSupport().firePropertyChange("files", null, this.getFiles());
    }

    @Override
    public Set<String> getSending() {
        Set<String> result = SessionHelper.getSending(this.getWikitty());
        return result;
    }

    @Override
    public void setSending(Set<String> sending) {
        Set<String> oldValue = this.getSending();
        SessionHelper.setSending(this.getWikitty(), sending);
        this.getPropertyChangeSupport().firePropertyChange("sending", oldValue, this.getSending());
    }

    @Override
    public void addAllSending(Set<String> sending) {
        Set<String> oldValue = this.getSending();
        SessionHelper.addAllSending(this.getWikitty(), sending);
        this.getPropertyChangeSupport().firePropertyChange("sending", oldValue, this.getSending());
    }

    @Override
    public void addSending(String element) {
        SessionHelper.addSending(this.getWikitty(), element);
        this.getPropertyChangeSupport().firePropertyChange("sending", null, this.getSending());
    }

    @Override
    public void removeSending(String element) {
        SessionHelper.removeSending(this.getWikitty(), element);
        this.getPropertyChangeSupport().firePropertyChange("sending", null, this.getSending());
    }

    @Override
    public void clearSending() {
        SessionHelper.clearSending(this.getWikitty());
        this.getPropertyChangeSupport().firePropertyChange("sending", null, this.getSending());
    }

    public SessionAbstract() {
    }

    public SessionAbstract(Wikitty wikitty) {
        super(wikitty);
    }

    public SessionAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
    }

    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    public String toString() {
        return this.getWikitty().toString();
    }

    static {
        extensionSession = new WikittyExtension("Session", "5.0", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"Date sessionDate unique=\"true\"", "Numeric num unique=\"true\"", "Numeric status unique=\"true\"", "String paragraph unique=\"true\"", "String sessionLogs unique=\"true\"", "String files[0-*] unique=\"true\"", "Wikitty sending[0-*] unique=\"true\""}));
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionSession);
        extensions = Collections.unmodifiableList(exts);
    }
}

