/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.webharvest.exception.PluginException;
import org.webharvest.runtime.processors.plugins.DbColumnDescription;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class DbRowVariable
extends NodeVariable {
    private static final String ROW_TAG_NAME = "row";
    private DbColumnDescription[] columnDescription = null;
    private Object[] data = null;

    public DbRowVariable(DbColumnDescription[] columnDescription, Object[] data) {
        super(null);
        this.columnDescription = columnDescription;
        this.data = data;
    }

    public int getColumnCount() {
        return this.columnDescription.length;
    }

    public String getColumnName(int index) {
        return this.columnDescription[index].getName();
    }

    public Variable get(Object var) {
        String s = var.toString();
        int index = CommonUtil.getIntValue(s, -1);
        if (index > 0) {
            return this.get(index - 1);
        }
        return this.get(s);
    }

    public Variable get(int index) {
        return this.data[index] == null ? new EmptyVariable() : new NodeVariable(this.data[index]);
    }

    public Variable get(String columnName) {
        int index = -1;
        for (int i = 0; i < this.columnDescription.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.columnDescription[i].getName())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            return this.get(index);
        }
        throw new PluginException("Invalid column name: " + columnName);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("<row>");
        for (int i = 0; i < this.columnDescription.length; ++i) {
            String colIdentifier = this.columnDescription[i].getIdentifier();
            buffer.append("<").append(colIdentifier).append(">");
            buffer.append(CommonUtil.escapeXml(CommonUtil.nvl(this.data[i], "")));
            buffer.append("</").append(colIdentifier).append(">");
        }
        buffer.append("</").append(ROW_TAG_NAME).append(">");
        return buffer.toString();
    }

    @Override
    public String toString(String charset) {
        return this.toString();
    }

    @Override
    public Object getWrappedObject() {
        return this.data;
    }

    @Override
    public List toList() {
        return new ArrayList<Object>(Arrays.asList(this.data));
    }
}

