/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.util.Map;
import org.webharvest.definition.WebHarvestPluginDef;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public abstract class WebHarvestPlugin
extends BaseProcessor {
    private Map attributes;

    public abstract String getName();

    public String[] getValidAttributes() {
        return new String[0];
    }

    public String[] getRequiredAttributes() {
        return new String[0];
    }

    public String[] getValidSubprocessors() {
        return null;
    }

    public String[] getRequiredSubprocessors() {
        return new String[0];
    }

    public Class[] getDependantProcessors() {
        return null;
    }

    public String[] getAttributeValueSuggestions(String attributeName) {
        return null;
    }

    public boolean hasBody() {
        return true;
    }

    @Override
    public final Variable execute(Scraper scraper, ScraperContext context) {
        Variable variable = this.executePlugin(scraper, context);
        return variable;
    }

    public abstract Variable executePlugin(Scraper var1, ScraperContext var2);

    public String getTagDesc() {
        if (!this.hasBody()) {
            return "";
        }
        String[] validSubprocessors = this.getValidSubprocessors();
        if (validSubprocessors == null) {
            return null;
        }
        String[] requiredTags = this.getRequiredSubprocessors();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < validSubprocessors.length; ++i) {
            String subProcessor;
            if (result.length() != 0) {
                result.append(',');
            }
            if (CommonUtil.existsInStringArray(requiredTags, subProcessor = validSubprocessors[i], true)) {
                result.append('!');
            }
            result.append(subProcessor);
        }
        return result.toString();
    }

    public String getAttributeDesc() {
        String[] validAtts = this.getValidAttributes();
        if (validAtts == null) {
            return "id";
        }
        String[] requiredAtts = this.getRequiredAttributes();
        StringBuffer result = new StringBuffer("id,");
        for (int i = 0; i < validAtts.length; ++i) {
            String att = validAtts[i];
            if (CommonUtil.existsInStringArray(requiredAtts, att, true)) {
                result.append('!');
            }
            result.append(att);
            result.append(",");
        }
        return result.toString();
    }

    public void setDef(WebHarvestPluginDef def) {
        this.elementDef = def;
        this.attributes = def.getAttributes();
    }

    protected Map getAttributes() {
        return this.attributes;
    }

    protected String evaluateAttribute(String attName, Scraper scraper) {
        String attValue = (String)this.attributes.get(attName);
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        return BaseTemplater.execute(attValue, scriptEngine);
    }

    protected boolean evaluateAttributeAsBoolean(String attName, boolean defaultValue, Scraper scraper) {
        return CommonUtil.getBooleanValue(this.evaluateAttribute(attName, scraper), defaultValue);
    }

    protected int evaluateAttributeAsInteger(String attName, int defaultValue, Scraper scraper) {
        return CommonUtil.getIntValue(this.evaluateAttribute(attName, scraper), defaultValue);
    }

    protected double evaluateAttributeAsDouble(String attName, double defaultValue, Scraper scraper) {
        return CommonUtil.getDoubleValue(this.evaluateAttribute(attName, scraper), defaultValue);
    }

    protected Variable executeBody(Scraper scraper, ScraperContext context) {
        return new BodyProcessor(this.elementDef).execute(scraper, context);
    }
}

