/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.htmlcleaner.BrowserCompactXmlSerializer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CompactXmlSerializer;
import org.htmlcleaner.ConfigFileTagProvider;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.PrettyXmlSerializer;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XPatherException;

public class HtmlCleanerForAnt
extends Task {
    private String text;
    private String src;
    private String dest;
    private String incharset = HtmlCleaner.DEFAULT_CHARSET;
    private String outcharset = HtmlCleaner.DEFAULT_CHARSET;
    private String taginfofile = null;
    private String outputtype = "simple";
    private boolean advancedxmlescape = true;
    private boolean usecdata = true;
    private boolean specialentities = true;
    private boolean unicodechars = true;
    private boolean omitunknowntags = false;
    private boolean treatunknowntagsascontent = false;
    private boolean omitdeprtags = false;
    private boolean treatdeprtagsascontent = false;
    private boolean omitcomments = false;
    private boolean omitxmldecl = false;
    private boolean omitdoctypedecl = true;
    private boolean omithtmlenvelope = false;
    private boolean useemptyelementtags = true;
    private boolean allowmultiwordattributes = true;
    private boolean allowhtmlinsideattributes = false;
    private boolean ignoreqe = false;
    private boolean namespacesaware = true;
    private String hyphenreplacement = "=";
    private String prunetags = "";
    private String booleanatts = "self";
    private String nodebyxpath = null;
    private String transform = null;

    public void setText(String text) {
        this.text = text;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void setIncharset(String incharset) {
        this.incharset = incharset;
    }

    public void setOutcharset(String outcharset) {
        this.outcharset = outcharset;
    }

    public void setTaginfofile(String taginfofile) {
        this.taginfofile = taginfofile;
    }

    public void setOutputtype(String outputtype) {
        this.outputtype = outputtype;
    }

    public void setAdvancedxmlescape(boolean advancedxmlescape) {
        this.advancedxmlescape = advancedxmlescape;
    }

    public void setUsecdata(boolean usecdata) {
        this.usecdata = usecdata;
    }

    public void setSpecialentities(boolean specialentities) {
        this.specialentities = specialentities;
    }

    public void setUnicodechars(boolean unicodechars) {
        this.unicodechars = unicodechars;
    }

    public void setOmitunknowntags(boolean omitunknowntags) {
        this.omitunknowntags = omitunknowntags;
    }

    public void setTreatunknowntagsascontent(boolean treatunknowntagsascontent) {
        this.treatunknowntagsascontent = treatunknowntagsascontent;
    }

    public void setOmitdeprtags(boolean omitdeprtags) {
        this.omitdeprtags = omitdeprtags;
    }

    public void setTreatdeprtagsascontent(boolean treatdeprtagsascontent) {
        this.treatdeprtagsascontent = treatdeprtagsascontent;
    }

    public void setOmitcomments(boolean omitcomments) {
        this.omitcomments = omitcomments;
    }

    public void setOmitxmldecl(boolean omitxmldecl) {
        this.omitxmldecl = omitxmldecl;
    }

    public void setOmitdoctypedecl(boolean omitdoctypedecl) {
        this.omitdoctypedecl = omitdoctypedecl;
    }

    public void setOmithtmlenvelope(boolean omithtmlenvelope) {
        this.omithtmlenvelope = omithtmlenvelope;
    }

    public void setUseemptyelementtags(boolean useemptyelementtags) {
        this.useemptyelementtags = useemptyelementtags;
    }

    public void setAllowmultiwordattributes(boolean allowmultiwordattributes) {
        this.allowmultiwordattributes = allowmultiwordattributes;
    }

    public void setAllowhtmlinsideattributes(boolean allowhtmlinsideattributes) {
        this.allowhtmlinsideattributes = allowhtmlinsideattributes;
    }

    public void setIgnoreqe(boolean ignoreqe) {
        this.ignoreqe = ignoreqe;
    }

    public void setNamespacesaware(boolean namespacesaware) {
        this.namespacesaware = namespacesaware;
    }

    public void setHyphenreplacement(String hyphenreplacement) {
        this.hyphenreplacement = hyphenreplacement;
    }

    public void setPrunetags(String prunetags) {
        this.prunetags = prunetags;
    }

    public void setBooleanatts(String booleanatts) {
        this.booleanatts = booleanatts;
    }

    public void setNodebyxpath(String nodebyxpath) {
        this.nodebyxpath = nodebyxpath;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    public void addText(String text) {
        this.text = text;
    }

    public void execute() throws BuildException {
        HtmlCleaner cleaner = this.taginfofile != null ? new HtmlCleaner(new ConfigFileTagProvider(new File(this.taginfofile))) : new HtmlCleaner();
        if (this.text == null && this.src == null) {
            throw new BuildException("Eather attribute 'src' or text body containing HTML must be specified!");
        }
        CleanerProperties props = cleaner.getProperties();
        props.setAdvancedXmlEscape(this.advancedxmlescape);
        props.setUseCdataForScriptAndStyle(this.usecdata);
        props.setTranslateSpecialEntities(this.specialentities);
        props.setRecognizeUnicodeChars(this.unicodechars);
        props.setOmitUnknownTags(this.omitunknowntags);
        props.setTreatUnknownTagsAsContent(this.treatunknowntagsascontent);
        props.setOmitDeprecatedTags(this.omitdeprtags);
        props.setTreatDeprecatedTagsAsContent(this.treatdeprtagsascontent);
        props.setOmitComments(this.omitcomments);
        props.setOmitXmlDeclaration(this.omitxmldecl);
        props.setOmitDoctypeDeclaration(this.omitdoctypedecl);
        props.setOmitHtmlEnvelope(this.omithtmlenvelope);
        props.setUseEmptyElementTags(this.useemptyelementtags);
        props.setAllowMultiWordAttributes(this.allowmultiwordattributes);
        props.setAllowHtmlInsideAttributes(this.allowhtmlinsideattributes);
        props.setIgnoreQuestAndExclam(this.ignoreqe);
        props.setNamespacesAware(this.namespacesaware);
        props.setHyphenReplacementInComment(this.hyphenreplacement);
        props.setPruneTags(this.prunetags);
        props.setBooleanAttributeValues(this.booleanatts);
        if (!Utils.isEmptyString(this.transform)) {
            String value;
            String[] transItems = Utils.tokenize(this.transform, "|");
            TreeMap<String, String> transInfos = new TreeMap<String, String>();
            for (int i = 0; i < transItems.length; ++i) {
                String item = transItems[i];
                int index = item.indexOf(61);
                String key = index <= 0 ? item : item.substring(0, index);
                value = index <= 0 ? null : item.substring(index + 1);
                transInfos.put(key, value);
            }
            CleanerTransformations transformations = new CleanerTransformations();
            Iterator iterator = transInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String tag = (String)entry.getKey();
                value = (String)entry.getValue();
                Utils.updateTagTransformations(transformations, tag, value);
            }
            cleaner.setTransformations(transformations);
        }
        try {
            TagNode node;
            try {
                node = this.src != null && (this.src.startsWith("http://") || this.src.startsWith("https://")) ? cleaner.clean(new URL(this.src), this.incharset) : (this.src != null ? cleaner.clean(new File(this.src), this.incharset) : cleaner.clean(this.text));
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            if (this.nodebyxpath != null) {
                Object[] xpathResult = node.evaluateXPath(this.nodebyxpath);
                for (int i = 0; i < xpathResult.length; ++i) {
                    if (!(xpathResult[i] instanceof TagNode)) continue;
                    node = (TagNode)xpathResult[i];
                    break;
                }
            }
            OutputStream out = this.dest == null || "".equals(this.dest.trim()) ? System.out : new FileOutputStream(this.dest);
            if ("compact".equals(this.outputtype)) {
                new CompactXmlSerializer(props).writeXmlToStream(node, out, this.outcharset);
            } else if ("browser-compact".equals(this.outputtype)) {
                new BrowserCompactXmlSerializer(props).writeXmlToStream(node, out, this.outcharset);
            } else if ("pretty".equals(this.outputtype)) {
                new PrettyXmlSerializer(props).writeXmlToStream(node, out, this.outcharset);
            } else {
                new SimpleXmlSerializer(props).writeXmlToStream(node, out, this.outcharset);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (XPatherException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

