/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.csv.CSVStrategy;

public class CSVPrinter {
    protected final Writer out;
    protected final CSVStrategy strategy;
    protected boolean newLine = true;
    protected char[] buf = new char[0];

    public CSVPrinter(Writer out, CSVStrategy strategy) {
        this.out = out;
        this.strategy = strategy == null ? CSVStrategy.DEFAULT_STRATEGY : strategy;
    }

    public void println() throws IOException {
        this.out.write(this.strategy.getPrinterNewline());
        this.newLine = true;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void println(String[] values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            this.print(values[i]);
        }
        this.println();
    }

    public void printlnComment(String comment) throws IOException {
        if (this.strategy.isCommentingDisabled()) {
            return;
        }
        if (!this.newLine) {
            this.println();
        }
        this.out.write(this.strategy.getCommentStart());
        this.out.write(32);
        block4: for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < comment.length() && comment.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    this.println();
                    this.out.write(this.strategy.getCommentStart());
                    this.out.write(32);
                    continue block4;
                }
                default: {
                    this.out.write(c);
                }
            }
        }
        this.println();
    }

    public void print(char[] value, int offset, int len, boolean checkForEscape) throws IOException {
        if (!checkForEscape) {
            this.printSep();
            this.out.write(value, offset, len);
            return;
        }
        if (this.strategy.getEncapsulator() != CSVStrategy.ENCAPSULATOR_DISABLED) {
            this.printAndEncapsulate(value, offset, len);
        } else if (this.strategy.getEscape() != CSVStrategy.ESCAPE_DISABLED) {
            this.printAndEscape(value, offset, len);
        } else {
            this.printSep();
            this.out.write(value, offset, len);
        }
    }

    void printSep() throws IOException {
        if (this.newLine) {
            this.newLine = false;
        } else {
            this.out.write(this.strategy.getDelimiter());
        }
    }

    void printAndEscape(char[] value, int offset, int len) throws IOException {
        int pos;
        int start = offset;
        int end = offset + len;
        this.printSep();
        char delim = this.strategy.getDelimiter();
        char escape = this.strategy.getEscape();
        for (pos = offset; pos < end; ++pos) {
            char c = value[pos];
            if (c != '\r' && c != '\n' && c != delim && c != escape) continue;
            int l = pos - start;
            if (l > 0) {
                this.out.write(value, start, l);
            }
            if (c == '\n') {
                c = 'n';
            } else if (c == '\r') {
                c = 'r';
            }
            this.out.write(escape);
            this.out.write(c);
            start = pos + 1;
        }
        int l = pos - start;
        if (l > 0) {
            this.out.write(value, start, l);
        }
    }

    void printAndEncapsulate(char[] value, int offset, int len) throws IOException {
        char c;
        int pos;
        boolean first = this.newLine;
        boolean quote = false;
        int start = offset;
        int end = offset + len;
        this.printSep();
        char delim = this.strategy.getDelimiter();
        char encapsulator = this.strategy.getEncapsulator();
        if (len <= 0) {
            if (first) {
                quote = true;
            }
        } else {
            c = value[pos];
            if (first && (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z')) {
                quote = true;
            } else if (c <= '#') {
                quote = true;
            } else {
                for (pos = offset; pos < end; ++pos) {
                    c = value[pos];
                    if (c != '\n' && c != '\r' && c != encapsulator && c != delim) continue;
                    quote = true;
                    break;
                }
                if (!quote && (c = value[pos = end - 1]) <= ' ') {
                    quote = true;
                }
            }
        }
        if (!quote) {
            this.out.write(value, offset, len);
            return;
        }
        this.out.write(encapsulator);
        while (pos < end) {
            c = value[pos];
            if (c == encapsulator) {
                this.out.write(value, start, pos - start + 1);
                start = pos;
            }
            ++pos;
        }
        this.out.write(value, start, pos - start);
        this.out.write(encapsulator);
    }

    public void print(String value, boolean checkForEscape) throws IOException {
        if (!checkForEscape) {
            this.printSep();
            this.out.write(value);
            return;
        }
        if (this.buf.length < value.length()) {
            this.buf = new char[value.length()];
        }
        value.getChars(0, value.length(), this.buf, 0);
        this.print(this.buf, 0, value.length(), checkForEscape);
    }

    public void print(String value) throws IOException {
        this.print(value, true);
    }
}

