/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hi;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;
import org.apache.lucene.analysis.hi.HindiStemFilter;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.in.IndicTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HindiAnalyzer
extends StopwordAnalyzerBase {
    private final Set<?> stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public HindiAnalyzer(Version version, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(version, stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Version)this.matchVersion, stemExclusionSet));
    }

    public HindiAnalyzer(Version version, Set<?> stopwords) {
        this(version, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public HindiAnalyzer(Version version) {
        this(version, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        IndicTokenizer source = new IndicTokenizer(this.matchVersion, reader);
        Object result = new LowerCaseFilter(this.matchVersion, (TokenStream)source);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new IndicNormalizationFilter((TokenStream)result);
        result = new HindiNormalizationFilter((TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        result = new HindiStemFilter((TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = HindiAnalyzer.loadStopwordSet((boolean)false, (Class)HindiAnalyzer.class, (String)HindiAnalyzer.DEFAULT_STOPWORD_FILE, (String)HindiAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

