/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.Group;
import org.chorem.pollen.votecounting.business.Method;
import org.chorem.pollen.votecounting.business.Vote;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.utils.PercentageBehavior;
import org.chorem.pollen.votecounting.utils.Utils;

public class CondorcetMethod
implements Method {
    private Map<Choice, Double> victories;
    private Map<String, Map<Choice, Double>> personVotes;
    private Map<String, Map<Choice, Double>> groupVotes;
    private static final Log log = LogFactory.getLog(CondorcetMethod.class);

    @Override
    public void executeCounting(List<Choice> choices, boolean byGroup) {
        if (byGroup) {
            this.initPersonVotes(choices);
            this.initGroupVotes(choices);
            this.calculateVictories(choices, this.groupVotes, byGroup);
            this.updateChoices(choices);
        } else {
            this.initPersonVotes(choices);
            this.calculateVictories(choices, this.personVotes, byGroup);
            this.updateChoices(choices);
        }
    }

    private void initPersonVotes(List<Choice> choices) {
        this.personVotes = new HashMap<String, Map<Choice, Double>>();
        for (Choice choice : choices) {
            for (Group group : choice.getGroups()) {
                for (Vote vote : group.getVotes()) {
                    Map<Choice, Double> choicesMap = this.personVotes.get(vote.getVotingID());
                    if (choicesMap == null) {
                        choicesMap = new HashMap<Choice, Double>();
                    }
                    choicesMap.put(choice, vote.getValue());
                    this.personVotes.put(vote.getVotingID(), choicesMap);
                }
            }
        }
    }

    private void initGroupVotes(List<Choice> choices) {
        this.groupVotes = new HashMap<String, Map<Choice, Double>>();
        HashMap groupMembers = new HashMap();
        for (Choice choice : choices) {
            for (Group group : choice.getGroups()) {
                HashSet<String> members = (HashSet<String>)groupMembers.get(group.getIdGroup());
                if (members == null) {
                    members = new HashSet<String>();
                }
                for (Vote vote : group.getVotes()) {
                    members.add(vote.getVotingID());
                }
                groupMembers.put(group.getIdGroup(), members);
            }
        }
        for (String groupID : groupMembers.keySet()) {
            HashMap<String, Map<Choice, Double>> membersVotes = new HashMap<String, Map<Choice, Double>>();
            for (String votingID : (Set)groupMembers.get(groupID)) {
                Map<Choice, Double> choicesMap = this.personVotes.get(votingID);
                membersVotes.put(votingID, choicesMap);
            }
            this.calculateVictories(choices, membersVotes, false);
            this.groupVotes.put(groupID, this.victories2votes(this.victories));
            TreeSet<Double> treeVictories = new TreeSet<Double>(this.victories.values());
            for (Choice choice : choices) {
                for (Group group : choice.getGroups()) {
                    if (!group.getIdGroup().equals(groupID)) continue;
                    group.setValue(treeVictories.last());
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("> groupe " + groupID));
            for (Choice choice : this.victories.keySet()) {
                log.debug((Object)(">> choix= " + choice.getIdChoice() + " _ victoires= " + this.victories.get(choice) + " _ classement= " + this.groupVotes.get(groupID).get(choice)));
            }
        }
    }

    private void calculateVictories(List<Choice> choices, Map<String, Map<Choice, Double>> votes, boolean byGroup) {
        this.victories = new HashMap<Choice, Double>();
        for (Choice choice : choices) {
            this.victories.put(choice, 0.0);
        }
        for (String keyVotant : votes.keySet()) {
            for (Choice keyChoice : votes.get(keyVotant).keySet()) {
                Double v = this.getVictories(keyVotant, keyChoice, votes).doubleValue();
                v = byGroup ? Double.valueOf(v * this.getGroupWeight(choices, keyVotant)) : Double.valueOf(v * this.getPersonWeight(choices, keyVotant));
                this.victories.put(keyChoice, this.victories.get(keyChoice) + v);
            }
        }
    }

    private Integer getVictories(String id, Choice choice, Map<String, Map<Choice, Double>> votes) {
        int res = 0;
        Double ref = votes.get(id).get(choice);
        for (Choice keyChoice : this.victories.keySet()) {
            if (votes.get(id).containsKey(keyChoice)) {
                Double val = votes.get(id).get(keyChoice);
                if (!(ref < val)) continue;
                ++res;
                continue;
            }
            ++res;
        }
        return res;
    }

    private Map<Choice, Double> victories2votes(Map<Choice, Double> victories) {
        HashMap<Choice, Double> victories_ = new HashMap<Choice, Double>(victories);
        HashMap<Choice, Double> votes_ = new HashMap<Choice, Double>();
        Integer d = 1;
        Map<Choice, Double> victoriesMax = this.getMax(victories_);
        while (!victoriesMax.isEmpty()) {
            for (Choice choice : victoriesMax.keySet()) {
                votes_.put(choice, d.doubleValue());
                victories_.remove(choice);
            }
            Integer n = d;
            Integer n2 = d = Integer.valueOf(d + 1);
            victoriesMax = this.getMax(victories_);
        }
        return votes_;
    }

    private Map<Choice, Double> getMax(Map<Choice, Double> victories) {
        HashMap<Choice, Double> result = new HashMap<Choice, Double>();
        if (victories.isEmpty()) {
            return result;
        }
        TreeSet<Double> treeVictories = new TreeSet<Double>(victories.values());
        Double max = treeVictories.last();
        for (Choice choice : victories.keySet()) {
            if (!victories.get(choice).equals(max)) continue;
            result.put(choice, victories.get(choice));
        }
        return result;
    }

    private Double getPersonWeight(List<Choice> choices, String id) {
        for (Choice choice : choices) {
            for (Group group : choice.getGroups()) {
                for (Vote vote : group.getVotes()) {
                    if (!id.equals(vote.getVotingID())) continue;
                    return vote.getWeight();
                }
            }
        }
        return null;
    }

    private Double getGroupWeight(List<Choice> choices, String id) {
        for (Choice choice : choices) {
            for (Group group : choice.getGroups()) {
                if (!id.equals(group.getIdGroup())) continue;
                return group.getWeight();
            }
        }
        return null;
    }

    private void updateChoices(List<Choice> choices) {
        for (Choice choice : choices) {
            choice.setValue(this.victories.get(choice));
        }
    }

    @Override
    public void executeStats(List<Choice> choices, boolean groupCounting, Choice choice, ChoiceDTO choiceDTO) {
        ArrayList<PercentageBehavior> list = new ArrayList<PercentageBehavior>(choices);
        choiceDTO.setPercentage(Utils.calculatePercentage(choice, list));
    }
}

