/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.Method;

public class Context {
    private static final Log log = LogFactory.getLog(Context.class);
    private boolean groupCounting;
    private List<Choice> choices;
    private List<Choice> results;
    private Method method;

    public Context(Method method, boolean groupCounting) {
        this.groupCounting = groupCounting;
        this.choices = new ArrayList<Choice>();
        this.results = new ArrayList<Choice>();
        this.method = method;
    }

    public Choice getChoice(String idChoice) {
        for (Choice choice : this.choices) {
            if (!choice.getIdChoice().equals(idChoice)) continue;
            return choice;
        }
        return null;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public List<Choice> getResults() {
        return this.results;
    }

    public void addChoice(String idChoice) {
        this.choices.add(new Choice(idChoice));
    }

    public void addGroup(String idGroup, double weight) {
        for (Choice choice : this.choices) {
            choice.addGroup(idGroup, weight);
        }
    }

    public boolean execute() {
        try {
            this.method.executeMethod(this.choices, this.groupCounting);
        }
        catch (Exception e) {
            log.error((Object)"L'ex\u00e9cution du d\u00e9pouillement a \u00e9chou\u00e9", (Throwable)e);
            return false;
        }
        this.results.clear();
        Choice result = new Choice("");
        for (Choice curr : this.choices) {
            if (curr.value() > result.value()) {
                result = curr;
                this.results.clear();
                continue;
            }
            if (curr.value() != result.value()) continue;
            this.results.add(curr);
        }
        this.results.add(result);
        return true;
    }
}

