/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.business;

import java.util.List;

/**
 * Méthode de dépouillement par pourcentage (pondération des choix). Cette
 * méthode étend la méthode standard en ajoutant la pondération des choix.
 *
 * @author rannou
 * @version $Id: PercentageMethod.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class PercentageMethod extends StandardMethod implements Method {

    @Override
    public double getValueForChoiceByGroup(Choice choice, String idGroup,
            List<String> choicesId) {
        for (String idChoice : choicesId) {
            if (choice.getIdChoice().equals(idChoice)) {
                return choice.getGroup(idGroup).getValue()
                        * choice.getGroup(idGroup).getWeight(); // choice.getGroup(idGroup).getValue() remplace 1

            }
        }
        return 0;
    }
}