/*
 * #%L
 * Pollen :: VoteCounting Api
 * $Id: VoteForChoice.java 3593 2012-08-12 11:01:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-votecounting-api/src/main/java/org/chorem/pollen/votecounting/model/VoteForChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.model;

/**
 * A vote for a choice.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class VoteForChoice implements ChoiceIdAble {

    /** Id of the choice. */
    private String choiceId;

    /** Value of the vote for this choice. */
    private Double voteValue;

    public static VoteForChoice newVote(String choiceId, Double voteValue) {
        VoteForChoice vote = new VoteForChoice();
        vote.setChoiceId(choiceId);
        vote.setVoteValue(voteValue);
        return vote;
    }

    @Override
    public String getChoiceId() {
        return choiceId;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public Double getVoteValue() {
        return voteValue;
    }

    public void setVoteValue(Double voteValue) {
        this.voteValue = voteValue;
    }
}
