/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.services.ArrayEventContext;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;
import org.nuiton.util.ArrayUtil;

public class Chart {
    public static final int PIE = 1;
    public static final int PIE3D = 2;
    public static final int RING = 3;
    @Parameter
    private String _title = "";
    @Parameter(required=true)
    private int _type;
    @Parameter(required=true)
    private int _width;
    @Parameter(required=true)
    private int _height;
    @Parameter(required=true)
    private List<Object> _values;
    @Parameter(required=false)
    private List<Object> _subtitles;
    @Inject
    private ComponentResources _resources;
    @Inject
    private TypeCoercer typeCoercer;

    void beginRender(MarkupWriter writer) {
        Object[] size;
        Object[] params = new Object[]{this._title, this._type, this._width, this._height};
        if (this._subtitles != null) {
            size = new Object[]{this._subtitles.size()};
            params = ArrayUtil.concat((Object[][])new Object[][]{params, size});
            params = ArrayUtil.concat((Object[][])new Object[][]{params, this._subtitles.toArray()});
        } else {
            size = new Object[]{0};
            params = ArrayUtil.concat((Object[][])new Object[][]{params, size});
        }
        params = ArrayUtil.concat((Object[][])new Object[][]{params, this._values.toArray()});
        Link link = this._resources.createEventLink("chart", params);
        Element img = writer.element("img", new Object[]{"src", link});
        this._resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public StreamResponse onChart(String title, int type, int width, int height, int nbSubtitles, Object ... objects) {
        ArrayEventContext ec = new ArrayEventContext(this.typeCoercer, objects);
        ArrayList<String> subtitles = new ArrayList<String>(nbSubtitles);
        for (int i = 5; i < 5 + nbSubtitles; i += 2) {
            String key = (String)ec.get(String.class, i);
            String value = (String)ec.get(String.class, i + 1);
            subtitles.add(key);
            subtitles.add(value);
        }
        DefaultKeyedValues values = new DefaultKeyedValues();
        for (int i = 5 + nbSubtitles; i < ec.getCount(); i += 2) {
            String key = (String)ec.get(String.class, i);
            Double value = (Double)ec.get(Double.class, i + 1);
            values.addValue((Comparable)((Object)key), (Number)value);
        }
        values.sortByValues(SortOrder.DESCENDING);
        DefaultPieDataset data = new DefaultPieDataset((KeyedValues)values);
        PiePlot plot = null;
        switch (type) {
            case 1: {
                plot = new PiePlot((PieDataset)data);
                break;
            }
            case 2: {
                plot = new PiePlot3D((PieDataset)data);
                break;
            }
            case 3: {
                plot = new RingPlot((PieDataset)data);
                break;
            }
            default: {
                plot = new PiePlot((PieDataset)data);
            }
        }
        plot.setCircular(true);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} {2}"));
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1}"));
        plot.setNoDataMessage("No Data");
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setTitle(new TextTitle(title, new Font("SansSerif", 1, 12)));
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        if (subtitles != null) {
            Font subtitlesFont = new Font("SansSerif", 2, 11);
            for (int i = 0; i < subtitles.size(); i += 2) {
                String subtitle = subtitles.get(i) + "=" + subtitles.get(i + 1);
                TextTitle textTitle = new TextTitle(subtitle, subtitlesFont);
                chart.addSubtitle((Title)textTitle);
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

