/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.it;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.ui.it.PollenUrlFixtures;
import org.chorem.pollen.ui.it.WebDriverResources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.nuiton.util.DateUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@RunWith(value=Parameterized.class)
public abstract class AbstractPollenIT {
    protected Log log = LogFactory.getLog(this.getClass());
    @ClassRule
    public static final WebDriverResources seleniumServer = new WebDriverResources();
    protected static final PollenUrlFixtures urlFixtures = new PollenUrlFixtures();
    protected final Class<? extends WebDriver> driverType;
    @Rule
    public final TestName testName = new TestName();
    protected WebDriver driver;

    @Parameterized.Parameters
    public static Iterable<Object[]> driverTypes() {
        return WebDriverResources.driverTypes();
    }

    protected AbstractPollenIT(Class<? extends WebDriver> driverType) {
        this.driverType = driverType;
    }

    @Before
    public void setUp() throws Exception {
        this.driver = seleniumServer.getDriver(this.driverType);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("start test " + this.getClass().getName() + "#" + this.testName.getMethodName() + " (" + this.driverType.getSimpleName() + ")"));
        }
        this.gotoUrl(urlFixtures.home(), false);
    }

    @After
    public void after() {
        this.logout();
    }

    protected void logout() {
        this.gotoUrl(urlFixtures.logout(), urlFixtures.home(), false);
    }

    protected void gotoUrl(String url, boolean strict) {
        this.gotoUrl(url, null, strict);
    }

    protected void gotoUrl(String url) {
        this.gotoUrl(url, null, true);
    }

    protected void gotoUrl(String url, String fallBackUrl) {
        this.gotoUrl(url, fallBackUrl, true);
    }

    protected void gotoUrl(String url, String fallBackUrl, boolean strict) {
        this.driver.get(url);
        String expectedUrl = fallBackUrl == null ? url : fallBackUrl;
        this.checkCurrentUrl(expectedUrl, strict);
    }

    protected void checkCurrentUrl(String expectedUrl, boolean strict) {
        if (strict) {
            Assert.assertEquals((String)("Current url [" + this.driver.getCurrentUrl() + "] should be " + expectedUrl), (Object)expectedUrl, (Object)this.driver.getCurrentUrl());
        } else {
            Assert.assertTrue((String)("Current url [" + this.driver.getCurrentUrl() + "] should starts with " + expectedUrl), (boolean)this.driver.getCurrentUrl().startsWith(expectedUrl));
        }
    }

    protected void checkNoElement(By by) {
        try {
            this.findElement(by);
            Assert.fail();
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    protected WebElement findElement(By by) {
        WebElement element = this.driver.findElement(by);
        return element;
    }

    protected List<WebElement> findElements(By by) {
        List result = this.driver.findElements(by);
        return result;
    }

    protected void connect(String username, String password) {
        WebElement loginClick = this.findElement(By.id((String)"tologin"));
        loginClick.click();
        WebElement loginElement = this.findElement(By.name((String)"login"));
        Assert.assertEquals((Object)"input", (Object)loginElement.getTagName());
        Assert.assertTrue((boolean)loginElement.isDisplayed());
        loginElement.sendKeys(new CharSequence[]{username});
        WebElement passwordElement = this.findElement(By.name((String)"password"));
        Assert.assertTrue((boolean)passwordElement.isDisplayed());
        Assert.assertEquals((Object)"input", (Object)passwordElement.getTagName());
        passwordElement.sendKeys(new CharSequence[]{password});
        WebElement submit = this.findElement(By.name((String)"action:login"));
        submit.click();
    }

    protected void sendKeysById(String webElementId, String value) {
        this.sendKeysBy(By.id((String)webElementId), value);
    }

    protected void sendKeysByName(String webElementName, String value) {
        By byName = By.name((String)webElementName);
        this.sendKeysBy(byName, value);
    }

    protected void sendKeysBy(By by, String value) {
        WebElement webElement = this.findElement(by);
        Assert.assertEquals((Object)"input", (Object)webElement.getTagName());
        Assert.assertTrue((boolean)webElement.isDisplayed());
        webElement.sendKeys(new CharSequence[]{value});
        Assert.assertEquals((Object)value, (Object)webElement.getAttribute("value"));
    }

    protected void checkWebElementValue(By by, String expectedValue) {
        WebElement webElement = this.findElement(by);
        Assert.assertEquals((Object)"input", (Object)webElement.getTagName());
        Assert.assertTrue((boolean)webElement.isDisplayed());
        Assert.assertEquals((Object)expectedValue, (Object)webElement.getAttribute("value"));
    }

    protected String datePattern() {
        return "dd/MM/yyyy HH:mm";
    }

    protected String date(int year, int month, int day, int hour, int minute) {
        Calendar instance = Calendar.getInstance();
        instance.set(year, month, day, hour, minute);
        Date date = instance.getTime();
        String dateString = DateUtil.formatDate((Date)date, (String)this.datePattern());
        return dateString;
    }

    protected String date(int year, int month, int day) {
        return this.date(year, month, day, 0, 0);
    }

    protected void userLogin() {
        this.connect("user", "user");
    }

    protected void user2Login() {
        this.connect("user2", "user2");
    }

    protected void adminLogin() {
        this.connect("admin", "admin");
    }
}

