/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: ConfirmPollAction.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/ConfirmPollAction.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.services.impl.PollService;

/**
 * To confirm a poll action (such as delete or close).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ConfirmPollAction extends AbstractPollUriIdAction {

    private static final long serialVersionUID = 1L;

    protected Poll poll;

    protected String redirectUrl;

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public Poll getPoll() {
        return poll;
    }

    @Override
    public String execute() throws Exception {
        String pollId = getPollId();
        Preconditions.checkNotNull(pollId);
        poll = newService(PollService.class).getPollByPollId(pollId);
        return SUCCESS;
    }
}
