/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.ChildFavoriteList;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.FavoriteListDao;
import org.chorem.pollen.persistence.entity.FavoriteListMember;
import org.chorem.pollen.persistence.entity.FavoriteListMemberDao;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.VoterList;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.bean.ChildFavoriteListBean;
import org.chorem.pollen.services.bean.FavoriteListBean;
import org.chorem.pollen.services.bean.FavoriteListMemberBean;
import org.chorem.pollen.services.bean.PollenBean;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.export.ChildFavoriteListExport;
import org.chorem.pollen.services.bean.export.ExportBean;
import org.chorem.pollen.services.bean.export.FavoriteListExport;
import org.chorem.pollen.services.bean.export.FavoriteListMemberExport;
import org.chorem.pollen.services.bean.export.FavoriteListsExport;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.FavoriteListImportException;
import org.chorem.pollen.services.service.FavoriteListImportFromFile;
import org.chorem.pollen.services.service.FavoriteListImportFromLdap;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.util.pagination.PaginationOrder;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class FavoriteListService
extends PollenServiceSupport {
    public FavoriteListBean toFavoriteListBean(FavoriteList entity) {
        FavoriteListBean bean = new FavoriteListBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        long countChildren = this.getChildFavoriteListDao().forParentEquals(entity).count();
        bean.setCountChildren(countChildren);
        long countMembers = this.getFavoriteListMemberDao().forFavoriteListEquals(entity).count();
        bean.setCountMembers(countMembers);
        return bean;
    }

    protected ChildFavoriteListBean toChildFavoriteListBean(ChildFavoriteList entity) {
        ChildFavoriteListBean bean = new ChildFavoriteListBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setChild(this.toFavoriteListBean(entity.getChild()));
        bean.setWeight(entity.getWeight());
        return bean;
    }

    protected FavoriteListMemberBean toFavoriteListMemberBean(FavoriteListMember entity) {
        FavoriteListMemberBean bean = new FavoriteListMemberBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        bean.setEmail(entity.getEmail());
        bean.setWeight(entity.getWeight());
        return bean;
    }

    public PaginationResult<FavoriteListBean> getFavoriteLists(PaginationParameter page, String search) {
        PollenUser user = this.checkAndGetConnectedUser();
        page = FavoriteListService.orderedPage(page, "name");
        PaginationResult favoriteLists = StringUtils.isNotBlank((CharSequence)search) ? this.getFavoriteListDao().search(user, search, page) : this.getFavoriteListDao().forPollenUserEquals(user).findPage(page);
        return favoriteLists.transform(this::toFavoriteListBean);
    }

    public FavoriteListBean getFavoriteList(String favoriteListId) {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        return this.toFavoriteListBean(favoriteList);
    }

    public PollenEntityRef<FavoriteList> createFavoriteList(FavoriteListBean favoriteList) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteList);
        this.checkIsNotPersisted(favoriteList);
        List<FavoriteList> existingFavoriteLists = this.getFavoriteLists0(user);
        ErrorMap errorMap = this.checkFavoriteList(existingFavoriteLists, favoriteList);
        errorMap.failIfNotEmpty();
        FavoriteList result = this.saveFavoriteList(user, favoriteList);
        this.commit();
        this.getNotificationService().onFavoriteListAdded(user, result);
        return PollenEntityRef.of(result);
    }

    public FavoriteListBean editFavoriteList(FavoriteListBean favoriteList) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteList);
        this.checkIsPersisted(favoriteList);
        List<FavoriteList> existingFavoriteLists = this.getFavoriteLists0(user);
        ErrorMap errorMap = this.checkFavoriteList(existingFavoriteLists, favoriteList);
        errorMap.failIfNotEmpty();
        FavoriteList result = this.saveFavoriteList(user, favoriteList);
        this.commit();
        this.getNotificationService().onFavoriteListEdited(user, result);
        return this.toFavoriteListBean(result);
    }

    public void deleteFavoriteList(String favoriteListId) {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        this.getFavoriteListDao().delete(favoriteList);
        this.commit();
        this.getNotificationService().onFavoriteListDeleted(user, favoriteList);
    }

    public PaginationResult<FavoriteListMemberBean> getFavoriteListMembers(String favoriteListId, String search, PaginationParameter page) {
        return this.getFavoriteListMembers(favoriteListId, search, page, 0);
    }

    protected PaginationResult<FavoriteListMemberBean> getFavoriteListMembers(String favoriteListId, String search, PaginationParameter page, int offset) {
        PaginationResult members;
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        page = FavoriteListService.orderedPage(page, "name");
        if (offset == 0 || page.getPageSize() == -1) {
            members = StringUtils.isNotBlank((CharSequence)search) ? this.getFavoriteListMemberDao().search(favoriteList, search, page) : this.getFavoriteListMemberDao().forFavoriteListEquals(favoriteList).findPage(page);
        } else {
            long count;
            List elements;
            int startIndex = Math.max(0, page.getStartIndex() - offset);
            int endIndex = Math.max(0, page.getEndIndex() - offset);
            PaginationOrder order = (PaginationOrder)page.getOrderClauses().getFirst();
            if (StringUtils.isNotBlank((CharSequence)search)) {
                elements = this.getFavoriteListMemberDao().search(favoriteList, search, order.getClause() + (order.isDesc() ? " DESC" : ""), startIndex, endIndex);
                count = this.getFavoriteListMemberDao().countSearch(favoriteList, search);
            } else {
                elements = this.getFavoriteListMemberDao().forFavoriteListEquals(favoriteList).setOrderByArguments(new String[]{order.getClause() + (order.isDesc() ? " DESC" : "")}).find(startIndex, endIndex);
                count = this.getFavoriteListMemberDao().forFavoriteListEquals(favoriteList).count();
            }
            members = PaginationResult.of((List)elements, (long)count, (PaginationParameter)page);
        }
        return members.transform(this::toFavoriteListMemberBean);
    }

    public FavoriteListMemberBean getFavoriteListMember(String favoriteListId, String memberId) {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(memberId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        FavoriteListMember member = this.getFavoriteListMember0(favoriteList, memberId);
        return this.toFavoriteListMemberBean(member);
    }

    public PollenEntityRef<FavoriteListMember> addFavoriteListMember(String favoriteListId, FavoriteListMemberBean member) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(member);
        this.checkIsNotPersisted(member);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        List<FavoriteListMember> existingFavorliteListMembers = this.getFavoriteListMembers0(favoriteList);
        ErrorMap errorMap = this.checkFavoriteListMember(existingFavorliteListMembers, member);
        errorMap.failIfNotEmpty();
        FavoriteListMember result = this.saveFavoriteListMember(favoriteList, member);
        this.commit();
        return PollenEntityRef.of(result);
    }

    public FavoriteListMemberBean editFavoriteListMember(String favoriteListId, FavoriteListMemberBean member) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(member);
        this.checkIsPersisted(member);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        List<FavoriteListMember> existingFavorliteListMembers = this.getFavoriteListMembers0(favoriteList);
        ErrorMap errorMap = this.checkFavoriteListMember(existingFavorliteListMembers, member);
        errorMap.failIfNotEmpty();
        FavoriteListMember result = this.saveFavoriteListMember(favoriteList, member);
        this.commit();
        return this.toFavoriteListMemberBean(result);
    }

    public void deleteFavoriteListMember(String favoriteListId, String memberId) {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(memberId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        FavoriteListMember member = this.getFavoriteListMember0(favoriteList, memberId);
        this.getFavoriteListMemberDao().delete(member);
        this.commit();
    }

    public void importFavoriteListMembersFromCsv(String favoriteListId, File file) throws FavoriteListImportException {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(file);
        FavoriteList favoriteList = this.getFavoriteList0(connectedUser, favoriteListId);
        List<FavoriteListMember> favoriteListMembers = this.getFavoriteListMembers0(favoriteList);
        FavoriteListImportFromFile importer = this.newService(FavoriteListImportFromFile.class);
        importer.setFile(file);
        importer.doImport(favoriteList, favoriteListMembers);
    }

    public void importFavoriteListMembersFromLdap(String favoriteListId, String ldap) throws FavoriteListImportException {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(ldap);
        FavoriteList favoriteList = this.getFavoriteList0(connectedUser, favoriteListId);
        List<FavoriteListMember> favoriteListMembers = this.getFavoriteListMembers0(favoriteList);
        FavoriteListImportFromLdap importer = this.newService(FavoriteListImportFromLdap.class);
        importer.setLdap(ldap);
        importer.doImport(favoriteList, favoriteListMembers);
    }

    protected List<FavoriteList> getFavoriteLists0(PollenUser user) {
        return this.getFavoriteListDao().forPollenUserEquals(user).findAll();
    }

    protected FavoriteList getFavoriteList0(PollenUser user, String favoriteListId) {
        FavoriteList result = (FavoriteList)this.getFavoriteListDao().forTopiaIdEquals(favoriteListId).findUnique();
        if (!user.equals((Object)result.getPollenUser())) {
            throw new InvalidEntityLinkException("pollenUser", (PollenEntity)result, (PollenEntity)user);
        }
        return result;
    }

    protected List<FavoriteListMember> getFavoriteListMembers0(FavoriteList favoriteList) {
        return this.getFavoriteListMemberDao().forFavoriteListEquals(favoriteList).findAll();
    }

    protected FavoriteListMember getFavoriteListMember0(FavoriteList favoriteList, String memberId) {
        FavoriteListMember result = (FavoriteListMember)this.getFavoriteListMemberDao().forTopiaIdEquals(memberId).findUnique();
        if (!favoriteList.equals((Object)result.getFavoriteList())) {
            throw new InvalidEntityLinkException("favoriteList", (PollenEntity)favoriteList, (PollenEntity)result);
        }
        return result;
    }

    protected FavoriteList saveFavoriteList(PollenUser user, FavoriteListBean favoriteList) {
        FavoriteList toSave;
        FavoriteListDao favoriteListDao = this.getFavoriteListDao();
        boolean persisted = favoriteList.isPersisted();
        if (persisted) {
            toSave = this.getFavoriteList0(user, favoriteList.getEntityId());
        } else {
            toSave = (FavoriteList)favoriteListDao.create();
            toSave.setPollenUser(user);
            toSave.setOwner((PollenPrincipal)this.getSecurityContext().getMainPrincipal().orElse(null));
        }
        toSave.setName(favoriteList.getName());
        return toSave;
    }

    protected FavoriteListMember saveFavoriteListMember(FavoriteList favoriteList, FavoriteListMemberBean favoriteListMember) {
        FavoriteListMember toSave;
        FavoriteListMemberDao favoriteListDao = this.getFavoriteListMemberDao();
        boolean persisted = favoriteListMember.isPersisted();
        if (persisted) {
            toSave = this.getFavoriteListMember0(favoriteList, favoriteListMember.getEntityId());
        } else {
            toSave = (FavoriteListMember)favoriteListDao.create();
            toSave.setFavoriteList(favoriteList);
        }
        toSave.setName(favoriteListMember.getName());
        toSave.setEmail(this.getCleanMail(favoriteListMember.getEmail()));
        toSave.setWeight(favoriteListMember.getWeight());
        return toSave;
    }

    protected ChildFavoriteList getChildList0(FavoriteList parentList, String childListId) {
        ChildFavoriteList result = (ChildFavoriteList)this.getChildFavoriteListDao().forTopiaIdEquals(childListId).findUnique();
        if (!parentList.equals((Object)result.getParent())) {
            throw new InvalidEntityLinkException("parent", (PollenEntity)parentList, (PollenEntity)result);
        }
        return result;
    }

    protected List<ChildFavoriteList> getChildrenLists0(FavoriteList parentList) {
        return this.getChildFavoriteListDao().forParentEquals(parentList).findAll();
    }

    protected List<ChildFavoriteList> getAllChildrenLists0(PollenUser user) {
        return this.getChildFavoriteListDao().forParent_PollenUserEquals(user).findAll();
    }

    protected ErrorMap checkFavoriteList(List<FavoriteList> existingFavoriteLists, FavoriteListBean favoriteList) {
        ErrorMap errors = new ErrorMap();
        String favoriteListName = favoriteList.getName();
        boolean nameNotBlank = this.checkNotBlank(errors, "name", favoriteListName, I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteList.name.empty", (Object[])new Object[0]));
        if (nameNotBlank) {
            Optional<FavoriteList> sameName = existingFavoriteLists.stream().filter(favoriteList1 -> favoriteList1.getTopiaId() == null || !favoriteList1.getTopiaId().equals(favoriteList.getEntityId())).filter(favoriteList1 -> favoriteList1.getName().equals(favoriteListName)).findFirst();
            this.check(errors, "name", sameName.isEmpty(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteList.name.already.used", (Object[])new Object[]{favoriteListName}));
        }
        return errors;
    }

    protected ErrorMap checkFavoriteListMember(List<FavoriteListMember> existingFavoriteListMembers, FavoriteListMemberBean favoriteListMember) {
        boolean emailValid;
        String memberEmail;
        boolean emailNotBlank;
        boolean nameNotBlank;
        ErrorMap errors = new ErrorMap();
        boolean voterListMemberExists = favoriteListMember.isPersisted();
        HashSet memberNames = Sets.newHashSet();
        HashSet memberEmails = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(existingFavoriteListMembers)) {
            for (FavoriteListMember favoriteListMember1 : existingFavoriteListMembers) {
                if (voterListMemberExists && favoriteListMember1.getTopiaId().equals(favoriteListMember.getEntityId())) continue;
                memberNames.add(favoriteListMember1.getName());
                memberEmails.add(favoriteListMember1.getEmail());
            }
        }
        if (nameNotBlank = this.checkNotBlank(errors, "name", favoriteListMember.getName(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteListMember.name.empty", (Object[])new Object[0]))) {
            boolean added = memberNames.add(favoriteListMember.getName());
            this.check(errors, "name", added, I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteListMember.name.already.used", (Object[])new Object[]{favoriteListMember.getName()}));
        }
        if ((emailNotBlank = this.checkNotBlank(errors, "email", memberEmail = this.getCleanMail(favoriteListMember.getEmail()), I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteListMember.email.empty", (Object[])new Object[0]))) && (emailValid = this.checkValidEmail(errors, "email", memberEmail, I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteListMember.email.invalid", (Object[])new Object[]{memberEmail})))) {
            boolean emailAdded = memberEmails.add(memberEmail);
            this.check(errors, "email", emailAdded, I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteListMember.email.already.used", (Object[])new Object[]{memberEmail}));
        }
        this.check(errors, "weight", favoriteListMember.getWeight() > 0.0, I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteListMember.weight.negativeOrNull", (Object[])new Object[]{favoriteListMember.getWeight()}));
        return errors;
    }

    protected ErrorMap checkChildList(FavoriteList parentList, List<ChildFavoriteList> existingChildList, ChildFavoriteListBean childFavoriteList) {
        boolean sameList;
        ErrorMap errors = new ErrorMap();
        boolean childListExists = childFavoriteList.isPersisted();
        if (!childListExists && CollectionUtils.isNotEmpty(existingChildList)) {
            Optional<String> childListAlreadyExist = existingChildList.stream().filter(child -> parentList.equals((Object)child.getParent())).map(ChildFavoriteList::getChild).filter(list -> list.getName().equals(childFavoriteList.getChild().getName())).map(AbstractPollenEntity::getTopiaId).findFirst();
            this.check(errors, "child", childListAlreadyExist.isEmpty(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.childFavoriteList.already.used", (Object[])new Object[]{childFavoriteList.getChild().getName()}));
        }
        this.check(errors, "child", !(sameList = parentList.getName().equals(childFavoriteList.getChild().getName())), I18n.l((Locale)this.getLocale(), (String)"pollen.error.childFavoriteList.sameParentChild", (Object[])new Object[]{parentList.getName()}));
        this.check(errors, "child", sameList || !this.isAncestorOrSelf(childFavoriteList.getChild().getName(), parentList.getName(), existingChildList), I18n.l((Locale)this.getLocale(), (String)"pollen.error.childFavoriteList.childIsAncestor", (Object[])new Object[]{parentList.getName(), childFavoriteList.getChild().getName()}));
        this.check(errors, "weight", childFavoriteList.getWeight() > 0.0, I18n.l((Locale)this.getLocale(), (String)"pollen.error.childFavoriteList.weight.negativeOrNull", (Object[])new Object[]{childFavoriteList.getWeight()}));
        return errors;
    }

    protected boolean isAncestorOrSelf(String ancestorFavoriteListName, String favoriteListName, List<ChildFavoriteList> existingChildList) {
        boolean result;
        block1: {
            ChildFavoriteList childFavoriteList;
            result = ancestorFavoriteListName.equals(favoriteListName);
            if (result) break block1;
            List<ChildFavoriteList> childrenFavoriteList = existingChildList.stream().filter(child -> favoriteListName.equals(child.getChild().getName())).toList();
            Iterator<ChildFavoriteList> iterator = childrenFavoriteList.iterator();
            while (iterator.hasNext() && !(result = this.isAncestorOrSelf(ancestorFavoriteListName, (childFavoriteList = iterator.next()).getParent().getName(), existingChildList))) {
            }
        }
        return result;
    }

    public PaginationResult<ChildFavoriteListBean> getChildrenLists(String favoriteListId, String search, PaginationParameter page) {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        PaginationParameter orderedPage = page;
        if (!page.getOrderClauses().isEmpty() && "name".equals(((PaginationOrder)page.getOrderClauses().getFirst()).getClause())) {
            orderedPage = PaginationParameter.of((int)page.getPageNumber(), (int)page.getPageSize(), (String)"child.name", (boolean)((PaginationOrder)page.getOrderClauses().getFirst()).isDesc());
        }
        PaginationResult children = StringUtils.isNotBlank((CharSequence)search) ? this.getChildFavoriteListDao().search(favoriteList, search, orderedPage) : this.getChildFavoriteListDao().forParentEquals(favoriteList).findPage(orderedPage);
        return children.transform(this::toChildFavoriteListBean);
    }

    public ChildFavoriteListBean getChildList(String favoriteListId, String childListId) {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(childListId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        ChildFavoriteList child = this.getChildList0(favoriteList, childListId);
        return this.toChildFavoriteListBean(child);
    }

    public PollenEntityRef<ChildFavoriteList> addChildList(String favoriteListId, ChildFavoriteListBean childList) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(childList);
        this.checkIsNotPersisted(childList);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        List<ChildFavoriteList> existingChildFavoriteList = this.getAllChildrenLists0(user);
        ErrorMap errorMap = this.checkChildList(favoriteList, existingChildFavoriteList, childList);
        errorMap.failIfNotEmpty();
        ChildFavoriteList result = this.saveChildFavoriteList(favoriteList, childList);
        this.commit();
        return PollenEntityRef.of(result);
    }

    public ChildFavoriteListBean editChildList(String favoriteListId, ChildFavoriteListBean childList) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(childList);
        this.checkIsPersisted(childList);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        List<ChildFavoriteList> existingChildFavoriteList = this.getChildrenLists0(favoriteList);
        ErrorMap errorMap = this.checkChildList(favoriteList, existingChildFavoriteList, childList);
        errorMap.failIfNotEmpty();
        ChildFavoriteList result = this.saveChildFavoriteList(favoriteList, childList);
        this.commit();
        return this.toChildFavoriteListBean(result);
    }

    public void removeChildList(String favoriteListId, String childListId) {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(favoriteListId);
        this.checkNotNull(childListId);
        FavoriteList favoriteList = this.getFavoriteList0(user, favoriteListId);
        ChildFavoriteList childFavoriteList = this.getChildList0(favoriteList, childListId);
        this.getChildFavoriteListDao().delete(childFavoriteList);
        this.commit();
    }

    protected ChildFavoriteList saveChildFavoriteList(FavoriteList favoriteList, ChildFavoriteListBean childList) {
        ChildFavoriteList toSave;
        boolean persisted = childList.isPersisted();
        if (persisted) {
            toSave = this.getChildList0(favoriteList, childList.getEntityId());
        } else {
            toSave = (ChildFavoriteList)this.getChildFavoriteListDao().create();
            toSave.setParent(favoriteList);
        }
        FavoriteList child = this.getFavoriteList0(this.getConnectedUser(), childList.getChild().getEntityId());
        toSave.setChild(child);
        toSave.setWeight(childList.getWeight());
        return toSave;
    }

    public FavoriteListBean importFavoriteListMembersFromVoterList(String voterListId) throws InvalidFormException {
        PollenUser user = this.checkAndGetConnectedUser();
        this.checkNotNull(voterListId);
        VoterList voterList = (VoterList)this.getVoterListDao().forTopiaIdEquals(voterListId).findUnique();
        List<FavoriteList> existingFavoriteLists = this.getFavoriteLists0(user);
        ErrorMap errors = new ErrorMap();
        ErrorMap errorMap = this.checkImportVoterList(voterList, existingFavoriteLists, errors);
        errorMap.failIfNotEmpty();
        FavoriteList favoriteList = this.importFavoriteListMembersFromVoterList(voterList, user);
        this.commit();
        return this.toFavoriteListBean(favoriteList);
    }

    protected FavoriteList importFavoriteListMembersFromVoterList(VoterList voterList, PollenUser user) {
        FavoriteList toSave = (FavoriteList)this.getFavoriteListDao().create();
        toSave.setName(voterList.getName());
        toSave.setPollenUser(user);
        toSave.setOwner((PollenPrincipal)this.getSecurityContext().getMainPrincipal().orElse(null));
        for (VoterListMember voterListMember : this.getVoterListMemberDao().forVoterListEquals(voterList).findAll()) {
            FavoriteListMember memberToSave = (FavoriteListMember)this.getFavoriteListMemberDao().create();
            memberToSave.setName(voterListMember.getMember().getName());
            memberToSave.setEmail(voterListMember.getMember().getEmail());
            memberToSave.setWeight(voterListMember.getWeight());
            memberToSave.setFavoriteList(toSave);
        }
        for (VoterList childVoterList : this.getVoterListDao().forParentEquals(voterList).findAll()) {
            FavoriteList subFavoriteList = this.importFavoriteListMembersFromVoterList(childVoterList, user);
            ChildFavoriteList childFavoriteListToSave = (ChildFavoriteList)this.getChildFavoriteListDao().create();
            childFavoriteListToSave.setChild(subFavoriteList);
            childFavoriteListToSave.setParent(toSave);
            childFavoriteListToSave.setWeight(childVoterList.getWeight());
        }
        this.getNotificationService().onFavoriteListAdded(user, toSave);
        return toSave;
    }

    protected ErrorMap checkImportVoterList(VoterList voterList, List<FavoriteList> existingFavoriteLists, ErrorMap errors) {
        String name = voterList.getName();
        boolean nameAlreadyUsed = existingFavoriteLists.stream().anyMatch(fl -> fl.getName().equals(name));
        this.check(errors, "name", !nameAlreadyUsed, I18n.l((Locale)this.getLocale(), (String)"pollen.error.favoriteList.name.already.used", (Object[])new Object[]{name}));
        List childrenVoterLists = this.getVoterListDao().forParentEquals(voterList).addEquals("poll", (Object)voterList.getPoll()).findAll();
        for (VoterList childVoterList : childrenVoterLists) {
            this.checkImportVoterList(childVoterList, existingFavoriteLists, errors);
        }
        return errors;
    }

    public int importFavoriteLists(File favoriteListsExportFile) throws InvalidFormException {
        FileReader reader;
        PollenUser user = this.checkAndGetConnectedUser();
        Gson gson = new Gson();
        try {
            reader = new FileReader(favoriteListsExportFile);
        }
        catch (FileNotFoundException e) {
            throw new PollenTechnicalException(e);
        }
        List<Object> favoriteLists = Lists.newArrayList();
        try {
            FavoriteListsExport favoriteListsExport = (FavoriteListsExport)gson.fromJson((Reader)reader, FavoriteListsExport.class);
            List<FavoriteList> existingFavoriteLists = this.getFavoriteLists0(user);
            ErrorMap errorMap = this.checkImportFavoriteLists(favoriteListsExport, existingFavoriteLists);
            errorMap.failIfNotEmpty();
            favoriteLists = this.saveImportFavoriteLists(favoriteListsExport, user);
            this.commit();
        }
        catch (JsonSyntaxException e) {
            ErrorMap errors = new ErrorMap();
            errors.addError("file", I18n.l((Locale)this.getLocale(), (String)"pollen.error.import.favoriteList.parser", (Object[])new Object[]{e.getMessage()}));
            errors.failIfNotEmpty();
        }
        return favoriteLists.size();
    }

    private List<FavoriteList> saveImportFavoriteLists(FavoriteListsExport favoriteListsExport, PollenUser user) {
        HashMap favoriteListByExport = Maps.newHashMap();
        for (FavoriteListExport favoriteListExport : favoriteListsExport.getFavoriteLists()) {
            FavoriteList favoriteList = favoriteListExport.toEntity();
            favoriteList.setPollenUser(user);
            favoriteList.setOwner((PollenPrincipal)this.getSecurityContext().getMainPrincipal().orElse(null));
            this.getFavoriteListDao().create((PollenEntity)favoriteList);
            favoriteListByExport.put(favoriteListExport, favoriteList);
            for (FavoriteListMemberExport favoriteListMemberExport : favoriteListExport.getMembers()) {
                FavoriteListMember member = favoriteListMemberExport.toEntity();
                member.setFavoriteList(favoriteList);
                this.getFavoriteListMemberDao().create((PollenEntity)member);
            }
        }
        List<FavoriteList> favoriteLists = this.getFavoriteLists0(user);
        for (FavoriteListExport favoriteListExport : favoriteListsExport.getFavoriteLists()) {
            FavoriteList favoriteList = (FavoriteList)favoriteListByExport.get(favoriteListExport);
            for (ChildFavoriteListExport childFavoriteListExport : favoriteListExport.getChildren()) {
                ChildFavoriteList childFavoriteList = childFavoriteListExport.toEntity(favoriteList, favoriteLists);
                this.getChildFavoriteListDao().create((PollenEntity)childFavoriteList);
            }
        }
        return Lists.newArrayList(favoriteListByExport.values());
    }

    private ErrorMap checkImportFavoriteLists(FavoriteListsExport favoriteListsExport, List<FavoriteList> existingFavoriteLists) {
        ErrorMap errors = new ErrorMap();
        this.check(errors, "version", "1.0.0".equals(favoriteListsExport.getVersion()), I18n.l((Locale)this.getLocale(), (String)"pollen.error.import.favoriteList.version", (Object[])new Object[]{favoriteListsExport.getVersion()}));
        HashMap favoriteListByExport = Maps.newHashMap();
        int favoriteListIndex = 0;
        for (FavoriteListExport favoriteListExport : favoriteListsExport.getFavoriteLists()) {
            ErrorMap errorsList = this.checkFavoriteList(existingFavoriteLists, favoriteListExport.toBean());
            FavoriteList favoriteList = favoriteListExport.toEntity();
            existingFavoriteLists.add(favoriteList);
            favoriteListByExport.put(favoriteListExport, favoriteList);
            LinkedList members = Lists.newLinkedList();
            int memberIndex = 0;
            for (FavoriteListMemberExport favoriteListMemberExport : favoriteListExport.getMembers()) {
                ErrorMap errorsMember = this.checkFavoriteListMember(members, favoriteListMemberExport.toBean());
                errorsMember.copyTo(errorsList, ".members[" + memberIndex + "]");
                members.add(favoriteListMemberExport.toEntity());
                ++memberIndex;
            }
            errorsList.copyTo(errors, "favoriteLists[" + favoriteListIndex + "]");
            ++favoriteListIndex;
        }
        favoriteListIndex = 0;
        for (FavoriteListExport favoriteListExport : favoriteListsExport.getFavoriteLists()) {
            FavoriteList favoriteList = (FavoriteList)favoriteListByExport.get(favoriteListExport);
            LinkedList children = Lists.newLinkedList();
            int childIndex = 0;
            for (ChildFavoriteListExport childFavoriteListExport : favoriteListExport.getChildren()) {
                ErrorMap errorsChild = this.checkChildList(favoriteList, children, this.toChildFavoriteListBean(childFavoriteListExport, existingFavoriteLists));
                errorsChild.copyTo(errors, "favoriteLists[" + favoriteListIndex + "].children[" + childIndex + "]");
                children.add(childFavoriteListExport.toEntity(favoriteList, existingFavoriteLists));
                ++childIndex;
            }
        }
        return errors;
    }

    protected ChildFavoriteListBean toChildFavoriteListBean(ChildFavoriteListExport entity, List<FavoriteList> existingFavoriteLists) {
        ChildFavoriteListBean bean = new ChildFavoriteListBean();
        bean.setWeight(entity.getWeight());
        FavoriteList childEntity = existingFavoriteLists.stream().filter(favoriteList -> entity.getChild().equals(favoriteList.getName())).findFirst().orElse(null);
        FavoriteListBean childBean = this.toFavoriteListBean(childEntity);
        bean.setChild(childBean);
        return bean;
    }

    public ExportBean exportFavoriteLists() {
        PollenUser user = this.checkAndGetConnectedUser();
        FavoriteListsExport result = new FavoriteListsExport();
        List<FavoriteList> favoriteLists = this.getFavoriteLists0(user);
        result.setVersion("1.0.0");
        for (FavoriteList favoriteList : favoriteLists) {
            FavoriteListExport favoriteListExport = FavoriteListExport.fromEntity(favoriteList);
            List<ChildFavoriteList> children = this.getChildrenLists0(favoriteList);
            List<ChildFavoriteListExport> childrenExport = children.stream().map(ChildFavoriteListExport::fromEntity).collect(Collectors.toList());
            favoriteListExport.setChildren(childrenExport);
            List<FavoriteListMember> members = this.getFavoriteListMembers0(favoriteList);
            List<FavoriteListMemberExport> membersExport = members.stream().map(FavoriteListMemberExport::fromEntity).collect(Collectors.toList());
            favoriteListExport.setMembers(membersExport);
            result.getFavoriteLists().add(favoriteListExport);
        }
        ExportBean exportBean = new ExportBean();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        exportBean.setContent(gson.toJson((Object)result));
        exportBean.setName(I18n.l((Locale)this.getLocale(), (String)"pollen.export.favoriteLists", (Object[])new Object[]{user.getName(), this.getNow()}));
        exportBean.setContentType("application/json");
        return exportBean;
    }

    public PaginationResult<PollenBean> getAllChildren(String favoriteListId, String search, PaginationParameter page) {
        this.checkIsConnected();
        this.checkNotNull(favoriteListId);
        PaginationResult<ChildFavoriteListBean> resultChildList = this.getChildrenLists(favoriteListId, search, page);
        page = FavoriteListService.orderedPage(page, "name");
        PaginationResult<FavoriteListMemberBean> resultMember = page.getPageSize() == -1 ? this.getFavoriteListMembers(favoriteListId, search, page) : this.getFavoriteListMembers(favoriteListId, search, page, (int)resultChildList.getCount());
        LinkedList elements = Lists.newLinkedList((Iterable)resultChildList.getElements());
        elements.addAll(resultMember.getElements());
        long count = resultChildList.getCount() + resultMember.getCount();
        return PaginationResult.of((List)elements, (long)count, (PaginationParameter)page);
    }
}

