/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.services.PollenServiceSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class SecurityService
extends PollenServiceSupport {
    public static final Set<AccountIdRole> NONE_FREE_ACCOUNT_ID_ROLES = Sets.newHashSet((Object[])new AccountIdRole[]{AccountIdRole.RESTRICTED_VOTER, AccountIdRole.CREATOR});

    public boolean isPollCreator(Poll poll, String accountId, UserAccount pollenUserAccount) {
        PollAccount creator = poll.getCreator();
        boolean result = creator.getAccountId().equals(accountId);
        if (!result && pollenUserAccount != null) {
            result = pollenUserAccount.equals(creator.getUserAccount());
        }
        return result;
    }

    public boolean isCanClosePoll(Poll poll, AccountIdRole accountIdRole) {
        boolean result;
        boolean bl = result = !poll.isClosed();
        if (result) {
            result = accountIdRole == AccountIdRole.CREATOR;
        }
        return result;
    }

    public void removeAccountIdWhenConnected(PollUrl url, UserAccount userAccount) {
        if (userAccount != null) {
            url.getPollUri().setAccountId(null);
        }
    }

    public AccountIdRole getAccountIdRole(Poll poll, String accountId) {
        Preconditions.checkNotNull((Object)poll);
        AccountIdRole result = AccountIdRole.UNDEFINED;
        if (StringUtils.isNotBlank((CharSequence)accountId)) {
            if (accountId.equals(poll.getCreator().getAccountId())) {
                result = AccountIdRole.CREATOR;
            } else {
                PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
                PollUri pollUri = PollUri.newPollUri(poll.getPollId(), accountId);
                if (poll.getPollType() == PollType.FREE) {
                    boolean found = this.isVoterAccountId(dao, pollUri);
                    if (found) {
                        result = AccountIdRole.VOTER;
                    }
                } else {
                    boolean found = this.isRestrictPollAccountId(dao, pollUri);
                    if (found) {
                        result = AccountIdRole.RESTRICTED_VOTER;
                    }
                }
            }
        }
        return result;
    }

    public boolean isCanAccessResult(Poll poll, String accountId, AccountIdRole accountIdRole, UserAccount userAccount) {
        String errorMessage;
        if (this.isPollCreator(poll, accountId, userAccount)) {
            accountIdRole = AccountIdRole.CREATOR;
        }
        return (errorMessage = this.isCanAccessResult(poll, accountIdRole)) == null;
    }

    public String isCanAccessResult(Poll poll, AccountIdRole accountIdRole) {
        boolean pollIsFree;
        boolean publicResults = poll.isPublicResults();
        boolean continuousResults = poll.isContinuousResults();
        if (!continuousResults && !poll.isClosed()) {
            return I18n.n_((String)"pollen.security.error.poll.not.closed.and.results.not.continuous", (Object[])new Object[0]);
        }
        if (!publicResults && accountIdRole != AccountIdRole.CREATOR) {
            return I18n.n_((String)"pollen.security.error.poll.result.private.and.access.not.granted", (Object[])new Object[0]);
        }
        boolean bl = pollIsFree = PollType.FREE == poll.getPollType();
        if (publicResults && !pollIsFree && !NONE_FREE_ACCOUNT_ID_ROLES.contains((Object)accountIdRole)) {
            return I18n.n_((String)"pollen.security.error.poll.not.free.and.access.not.granted", (Object[])new Object[0]);
        }
        return null;
    }

    public String isCanAccessVote(Poll poll, String accountId, AccountIdRole accountIdRole) {
        boolean pollIsFree;
        if (AccountIdRole.CREATOR == accountIdRole) {
            return null;
        }
        boolean bl = pollIsFree = PollType.FREE == poll.getPollType();
        if (pollIsFree && poll.getCreator().getAccountId().equals(accountId)) {
            return I18n.n_((String)"pollen.security.error.poll.free.creatorId.can.not.vote", (Object[])new Object[0]);
        }
        if (!pollIsFree && AccountIdRole.RESTRICTED_VOTER != accountIdRole) {
            return I18n.n_((String)"pollen.security.error.poll.not.free.and.access.not.granted", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean isCanVote(Poll poll, String accountId, AccountIdRole accountIdRole) {
        boolean pollIsFree;
        Date now = this.serviceContext.getCurrentTime();
        if (!poll.isRunning(now)) {
            return false;
        }
        boolean bl = pollIsFree = PollType.FREE == poll.getPollType();
        if (pollIsFree && poll.getCreator().getAccountId().equals(accountId)) {
            return false;
        }
        return pollIsFree || AccountIdRole.RESTRICTED_VOTER == accountIdRole;
    }

    public boolean isCanModifyVote(Poll poll, String voteId, String accountId, UserAccount userConnected) {
        Date now = this.serviceContext.getCurrentTime();
        if (!poll.isRunning(now)) {
            return false;
        }
        if (poll.isAnonymous()) {
            return false;
        }
        Vote vote = poll.getVoteByTopiaId(voteId);
        if (vote == null) {
            return false;
        }
        PollAccount votePollAccount = vote.getPollAccount();
        if (votePollAccount.getAccountId().equals(accountId)) {
            return true;
        }
        return userConnected != null && userConnected.equals(votePollAccount.getUserAccount());
    }

    public boolean isCanDeleteVote(Poll poll, String voteId, String accountId, AccountIdRole accountIdRole, UserAccount userConnected) {
        Date now = this.serviceContext.getCurrentTime();
        if (!poll.isRunning(now)) {
            return false;
        }
        if (poll.isAnonymous()) {
            return false;
        }
        Vote vote = poll.getVoteByTopiaId(voteId);
        if (vote == null) {
            return false;
        }
        if (accountIdRole == AccountIdRole.CREATOR) {
            return true;
        }
        PollAccount votePollAccount = vote.getPollAccount();
        if (votePollAccount.getAccountId().equals(accountId)) {
            return true;
        }
        return userConnected != null && userConnected.equals(votePollAccount.getUserAccount());
    }

    public boolean isCanDeleteComment(Comment comment, String accountId, AccountIdRole accountIdRole, UserAccount userAccount) {
        if (accountIdRole == AccountIdRole.CREATOR) {
            return true;
        }
        PollAccount commentAccount = comment.getPollAccount();
        if (commentAccount.getAccountId().equals(accountId)) {
            return true;
        }
        return userAccount != null && userAccount.equals(commentAccount.getUserAccount());
    }

    private boolean isVoterAccountId(PollAccountDAO dao, PollUri uri) {
        try {
            return dao.existsByPollVoteAccountId(uri.getPollId(), uri.getAccountId());
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not check pollAccount existence from poll '" + uri.getPollId() + "' and account '" + uri.getAccountId() + "'", (Throwable)e);
        }
    }

    private boolean isRestrictPollAccountId(PollAccountDAO dao, PollUri uri) {
        try {
            PollAccount result = dao.getRestrictedPollAccount(uri.getPollId(), uri.getAccountId());
            return result != null;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not check pollAccount existence from poll '" + uri.getPollId() + "' and account '" + uri.getAccountId() + "'", (Throwable)e);
        }
    }

    public static enum AccountIdRole {
        CREATOR,
        VOTER,
        RESTRICTED_VOTER,
        UNDEFINED;

    }
}

