/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.impl.PollUrlService;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class EmailService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(EmailService.class);

    public void onUserCreated(UserAccount user) {
        if (this.serviceContext.isCanSendEmail() && StringUtil.isEmail((String)user.getEmail())) {
            Locale locale = this.getLocale();
            String subject = I18n.l_((Locale)locale, (String)"pollen.email.userRegister.subject", (Object[])new Object[]{user.getLogin()});
            String content = I18n.l_((Locale)locale, (String)"pollen.email.userRegister.content", (Object[])new Object[]{user.getDisplayName(), user.getLogin(), user.getPassword(), this.serviceContext.getApplicationURL()});
            PollenEmail pollenEmail = EmailService.createPollenEmail(user.getEmail(), subject, content);
            this.sendEmail(pollenEmail);
        }
    }

    public void onLostPassword(UserAccount user, String newPassword) {
        if (this.serviceContext.isCanSendEmail()) {
            Locale locale = this.getLocale();
            String subject = I18n.l_((Locale)locale, (String)"pollen.email.lostPassword.subject", (Object[])new Object[]{user.getLogin()});
            String content = I18n.l_((Locale)locale, (String)"pollen.email.lostPassword.content", (Object[])new Object[]{user.getDisplayName(), user.getLogin(), newPassword, this.serviceContext.getApplicationURL()});
            PollenEmail pollenEmail = EmailService.createPollenEmail(user.getEmail(), subject, content);
            this.sendEmail(pollenEmail);
        }
    }

    public void onVoteAdded(Poll poll) {
        if (this.serviceContext.isCanSendEmail()) {
            Locale locale = this.getLocale();
            String pollTitle = poll.getTitle();
            PollUrlService urlService = this.newService(PollUrlService.class);
            PollUrl summaryUrl = urlService.getPollSummaryUrl(poll);
            if (StringUtils.isNotEmpty((CharSequence)poll.getCreator().getEmail())) {
                int nbVotes = poll.sizeVote();
                String subject = I18n.l_((Locale)locale, (String)"pollen.email.voteEmail.subject", (Object[])new Object[]{pollTitle});
                String content = I18n.l_((Locale)locale, (String)"pollen.email.voteEmail.content", (Object[])new Object[]{pollTitle, nbVotes, summaryUrl});
                PollenEmail pollenEmail = EmailService.createPollenEmail(poll.getCreator().getEmail(), subject, content);
                this.sendEmail(pollenEmail);
            }
        }
    }

    public void onPollCreated(Poll poll) {
        if (this.serviceContext.isCanSendEmail()) {
            List votingPollAccounts;
            Locale locale = this.getLocale();
            String pollTitle = poll.getTitle();
            PollUrlService urlService = this.newService(PollUrlService.class);
            PollUrl summaryUrl = urlService.getPollSummaryUrl(poll);
            PollUrl voteUrl = urlService.getPollVoteUrl(poll);
            if (StringUtils.isNotEmpty((CharSequence)poll.getCreator().getEmail())) {
                String content;
                String subject;
                if (PollType.FREE == poll.getPollType()) {
                    subject = I18n.l_((Locale)locale, (String)"pollen.email.createPoll.subject", (Object[])new Object[]{pollTitle});
                    content = I18n.l_((Locale)locale, (String)"pollen.email.createPoll.content", (Object[])new Object[]{pollTitle, poll.getPollId(), summaryUrl});
                } else {
                    subject = I18n.l_((Locale)locale, (String)"pollen.email.createRestrictedPoll.subject", (Object[])new Object[]{pollTitle});
                    content = I18n.l_((Locale)locale, (String)"pollen.email.createRestrictedPoll.content", (Object[])new Object[]{pollTitle, summaryUrl});
                }
                PollenEmail pollenEmail = EmailService.createPollenEmail(poll.getCreator().getEmail(), subject, content);
                this.sendEmail(pollenEmail);
            }
            if (CollectionUtils.isNotEmpty((Collection)(votingPollAccounts = poll.getPollAccounts(false)))) {
                ArrayList emails = Lists.newArrayList();
                for (PollAccount account : votingPollAccounts) {
                    PollenEmail pollenEmail = this.createVotingEmail(locale, pollTitle, account, voteUrl);
                    emails.add(pollenEmail);
                }
                this.sendEmail(emails);
            }
        }
    }

    public void onRestrictedPersonAdded(Poll poll, PollAccount account) {
        if (this.serviceContext.isCanSendEmail()) {
            Locale locale = this.getLocale();
            String pollTitle = poll.getTitle();
            PollUrlService urlService = this.newService(PollUrlService.class);
            PollUrl voteURL = urlService.getPollVoteUrl(poll);
            PollenEmail pollenEmail = this.createVotingEmail(locale, pollTitle, account, voteURL);
            this.sendEmail(pollenEmail);
        }
    }

    public void onPollReminder(Poll poll) {
        if (this.serviceContext.isCanSendEmail()) {
            Locale locale = this.getLocale();
            String pollTitle = poll.getTitle();
            PollUrl voteURL = this.newService(PollUrlService.class).getPollVoteUrl(poll);
            List votingPollAccounts = poll.getPollAccounts(true);
            if (CollectionUtils.isNotEmpty((Collection)votingPollAccounts)) {
                String subject = I18n.l_((Locale)locale, (String)"pollen.email.reminderEmail.subject", (Object[])new Object[]{pollTitle});
                ArrayList emails = Lists.newArrayList();
                for (PollAccount account : votingPollAccounts) {
                    PollUrl accountVoteURL = PollUrl.newPollUrl(voteURL, account.getAccountId());
                    String content = I18n.l_((Locale)locale, (String)"pollen.email.reminderEmail.content", (Object[])new Object[]{pollTitle, account.getVotingId(), accountVoteURL});
                    PollenEmail pollenEmail = EmailService.createPollenEmail(account.getEmail(), subject, content);
                    emails.add(pollenEmail);
                }
                this.sendEmail(emails);
            }
        }
    }

    private PollenEmail createVotingEmail(Locale locale, String pollTitle, PollAccount account, PollUrl voteURL) {
        String subject = I18n.l_((Locale)locale, (String)"pollen.email.votingEmail.subject", (Object[])new Object[]{pollTitle});
        PollUrl accountVoteURL = PollUrl.newPollUrl(voteURL, account.getAccountId());
        String content = I18n.l_((Locale)locale, (String)"pollen.email.votingEmail.content", (Object[])new Object[]{pollTitle, account.getVotingId(), accountVoteURL});
        PollenEmail result = EmailService.createPollenEmail(account.getEmail(), subject, content);
        return result;
    }

    protected void sendEmail(Iterable<PollenEmail> pollEmails) {
        for (PollenEmail pollenEmail : pollEmails) {
            this.sendEmail(pollenEmail);
        }
    }

    protected void sendEmail(PollenEmail pollenEmail) {
        Preconditions.checkNotNull((Object)pollenEmail);
        String to = pollenEmail.getTo();
        Preconditions.checkNotNull((Object)to);
        String subject = pollenEmail.getSubject();
        Preconditions.checkNotNull((Object)subject);
        String content = pollenEmail.getContent();
        Preconditions.checkNotNull((Object)content);
        try {
            SimpleEmail email = new SimpleEmail();
            PollenConfiguration configuration = this.getConfiguration();
            email.setHostName(configuration.getEmailHost());
            email.setSmtpPort(configuration.getEmailPort());
            email.setFrom(configuration.getEmailFrom());
            email.setCharset(configuration.getCharset());
            email.addTo(to);
            email.setSubject(subject);
            email.setMsg(content);
            email.send();
            if (log.isInfoEnabled()) {
                log.info((Object)("Mail sent to : " + to));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Email infos : \ndate: " + email.getSentDate() + "\nhostname: " + email.getHostName() + "\nport: " + email.getSmtpPort() + "\nfrom: " + email.getFromAddress().toString()));
            }
        }
        catch (EmailException eee) {
            throw new PollenTechnicalException("could not send email to " + to, (Throwable)eee);
        }
    }

    public static PollenEmail createPollenEmail(String to, String subject, String content) {
        return new PollenEmail(to, subject, content);
    }

    public static class PollenEmail {
        protected String subject;
        protected String content;
        protected String to;

        private PollenEmail(String to, String subject, String content) {
            this.subject = subject;
            this.content = content;
            this.to = to;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getContent() {
            return this.content;
        }

        public String getTo() {
            return this.to;
        }
    }
}

