--
-- Corrige la base de production
--

CREATE OR REPLACE FUNCTION rename_column_if_exists(
    table_name TEXT,
    old_column_name TEXT,
    new_column_name TEXT
)
RETURNS VOID AS $$
DECLARE
    column_exists BOOLEAN;
BEGIN
    -- Verify whether the column is present in the table
    EXECUTE format('SELECT EXISTS (
        SELECT 1
        FROM information_schema.columns
        WHERE table_name = %L
        AND column_name = %L
    )', table_name, old_column_name)
    INTO column_exists;

    -- If the column exists, rename it
    IF column_exists THEN
        EXECUTE format('ALTER TABLE %I RENAME COLUMN %I TO %I', table_name, old_column_name, new_column_name);
    END IF;
END;
$$ LANGUAGE plpgsql;

ALTER TABLE IF EXISTS public."childFavoriteList" RENAME TO "child_favorite_list";
SELECT rename_column_if_exists('child_favorite_list', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('child_favorite_list', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('child_favorite_list', 'topiaCreateDate', 'topia_create_date');

SELECT rename_column_if_exists('choice', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('choice', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('choice', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('choice', 'choiceValue', 'choice_value');
SELECT rename_column_if_exists('choice', 'choiceOrder', 'choice_order');
SELECT rename_column_if_exists('choice', 'choiceType', 'choice_type');

SELECT rename_column_if_exists('comment', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('comment', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('comment', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('comment', 'postDate', 'post_date');

ALTER TABLE IF EXISTS public."emailToResend" RENAME TO "email_to_resend";
SELECT rename_column_if_exists('email_to_resend', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('email_to_resend', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('email_to_resend', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('email_to_resend', 'adrFrom', 'adr_from');
SELECT rename_column_if_exists('email_to_resend', 'replyTo', 'reply_to');

ALTER TABLE IF EXISTS public."favoriteList" RENAME TO "favorite_list";
SELECT rename_column_if_exists('favorite_list', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('favorite_list', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('favorite_list', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('favorite_list', 'pollenUser', 'pollen_user');
SELECT rename_column_if_exists('favorite_list', 'parentLists', 'parent_lists');

ALTER TABLE IF EXISTS public."favoriteListMember" RENAME TO "favorite_list_member";
SELECT rename_column_if_exists('favorite_list_member', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('favorite_list_member', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('favorite_list_member', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('favorite_list_member', 'favoriteList', 'favorite_list');

ALTER TABLE IF EXISTS public."loginProvider" RENAME TO "login_provider";
SELECT rename_column_if_exists('login_provider', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('login_provider', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('login_provider', 'topiaCreateDate', 'topia_create_date');

SELECT rename_column_if_exists('poll', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('poll', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('poll', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('poll', 'beginDate', 'begin_date');
SELECT rename_column_if_exists('poll', 'endDate', 'end_date');
SELECT rename_column_if_exists('poll', 'anonymousVoteAllowed', 'anonymous_vote_allowed');
SELECT rename_column_if_exists('poll', 'continuousResults', 'continuous_results');
SELECT rename_column_if_exists('poll', 'notifyMeHoursBeforePollEnds', 'notify_me_hours_before_poll_ends');
SELECT rename_column_if_exists('poll', 'pollEndReminderSent', 'poll_end_reminder_sent');
SELECT rename_column_if_exists('poll', 'notificationLocale', 'notification_locale');
SELECT rename_column_if_exists('poll', 'voteNotification', 'vote_notification');
SELECT rename_column_if_exists('poll', 'feedContent', 'feed_content');
SELECT rename_column_if_exists('poll', 'commentNotification', 'comment_notification');
SELECT rename_column_if_exists('poll', 'newChoiceNotification', 'new_choice_notification');
SELECT rename_column_if_exists('poll', 'gtuValidationDate', 'gtu_validation_date');
SELECT rename_column_if_exists('poll', 'notificationMaxVoterSend', 'notification_max_voter_send');
SELECT rename_column_if_exists('poll', 'emailAddressSuffixes', 'email_address_suffixes');
SELECT rename_column_if_exists('poll', 'pollType', 'poll_type');
SELECT rename_column_if_exists('poll', 'voteVisibility', 'vote_visibility');
SELECT rename_column_if_exists('poll', 'commentVisibility', 'comment_visibility');
SELECT rename_column_if_exists('poll', 'resultVisibility', 'result_visibility');
SELECT rename_column_if_exists('poll', 'builtinPicture', 'builtin_picture');
SELECT rename_column_if_exists('poll', 'resultPresentation', 'result_presentation');

ALTER TABLE IF EXISTS public."pollenPrincipal" RENAME TO "pollen_principal";
SELECT rename_column_if_exists('pollen_principal', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('pollen_principal', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('pollen_principal', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('pollen_principal', 'pollenUser', 'pollen_user');

ALTER TABLE IF EXISTS public."pollenResource" RENAME TO "pollen_resource";
SELECT rename_column_if_exists('pollen_resource', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('pollen_resource', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('pollen_resource', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('pollen_resource', 'resourceContent', 'resource_content');
SELECT rename_column_if_exists('pollen_resource', 'contentType', 'content_type');
SELECT rename_column_if_exists('pollen_resource', 'resourceType', 'resource_type');

ALTER TABLE IF EXISTS public."pollenToken" RENAME TO "pollen_token";
SELECT rename_column_if_exists('pollen_token', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('pollen_token', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('pollen_token', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('pollen_token', 'creationDate', 'creation_date');
SELECT rename_column_if_exists('pollen_token', 'endDate', 'end_date');

ALTER TABLE IF EXISTS public."pollenUser" RENAME TO "pollen_user";
SELECT rename_column_if_exists('pollen_user', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('pollen_user', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('pollen_user', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('pollen_user', 'gtuValidationDate', 'gtu_validation_date');
SELECT rename_column_if_exists('pollen_user', 'premiumTo', 'premium_to');
SELECT rename_column_if_exists('pollen_user', 'canCreatePoll', 'can_create_poll');
SELECT rename_column_if_exists('pollen_user', 'defaultEmailAddress', 'default_email_address');

ALTER TABLE IF EXISTS public."pollenUserEmailAddress" RENAME TO "pollen_user_email_address";
SELECT rename_column_if_exists('pollen_user_email_address', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('pollen_user_email_address', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('pollen_user_email_address', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('pollen_user_email_address', 'emailAddress', 'email_address');
SELECT rename_column_if_exists('pollen_user_email_address', 'pgpPublicKey', 'pgp_public_key');
SELECT rename_column_if_exists('pollen_user_email_address', 'pollenUser', 'pollen_user');

SELECT rename_column_if_exists('question', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('question', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('question', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('question', 'beginChoiceDate', 'begin_choice_date');
SELECT rename_column_if_exists('question', 'endChoiceDate', 'end_choice_date');
SELECT rename_column_if_exists('question', 'choiceAddAllowed', 'choice_add_allowed');
SELECT rename_column_if_exists('question', 'voteCountingType', 'vote_counting_type');
SELECT rename_column_if_exists('question', 'voteCountingConfig', 'vote_counting_config');
SELECT rename_column_if_exists('question', 'questionOrder', 'question_order');

SELECT rename_column_if_exists('report', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('report', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('report', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('report', 'targetId', 'target_id');

ALTER TABLE IF EXISTS public."sessionToken" RENAME TO "session_token";
SELECT rename_column_if_exists('session_token', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('session_token', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('session_token', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('session_token', 'pollenUser', 'pollen_user');
SELECT rename_column_if_exists('session_token', 'pollenToken', 'pollen_token');

ALTER TABLE IF EXISTS public."userCredential" RENAME TO "user_credential";
SELECT rename_column_if_exists('user_credential', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('user_credential', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('user_credential', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('user_credential', 'userId', 'user_id');
SELECT rename_column_if_exists('user_credential', 'userName', 'user_name');
SELECT rename_column_if_exists('user_credential', 'pollenUser', 'pollen_user');

SELECT rename_column_if_exists('vote', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('vote', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('vote', 'topiaCreateDate', 'topia_create_date');

ALTER TABLE IF EXISTS public."voteToChoice" RENAME TO "vote_to_choice";
SELECT rename_column_if_exists('vote_to_choice', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('vote_to_choice', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('vote_to_choice', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('vote_to_choice', 'voteValue', 'vote_value');

SELECT rename_column_if_exists('voter', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('voter', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('voter', 'topiaCreateDate', 'topia_create_date');

ALTER TABLE IF EXISTS public."voterList" RENAME TO "voter_list";
SELECT rename_column_if_exists('voter_list', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('voter_list', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('voter_list', 'topiaCreateDate', 'topia_create_date');

ALTER TABLE IF EXISTS public."voterListMember" RENAME TO "voter_list_member";
SELECT rename_column_if_exists('voter_list_member', 'topiaId', 'topia_id');
SELECT rename_column_if_exists('voter_list_member', 'topiaVersion', 'topia_version');
SELECT rename_column_if_exists('voter_list_member', 'topiaCreateDate', 'topia_create_date');
SELECT rename_column_if_exists('voter_list_member', 'invitationSent', 'invitation_sent');
SELECT rename_column_if_exists('voter_list_member', 'voterList', 'voter_list');

DROP FUNCTION rename_column_if_exists;