/*
 * #%L
 * Pollen :: Persistence
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

/**
 * Some utils IO methods.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenIOUtil {

    /** Logger. */
    private static final Log log = LogFactory.getLog(PollenIOUtil.class);

    protected PollenIOUtil() {
    }

    public static File getTestSpecificDirectory(Class<?> klass,
                                                String methodName,
                                                long timestamp) {
        // Trying to look for the temporary folder to store data for the test
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            // can this really occur ?
            tempDirPath = "";
            if (log.isWarnEnabled()) {
                log.warn("'\"java.io.tmpdir\" not defined");
            }
        }
        File tempDirFile = new File(tempDirPath);

        // create the directory to store database data
        String dataBasePath = klass.getName()
                              + File.separator // a directory with the test class name
                              + methodName // a sub-directory with the method name
                              + '_'
                              + timestamp; // and a timestamp
        File databaseFile = new File(tempDirFile, dataBasePath);
        return databaseFile;
    }

}
