/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataResultConverter;
import org.chorem.pollen.business.converters.DataVoteCountingConverter;
import org.chorem.pollen.business.converters.EnumController;
import org.chorem.pollen.business.dto.ResultDTO;
import org.chorem.pollen.business.dto.ResultListDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.services.ServicePollImpl;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.business.utils.ContextUtil;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.PollExportDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.services.ServiceExportImpl;
import org.chorem.pollen.votecounting.services.ServiceVoteCountingImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceResultsImpl
implements ServiceResults {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private static final Log log = LogFactory.getLog(ServiceResultsImpl.class);

    @Override
    public ResultListDTO getAllResults(String pollId) {
        return this.getResults(pollId, null, false, false);
    }

    @Override
    public ResultListDTO getResultsByVoteCounting(String pollId, VoteCountingType voteCounting) {
        return this.getResults(pollId, voteCounting, false, false);
    }

    @Override
    public ResultListDTO getGroupResults(String pollId) {
        return this.getResults(pollId, null, true, true);
    }

    @Override
    public ResultListDTO getNormalResults(String pollId) {
        return this.getResults(pollId, null, true, false);
    }

    private ResultListDTO getResults(String pollId, VoteCountingType voteCounting, boolean byGroup, boolean groupOnly) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            PollDAO daoPoll = PollenModelDAOHelper.getPollDAO(transaction);
            Object ePoll = daoPoll.findByPollId(pollId);
            DataResultConverter converter = new DataResultConverter(transaction);
            if (log.isDebugEnabled()) {
                log.debug((Object)(ePoll.getPollId() + " (" + voteCounting + ") has results: " + this.hasResults((Poll)ePoll, voteCounting)));
            }
            PollDTO dto = DataVoteCountingConverter.createPollDTOForVoteCounting(ePoll);
            if (voteCounting != null) {
                dto.setVoteCounting(voteCounting);
            }
            ePoll.clearResult();
            ServiceVoteCountingImpl service = new ServiceVoteCountingImpl();
            VoteCountingResultDTO result = service.executeVoteCounting(dto);
            converter.populateResultEntities(result);
            if (EnumController.isGroupType(ePoll)) {
                result = service.executeGroupCounting(dto);
                converter.populateResultEntities(result);
            }
            transaction.commitTransaction();
            List<ResultDTO> list = converter.createResultDTOs((Poll)ePoll);
            transaction.closeContext();
            VoteCountingType voteCountingType = EnumController.getVoteCountingType(ePoll);
            Iterator<ResultDTO> it = list.iterator();
            while (it.hasNext()) {
                ResultDTO curr = it.next();
                if (voteCounting != null && curr.getVoteCounting() != voteCounting) {
                    it.remove();
                }
                if (!byGroup) continue;
                if (groupOnly && !curr.isByGroup()) {
                    it.remove();
                } else if (!groupOnly && curr.isByGroup()) {
                    it.remove();
                }
                if (curr.getVoteCounting() == voteCountingType) continue;
                it.remove();
            }
            ResultListDTO resultListDTO = new ResultListDTO();
            resultListDTO.setResultDTOs(list);
            resultListDTO.setVoteCountingResultDTO(result);
            return resultListDTO;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    private boolean hasResults(Poll ePoll, VoteCountingType type) {
        List<Result> results = ePoll.getResult();
        if (results == null || results.isEmpty()) {
            return false;
        }
        if (!results.isEmpty() && type == null) {
            return true;
        }
        for (Result curr : results) {
            if (EnumController.getVoteCountingType(curr) != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public String exportPoll(String pollId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            PollDAO daoPoll = PollenModelDAOHelper.getPollDAO(transaction);
            Object ePoll = daoPoll.findByPollId(pollId);
            DataResultConverter converter = new DataResultConverter(transaction);
            PollDTO dto = DataVoteCountingConverter.createPollDTOForVoteCounting(ePoll);
            ePoll.clearResult();
            ServiceVoteCountingImpl service = new ServiceVoteCountingImpl();
            ArrayList<VoteCountingResultDTO> results = new ArrayList<VoteCountingResultDTO>();
            VoteCountingResultDTO result = service.executeVoteCounting(dto);
            converter.populateResultEntities(result);
            results.add(result);
            if (EnumController.isGroupType(ePoll)) {
                VoteCountingResultDTO groupResult = service.executeGroupCounting(dto);
                converter.populateResultEntities(groupResult);
                results.add(groupResult);
            }
            transaction.commitTransaction();
            transaction.closeContext();
            PollExportDTO pollExport = new PollExportDTO();
            pollExport.setPollId(pollId);
            pollExport.setPoll(dto);
            pollExport.setVoteCountingResults(results);
            ServiceExportImpl serviceExport = new ServiceExportImpl();
            String filename = serviceExport.executeExport(pollExport);
            if (log.isInfoEnabled()) {
                log.info((Object)("Poll exported: " + pollId));
            }
            return filename;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public String importPoll(String filePath) {
        return this.importPoll(filePath, null);
    }

    @Override
    public String importPoll(String filePath, UserDTO user) {
        String topiaId = "";
        ServiceExportImpl serviceExport = new ServiceExportImpl();
        PollExportDTO pollExportDTO = serviceExport.executeImport(filePath);
        ServicePollImpl servicePoll = new ServicePollImpl();
        org.chorem.pollen.business.dto.PollDTO poll = DataVoteCountingConverter.createPollDTO(pollExportDTO.getPoll());
        if (user != null) {
            poll.setUserId(user.getId());
        }
        topiaId = servicePoll.createPoll(poll);
        if (log.isInfoEnabled()) {
            log.info((Object)("Poll imported: " + topiaId));
        }
        return topiaId;
    }
}

