/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.web.action;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaTechnicalException;
import org.chorem.lima.beans.DocumentReport;
import org.chorem.lima.business.LimaServiceConfig;
import org.chorem.lima.business.utils.DocumentsEnum;

public class ReportBuilder {
    private static final Log log = LogFactory.getLog(ReportBuilder.class);
    protected JasperReport balanceDocumentReport;
    protected JasperReport generalEntryBookDocumentReport;
    protected JasperReport entryBookDocumentReport;
    protected JasperReport generalLedgerDocumentReport;
    protected Map<DocumentsEnum, JasperReport> reportsByDocumentType;

    public ReportBuilder() {
        try {
            LimaServiceConfig config = LimaServiceConfig.getInstance();
            this.balanceDocumentReport = JasperCompileManager.compileReport((String)config.getBalanceDocumentReportModelPath());
            this.generalEntryBookDocumentReport = JasperCompileManager.compileReport((String)config.getGeneralEntryBookDocumentReportModelPath());
            this.entryBookDocumentReport = JasperCompileManager.compileReport((String)config.getEntryBookDocumentReportModelPath());
            this.generalLedgerDocumentReport = JasperCompileManager.compileReport((String)config.getGeneralLedgerDocumentReportModelPath());
            this.reportsByDocumentType = Maps.newHashMap();
            this.reportsByDocumentType.put(DocumentsEnum.BALANCE, this.balanceDocumentReport);
            this.reportsByDocumentType.put(DocumentsEnum.GENERAL_ENTRYBOOK, this.generalEntryBookDocumentReport);
            this.reportsByDocumentType.put(DocumentsEnum.ENTRYBOOKS, this.entryBookDocumentReport);
            this.reportsByDocumentType.put(DocumentsEnum.LEDGER, this.generalLedgerDocumentReport);
        }
        catch (JRException e) {
            throw new LimaTechnicalException((Throwable)e);
        }
    }

    public void generatePDFReport(DocumentsEnum reportType, String path, List<DocumentReport> reports) {
        block4: {
            try {
                JasperReport report = this.reportsByDocumentType.get(reportType);
                if (report != null) {
                    JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, new HashMap(), (JRDataSource)new JRBeanCollectionDataSource(reports));
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)path);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Rapport g\u00e9n\u00e9r\u00e9:" + path));
                    }
                    break block4;
                }
                throw new LimaTechnicalException("JasperReport not found for " + reportType);
            }
            catch (JRException e) {
                throw new LimaTechnicalException((Throwable)e);
            }
        }
    }
}

