/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import com.google.common.collect.Maps;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.exceptions.AfterLastFiscalPeriodException;
import org.chorem.lima.business.exceptions.BeforeFirstFiscalPeriodException;
import org.chorem.lima.business.exceptions.LockedEntryBookException;
import org.chorem.lima.business.exceptions.LockedFinancialPeriodException;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FinancialTransactionImpl;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTable;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionView;
import org.chorem.lima.util.BigDecimalToString;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class FinancialTransactionViewHandler
implements ServiceListener,
TableModelListener,
TableColumnModelListener {
    private static final Log log = LogFactory.getLog(FinancialTransactionViewHandler.class);
    protected FinancialTransactionView view;
    protected Object clipBoard;
    protected EntryBookService entryBookService;
    protected FinancialPeriodService financialPeriodService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialTransactionService financialTransactionService;
    protected Date lastAssignDate;
    protected ErrorHelper errorHelper;

    public FinancialTransactionViewHandler(FinancialTransactionView view) {
        this.view = view;
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        LimaServiceFactory.addServiceListener(FinancialPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
        this.initShortCuts();
    }

    public void init() {
        List fiscalPeriods = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
        this.view.getFiscalPeriodComboBoxModel().setObjects(fiscalPeriods);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d fiscal periods", fiscalPeriods.size()));
        }
        if (!fiscalPeriods.isEmpty()) {
            this.view.getFiscalPeriodComboBoxModel().setSelectedItem(fiscalPeriods.get(0));
        }
        List allEntryBooks = this.entryBookService.getAllEntryBooks();
        this.view.getEntryBookComboBoxModel().setObjects(allEntryBooks);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d entry books", allEntryBooks.size()));
        }
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        tableModel.addTableModelListener(this);
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        table.getColumnModel().addColumnModelListener(this);
        SwingUtil.fixTableColumnWidth((JTable)((Object)table), (int)0, (int)40);
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean mustRecompute;
                boolean bl = mustRecompute = e.getType() == -1 || e.getType() == 1 || e.getType() == 0 && (e.getColumn() == -1 || e.getColumn() == 4 || e.getColumn() == 5);
                if (mustRecompute) {
                    FinancialTransactionViewHandler.this.computeStatusText();
                }
            }
        });
    }

    protected void initShortCuts() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "new-transaction";
        inputMap.put(KeyStroke.getKeyStroke(78, 192), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -1664378625712266838L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.addFinancialTransaction();
            }
        });
        binding = "delete-transaction";
        inputMap.put(KeyStroke.getKeyStroke(127, 192), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 7621389371928432410L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.deleteSelectedTransaction();
            }
        });
        binding = "copy-transaction";
        inputMap.put(KeyStroke.getKeyStroke(67, 192), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -982724612254422140L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.copyTransaction();
            }
        });
        binding = "paste-transaction";
        inputMap.put(KeyStroke.getKeyStroke(86, 192), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 3981745985282030673L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.pasteTransaction();
            }
        });
        binding = "new-entry";
        inputMap.put(KeyStroke.getKeyStroke(78, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 6099897253355058899L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.addEntry();
            }
        });
        binding = "delete-entry";
        inputMap.put(KeyStroke.getKeyStroke(127, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 5137178343047269716L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.deleteSelectedEntry();
            }
        });
        binding = "copy-entry";
        inputMap.put(KeyStroke.getKeyStroke(67, 640), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -1866038141590067940L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.copyEntry();
            }
        });
        binding = "paste-entry";
        inputMap.put(KeyStroke.getKeyStroke(86, 640), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -3996645480884548643L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.pasteEntry();
            }
        });
        binding = "balance";
        inputMap.put(KeyStroke.getKeyStroke(66, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 5070872946843797639L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.balanceTransaction();
            }
        });
        binding = "assign-all";
        inputMap.put(KeyStroke.getKeyStroke(65, 640), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 4993025324310374283L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionViewHandler.this.assignAllEntries();
            }
        });
    }

    public void fiscalPeriodSelected(ItemEvent event) {
        if (event.getStateChange() == 1) {
            FiscalPeriod selectedFiscalPeriod = (FiscalPeriod)event.getItem();
            List financialPeriods = this.financialPeriodService.getFinancialPeriods(selectedFiscalPeriod.getBeginDate(), selectedFiscalPeriod.getEndDate());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Loaded %d financial periods", financialPeriods.size()));
            }
            this.view.getFinancialPeriodComboBoxModel().setObjects(financialPeriods);
            this.view.getFinancialPeriodComboBoxModel().setSelectedItem(financialPeriods.get(0));
            this.updateFinancialTransactions();
        }
    }

    public void financialPeriodSelected(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.updateFinancialTransactions();
        }
    }

    public void entryBookSelected(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.updateFinancialTransactions();
        }
    }

    public void updateFinancialTransactions() {
        FinancialPeriod financialPeriod = (FinancialPeriod)this.view.getFinancialPeriodComboBox().getSelectedItem();
        EntryBook entryBook = (EntryBook)this.view.getEntryBookComboBox().getSelectedItem();
        if (financialPeriod == null) {
            return;
        }
        List transactions = entryBook == null ? this.financialTransactionService.getAllFinancialTransactions(financialPeriod) : this.financialTransactionService.getAllFinancialTransactions(financialPeriod, entryBook);
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        table.exit();
        tableModel.setTransactions(transactions);
    }

    public void selectionChanged() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        int selectedRow = table.getSelectedRow();
        this.view.setSelectedRow(selectedRow >= 0 && selectedRow < tableModel.size());
        if (selectedRow >= 0 && selectedRow < tableModel.size()) {
            BigDecimal debit;
            FinancialTransaction transaction = tableModel.getTransactionAt(selectedRow);
            BigDecimal credit = transaction.getAmountCredit();
            this.view.setBalance(credit.compareTo(debit = transaction.getAmountDebit()) == 0);
        } else {
            this.view.setBalance(true);
        }
    }

    public void balanceTransaction() {
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        int rowSelected = table.getSelectedRow();
        if (rowSelected != -1) {
            if (table.isEditing()) {
                TableCellEditor editor = table.getCellEditor();
                editor.stopCellEditing();
            }
            Entry entry = (Entry)tableModel.get(rowSelected);
            FinancialTransaction transaction = entry.getFinancialTransaction();
            BigDecimal credit = transaction.getAmountCredit();
            BigDecimal debit = transaction.getAmountDebit();
            if (entry.isDebit()) {
                debit = debit.subtract(entry.getAmount());
            } else {
                credit = credit.subtract(entry.getAmount());
            }
            BigDecimal balance = credit.subtract(debit);
            BigDecimal previousAmount = entry.getAmount();
            boolean previousDebit = entry.isDebit();
            entry.setAmount(balance.abs());
            entry.setDebit(balance.signum() > 0);
            if (tableModel.updateEntry(entry)) {
                int firstRow = tableModel.indexOf(transaction);
                int lastRow = firstRow + transaction.sizeEntry() - 1;
                tableModel.fireTableRowsUpdated(firstRow, lastRow);
                this.view.setBalance(true);
            } else {
                entry.setAmount(previousAmount);
                entry.setDebit(previousDebit);
            }
        }
    }

    public void copyTransaction() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            this.clipBoard = this.view.getFinancialTransactionTableModel().getTransactionAt(indexSelectedRow);
            this.view.setTransactionInClipBoard(true);
            this.view.setEntryInClipBoard(false);
        }
    }

    public void copyEntry() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            this.clipBoard = this.view.getFinancialTransactionTableModel().get(indexSelectedRow);
            this.view.setTransactionInClipBoard(false);
            this.view.setEntryInClipBoard(true);
        }
    }

    public void pasteTransaction() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (this.clipBoard != null && this.clipBoard instanceof FinancialTransaction) {
            try {
                FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
                FinancialTransaction transaction = (FinancialTransaction)this.clipBoard;
                EntryBook entryBook = (EntryBook)this.view.getEntryBookComboBox().getSelectedItem();
                transaction.setEntryBook(entryBook);
                transaction.setTransactionDate(this.getUseDate());
                tableModel.addTransaction(transaction);
                if (table.isEditing()) {
                    TableCellEditor editor = table.getCellEditor();
                    editor.stopCellEditing();
                }
                int index = tableModel.indexOf(transaction);
                selectionModel.setSelectionInterval(index, index);
                table.changeSelection(index, 1, false, false);
                table.editCellAt(index, 1);
                table.scrollRowToVisible(Math.max(0, index - 5));
                table.scrollRowToVisible(Math.min(tableModel.size() - 1, index + transaction.sizeEntry() + 5));
            }
            catch (LockedFinancialPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.transaction.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
            }
            catch (AfterLastFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.transaction.error.afterLastFiscalPeriod", (Object[])new Object[]{e.getDate()}));
            }
            catch (BeforeFirstFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.transaction.error.beforeFirstFiscalPeriod", (Object[])new Object[]{e.getDate()}));
            }
            catch (LockedEntryBookException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.transaction.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
            }
        }
    }

    public void pasteEntry() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1 && this.clipBoard != null && this.clipBoard instanceof Entry) {
            try {
                Entry entryTmp = (Entry)this.clipBoard;
                FinancialTransaction transaction = tableModel.getTransactionAt(indexSelectedRow);
                EntryImpl entry = new EntryImpl();
                entry.setFinancialTransaction(transaction);
                entry.setVoucher(entryTmp.getVoucher());
                entry.setAccount(entryTmp.getAccount());
                entry.setDescription(entryTmp.getDescription());
                entry.setAmount(entryTmp.getAmount());
                entry.setDebit(entryTmp.isDebit());
                if (table.isEditing()) {
                    TableCellEditor editor = table.getCellEditor();
                    editor.stopCellEditing();
                }
                tableModel.addEntry((Entry)entry);
                int index = tableModel.indexOf(transaction) + transaction.sizeEntry() - 1;
                selectionModel.setSelectionInterval(index, index);
                table.changeSelection(index, 1, false, false);
                table.editCellAt(index, 1);
            }
            catch (LockedFinancialPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.entry.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
            }
            catch (AfterLastFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.entry.error.afterLastFiscalPeriod", (Object[])new Object[]{e.getDate()}));
            }
            catch (BeforeFirstFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.entry.error.beforeFirstFiscalPeriod", (Object[])new Object[]{e.getDate()}));
            }
            catch (LockedEntryBookException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.paste.entry.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
            }
        }
    }

    public void addFinancialTransaction() {
        try {
            EntryBook entryBook = (EntryBook)this.view.getEntryBookComboBox().getSelectedItem();
            FinancialTransactionTable table = this.view.getFinancialTransactionTable();
            FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
            FinancialTransactionImpl financialTransaction = new FinancialTransactionImpl();
            if (entryBook != null) {
                financialTransaction.setEntryBook(entryBook);
            }
            financialTransaction.setTransactionDate(this.getUseDate());
            financialTransaction = tableModel.addTransaction((FinancialTransaction)financialTransaction);
            int addIndex = tableModel.indexOf((FinancialTransaction)financialTransaction);
            if (table.isEditing()) {
                TableCellEditor editor = table.getCellEditor();
                editor.stopCellEditing();
            }
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.setSelectionInterval(addIndex, addIndex);
            table.changeSelection(addIndex, 0, false, false);
            table.editCellAt(addIndex, 0);
            table.scrollRowToVisible(Math.max(0, addIndex - 5));
            table.scrollRowToVisible(Math.min(tableModel.size() - 1, addIndex + 5));
        }
        catch (LockedFinancialPeriodException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.transaction.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
        }
        catch (AfterLastFiscalPeriodException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.transaction.error.afterLastFiscalPeriod", (Object[])new Object[]{e.getDate()}));
        }
        catch (BeforeFirstFiscalPeriodException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.transaction.error.beforeFirstFiscalPeriod", (Object[])new Object[]{e.getDate()}));
        }
        catch (LockedEntryBookException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.transaction.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
        }
    }

    public void addEntry() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            try {
                BigDecimal debit;
                BigDecimal credit;
                String defaultAccount;
                Entry entryAt = (Entry)tableModel.get(indexSelectedRow);
                FinancialTransaction transaction = entryAt.getFinancialTransaction();
                int rowLasEntry = tableModel.indexOf(transaction) + transaction.sizeEntry() - 1;
                Entry lastEntry = (Entry)tableModel.get(rowLasEntry);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Selected row : " + indexSelectedRow));
                }
                String defaultVoucher = null;
                String defaultDescription = null;
                if (lastEntry != null) {
                    defaultVoucher = lastEntry.getVoucher();
                    defaultDescription = lastEntry.getDescription();
                }
                EntryImpl entry = new EntryImpl();
                entry.setVoucher(defaultVoucher);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Description of precedent entry : " + defaultDescription));
                }
                entry.setDescription(defaultDescription);
                BigDecimal tvaPercentAdd = new BigDecimal(0.196);
                BigDecimal tvaTax = null;
                if (lastEntry != null && lastEntry.getAccount() != null && ((defaultAccount = lastEntry.getAccount().getAccountNumber()).equals("410") || defaultAccount.equals("418"))) {
                    tvaTax = lastEntry.getAmount().multiply(tvaPercentAdd);
                }
                if (tvaTax != null) {
                    entry.setAmount(tvaTax);
                    entry.setDebit(true);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("tva : " + tvaTax));
                }
                entry.setDebit((credit = transaction.getAmountCredit()).compareTo(debit = transaction.getAmountDebit()) > 0);
                entry.setAmount(credit.subtract(debit).abs());
                entry.setFinancialTransaction(transaction);
                tableModel.addEntry((Entry)entry);
                int row = rowLasEntry + 1;
                ListSelectionModel selectionModel = table.getSelectionModel();
                selectionModel.setSelectionInterval(row, row);
                table.changeSelection(row, 1, false, false);
                table.editCellAt(row, 1);
            }
            catch (LockedFinancialPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.entry.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
            }
            catch (AfterLastFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.entry.error.afterLastFiscalPeriod", (Object[])new Object[]{e.getDate()}));
            }
            catch (BeforeFirstFiscalPeriodException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.entry.error.beforeFirstFiscalPeriod", (Object[])new Object[]{e.getDate()}));
            }
            catch (LockedEntryBookException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.add.entry.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call addentry selected transaction without selection");
        }
    }

    public void deleteSelectedTransaction() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow >= 0) {
            int response;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            if ((response = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.entries.remove.transaction.confirm", (Object[])new Object[0]), I18n.t((String)"lima.entries.remove.transaction.title", (Object[])new Object[0]), 0)) == 0) {
                try {
                    tableModel.removeTransaction(indexSelectedRow);
                    if (tableModel.size() > 0) {
                        if (indexSelectedRow >= tableModel.size()) {
                            indexSelectedRow = tableModel.size() - 1;
                        }
                        selectionModel.setSelectionInterval(indexSelectedRow, indexSelectedRow);
                        table.changeSelection(indexSelectedRow, 1, false, false);
                        table.editCellAt(indexSelectedRow, 1);
                    }
                }
                catch (LockedFinancialPeriodException e) {
                    this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.remove.transaction.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
                }
                catch (LockedEntryBookException e) {
                    this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.remove.transaction.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
                }
            }
        }
    }

    public void deleteSelectedEntry() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow >= 0) {
            int response;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            if ((response = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.entries.remove.entry.confirm", (Object[])new Object[0]), I18n.t((String)"lima.entries.remove.entry.title", (Object[])new Object[0]), 0)) == 0) {
                try {
                    tableModel.removeEntry(indexSelectedRow);
                    if (tableModel.size() > 0) {
                        if (indexSelectedRow >= tableModel.size()) {
                            indexSelectedRow = tableModel.size() - 1;
                        }
                        selectionModel.setSelectionInterval(indexSelectedRow, indexSelectedRow);
                        table.changeSelection(indexSelectedRow, 1, false, false);
                        table.editCellAt(indexSelectedRow, 1);
                    }
                }
                catch (LockedFinancialPeriodException e) {
                    this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.remove.entry.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
                }
                catch (LockedEntryBookException e) {
                    this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.remove.entry.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
                }
            }
        }
    }

    public void assignAllEntries() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        table.exit();
        int selectedRow = table.getSelectedRow();
        int selectedColumn = table.getSelectedColumn();
        if (selectedRow >= 0 && (selectedColumn == 1 || selectedColumn == 3)) {
            Entry entrySource = (Entry)tableModel.get(selectedRow);
            FinancialTransaction transaction = entrySource.getFinancialTransaction();
            HashMap previousValuesMap = Maps.newHashMap();
            try {
                for (Entry entryTarget : transaction.getEntry()) {
                    if (entrySource == entryTarget) continue;
                    switch (selectedColumn) {
                        case 1: {
                            if (StringUtils.equals((String)entryTarget.getVoucher(), (String)entrySource.getVoucher())) break;
                            previousValuesMap.put(entryTarget, entryTarget.getVoucher());
                            entryTarget.setVoucher(entrySource.getVoucher());
                            this.financialTransactionService.updateEntry(entryTarget);
                            break;
                        }
                        case 3: {
                            if (StringUtils.equals((String)entryTarget.getDescription(), (String)entrySource.getDescription())) break;
                            previousValuesMap.put(entryTarget, entryTarget.getDescription());
                            entryTarget.setDescription(entrySource.getDescription());
                            this.financialTransactionService.updateEntry(entryTarget);
                        }
                    }
                }
                int firstRow = tableModel.indexOf(transaction);
                int lastRow = firstRow + transaction.sizeEntry() - 1;
                tableModel.fireTableRowsUpdated(firstRow, lastRow);
                table.editCellAt(selectedRow, selectedColumn);
            }
            catch (LockedEntryBookException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.entries.assign.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
                for (Map.Entry mapEntry : previousValuesMap.entrySet()) {
                    Entry entry = (Entry)mapEntry.getKey();
                    String previousValue = (String)mapEntry.getValue();
                    switch (selectedColumn) {
                        case 1: {
                            entry.setVoucher(previousValue);
                            break;
                        }
                        case 3: {
                            entry.setDescription(previousValue);
                        }
                    }
                }
            }
        }
    }

    public void back(JComboBox comboBox) {
        int row = comboBox.getSelectedIndex();
        if (row > 0) {
            comboBox.setSelectedIndex(row - 1);
        }
    }

    public void next(JComboBox comboBox) {
        int size = comboBox.getModel().getSize();
        int row = comboBox.getSelectedIndex();
        if (row < size - 1) {
            comboBox.setSelectedIndex(row + 1);
        }
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method notified " + serviceName + "#" + methodName));
        }
        if (serviceName.contains("FinancialTransaction") || methodName.contains("importEntries") || methodName.contains("importAll")) {
            this.updateFinancialTransactions();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0 && e.getColumn() == 0 && e.getFirstRow() >= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Date changed");
            }
            FinancialTransactionTable table = this.view.getFinancialTransactionTable();
            FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
            Entry entry = (Entry)tableModel.get(e.getFirstRow());
            FinancialTransaction financialTransaction = entry.getFinancialTransaction();
            this.lastAssignDate = financialTransaction.getTransactionDate();
            tableModel.sort();
            int newRow = tableModel.indexOf(entry);
            table.changeSelection(newRow, 0, false, false);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        int selectedRow = table.getSelectedRow();
        int selectedColumn = table.getSelectedColumn();
        if (selectedRow >= 0 && selectedRow < tableModel.size()) {
            FinancialTransaction transaction = tableModel.getTransactionAt(selectedRow);
            this.view.setAssignableInAllEntries(transaction.sizeEntry() > 1 && (selectedColumn == 1 || selectedColumn == 3));
        } else {
            this.view.setAssignableInAllEntries(false);
        }
    }

    public Date getUseDate() {
        FinancialPeriod financialPeriod = (FinancialPeriod)this.view.getFinancialPeriodComboBox().getSelectedItem();
        Date beginDate = financialPeriod.getBeginDate();
        Date endDate = financialPeriod.getEndDate();
        if (this.lastAssignDate == null || this.lastAssignDate.before(beginDate) || this.lastAssignDate.after(endDate)) {
            this.lastAssignDate = beginDate;
        }
        return this.lastAssignDate;
    }

    protected void computeStatusText() {
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        BigDecimal totalDebit = BigDecimal.ZERO;
        BigDecimal totalCredit = BigDecimal.ZERO;
        BigDecimal balance = BigDecimal.ZERO;
        for (Entry entry : tableModel.getValues()) {
            BigDecimal amount = entry.getAmount();
            boolean debit = entry.isDebit();
            if (debit) {
                totalDebit = totalDebit.add(amount);
                continue;
            }
            totalCredit = totalCredit.add(amount);
        }
        balance = totalDebit.subtract(totalCredit);
        String result = balance.compareTo(BigDecimal.ZERO) == 0 ? String.format(I18n.t((String)"lima.financialTransaction.statusTextDebitCredit", (Object[])new Object[0]), BigDecimalToString.format(totalDebit), BigDecimalToString.format(totalCredit), BigDecimalToString.format(balance)) : String.format(I18n.t((String)"lima.financialTransaction.statusTextDebitCreditError", (Object[])new Object[0]), BigDecimalToString.format(totalDebit), BigDecimalToString.format(totalCredit), BigDecimalToString.format(balance));
        this.view.setStatusText(result);
    }
}

