/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.FinancialTransactionCondition;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.Filter.AccountCondition.AccountConditionView;
import org.chorem.lima.ui.Filter.BigDecimalCondition.CreditConditionView;
import org.chorem.lima.ui.Filter.BigDecimalCondition.DebitConditionView;
import org.chorem.lima.ui.Filter.ConditionHandler;
import org.chorem.lima.ui.Filter.EntryBookCondition.EntryBookConditionView;
import org.chorem.lima.ui.Filter.StringCondition.DescriptionConditionView;
import org.chorem.lima.ui.Filter.StringCondition.LetteringConditionView;
import org.chorem.lima.ui.Filter.StringCondition.VoucherConditionView;
import org.chorem.lima.ui.Filter.dateCondition.DateConditionView;
import org.chorem.lima.ui.Filter.dateIntervalCondition.DateIntervalConditionView;
import org.chorem.lima.ui.Filter.financialPeriodCondition.FinancialPeriodConditionView;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionHandler;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionView;
import org.chorem.lima.ui.Filter.fiscalPeriodCondition.FiscalPeriodConditionView;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionDefaultTable;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchTableModel;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchView;

public class FinancialTransactionSearchViewHandler {
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchViewHandler.class);
    protected FinancialTransactionSearchView view;
    protected FinancialTransactionSearchTableModel tableModel;
    protected final FinancialTransactionService financialTransactionService;
    protected Object clipBoard;

    protected FinancialTransactionSearchViewHandler(FinancialTransactionSearchView view) {
        this.view = view;
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        this.initShortCuts();
    }

    protected void initShortCuts() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "refresh";
        inputMap.put(KeyStroke.getKeyStroke(116, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionSearchViewHandler.this.refresh();
            }
        });
    }

    protected void addCondition(ConditionHandler conditionHandler) {
        FinancialTransactionConditionView filterView = this.view.getFinancialTransactionConditionView();
        FinancialTransactionConditionHandler handler = filterView.getHandler();
        handler.addCondition(conditionHandler);
        this.view.validate();
        this.view.repaint();
    }

    public void addDateCondition() {
        this.addCondition(new DateConditionView().getHandler());
    }

    public void addDateIntervalCondition() {
        this.addCondition(new DateIntervalConditionView().getHandler());
    }

    public void addFinancialPeriodCondition() {
        this.addCondition(new FinancialPeriodConditionView().getHandler());
    }

    public void addFiscalPeriodCondition() {
        this.addCondition(new FiscalPeriodConditionView().getHandler());
    }

    public void addEntryBookCondition() {
        this.addCondition(new EntryBookConditionView().getHandler());
    }

    public void addVoucherCondition() {
        this.addCondition(new VoucherConditionView().getHandler());
    }

    public void addDescriptionCondition() {
        this.addCondition(new DescriptionConditionView().getHandler());
    }

    public void addLetteringCondition() {
        this.addCondition(new LetteringConditionView().getHandler());
    }

    public void addAccountCondition() {
        this.addCondition(new AccountConditionView().getHandler());
    }

    public void addDebitCondition() {
        this.addCondition(new DebitConditionView().getHandler());
    }

    public void addCreditCondition() {
        this.addCondition(new CreditConditionView().getHandler());
    }

    public void refresh() {
        FinancialTransactionDefaultTable table = this.view.getFinancialTransactionSearchTable();
        table.exit();
        FinancialTransactionConditionView conditionView = this.view.getFinancialTransactionConditionView();
        FinancialTransactionConditionHandler conditionHandler = conditionView.getHandler();
        FinancialTransactionCondition condition = conditionHandler.getFilter();
        this.tableModel = this.view.getFinancialTransactionSearchTableModel();
        if (this.tableModel != null) {
            this.tableModel.refresh(condition);
        }
    }
}

