/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybooksreports;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.nuiton.i18n.I18n;

public class EntryBooksReportsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EntryBooksReportsTableModel.class);
    protected ReportsDatas reportData;

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.reportData != null && this.reportData.getListEntry() != null) {
            result = this.reportData.getListEntry().size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = Date.class;
                break;
            }
            case 1: {
                result = Account.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = String.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = BigDecimal.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n.t((String)"lima.table.date", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n.t((String)"lima.table.account", (Object[])new Object[0]);
                break;
            }
            case 2: {
                res = I18n.t((String)"lima.table.voucher", (Object[])new Object[0]);
                break;
            }
            case 3: {
                res = I18n.t((String)"lima.table.description", (Object[])new Object[0]);
                break;
            }
            case 4: {
                res = I18n.t((String)"lima.table.letter", (Object[])new Object[0]);
                break;
            }
            case 5: {
                res = I18n.t((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 6: {
                res = I18n.t((String)"lima.table.credit", (Object[])new Object[0]);
            }
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.reportData.getListEntry() != null) {
            Entry currentRow = (Entry)this.reportData.getListEntry().get(row);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMMMM yyyy");
            switch (column) {
                case 0: {
                    result = simpleDateFormat.format(currentRow.getFinancialTransaction().getTransactionDate());
                    break;
                }
                case 1: {
                    if (currentRow.getAccount() != null) {
                        result = currentRow.getAccount().getAccountNumber();
                        break;
                    }
                    result = null;
                    break;
                }
                case 2: {
                    result = currentRow.getVoucher();
                    break;
                }
                case 3: {
                    result = currentRow.getDescription();
                    break;
                }
                case 4: {
                    result = currentRow.getLettering();
                    break;
                }
                case 5: {
                    result = currentRow.getDebit() ? currentRow.getAmount() : BigDecimal.ZERO;
                    break;
                }
                case 6: {
                    result = currentRow.getDebit() ? BigDecimal.ZERO : currentRow.getAmount();
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No EntryBook selected skip table model update");
        }
        return result;
    }

    public Entry getElementAt(int row) {
        return (Entry)this.reportData.getListEntry().get(row);
    }

    public void setReportDatas(ReportsDatas datasList) {
        this.reportData = datasList;
        this.fireTableDataChanged();
    }
}

