/*
 * #%L
 * Lima :: Swing
 * 
 * $Id: VatChartTreeTable.java 3557 2012-08-01 09:07:09Z mallon $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/vatchart/VatChartTreeTable.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.vatchart;

import org.chorem.lima.entity.VatStatement;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;

import javax.swing.tree.TreePath;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class VatChartTreeTable extends JXTreeTable
        implements KeyListener, MouseListener {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3960840343197845825L;

    protected VatChartViewHandler handler;
    //protected Color colorSelectionFocus;

    private Highlighter colorLine;

    public VatChartTreeTable(VatChartViewHandler handler) {
        this.handler = handler;

        addKeyListener(this);
        addMouseListener(this);

        //highlight missing box name lines 
        addMissingBoxNameColor();
    }

    /** Highlights line when line is a leaf and is missing its BoxName parameter */
    private void addMissingBoxNameColor() {
        if (colorLine != null) {
            removeHighlighter(colorLine);
        }
        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                                         ComponentAdapter adapter) {
                JXTreeTable treeTable = handler.view.getTreeTable();
                TreeTableModel treeTableModel = treeTable.getTreeTableModel();
                TreePath treePath = treeTable.getPathForRow(adapter.row);
                VatStatement vatStatement =
                        (VatStatement) treePath.getLastPathComponent();
                boolean highlighted = false;
                if (vatStatement.getBoxName() != null) {
                    if (treeTableModel.isLeaf(vatStatement) && vatStatement.getBoxName().isEmpty()) {
                        highlighted = true;
                    }
                } else {
                    highlighted = true;
                }
                return highlighted;
            }
        };
        colorLine =
                new ColorHighlighter(predicate, new Color(255, 198, 209), null);
        addHighlighter(colorLine);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (rowAtPoint(e.getPoint()) == -1) {
            clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /**
     * for each action combination key are think
     * for extend keyboard and laptop keyboard
     */
    @Override
    public void keyPressed(KeyEvent e) {
        // clear row selection with the key: escape
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            if (!isEditing()) {
                clearSelection();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

}
