package org.chorem.lima.ui.opening;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class OpeningView extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVgoUEAQCYgBTsSHGxC0kJhohiEIIkCpEjCH24uzu2A5Md8aZWVkuxj/BP0HvXky8eTIePHvwYvwXjPHg1fhmt922sECT9jDbfT++97238733v1BGSXRlDweBJX1P0yqxNu/t7m7Ze8TRq0Q5kgrNJYp+qTRKl1C/G9uVRldLRZNeqKUXVnhVcI94TdkLRdSn9CEjqkKI1mi6NcNRqrATuxcC4cs6akwqCfXtn9/pN+7rd2mEAgHsBqGV3FlZjU66iihNXY1GoNJLXGDYKwMNSb0y8D1vbCsMK/UQV8kL9Ar1FFG3wBLANJppv+UQI8wPhEbZ/OYqxYyX5zSa5bJsORUuSdVitIotn1pcEA8IWFvR8wklB0KE6d0a9VSw5zIiNbrRXup6FN+EkH+MbUag+ETLnNSByQx9JjJ7NGHevA6bYyh2DVAXOqb6cMPhHkzRDCyoIW0WsU2YCRyJ4zMCe4QdDdw2xtbA3nyUPmfex81xMfbB/O77WnMPWhhtAYrMrdED2HE4tKgMxRitUWkQGpCHNuf7J0UMP6fKwUwQSbl7UlCd8HzsGzpOOHRebnWm+X6zVaLJlq8CurAaumhc3FQJZaQPZviMpeNSegSuSEQTR0RkAEPvv/HR759+flyrK6cfao8lhjYJH260kHDLpKam9FAkG19TVniAxUIJZRVhsDXCrTCVQGyn5gZyUG/YpFsm3VrHqgIQmZ4fn7+MP/t2DqXXUB/j2F3DJn4DZXVFwhQ4cwNxdzlkNHDQC+cFww3uVpW72NytReox6pEc1iBk29dkKYA5TCXMISZjZ7/+Hd35sFyfRQq4XToxvDGPzFPUHVUL90htRSTujX6hiO/yxipIWg4p8+wTNbHOhefNxGZBdJFObwW+edwOWZt/d9oG6aKhagcXXaxxzqaeCypaSsYbawdPk0CfwmnyTAxj3jgFYbothBVzrCYj5DpGmOkYId/xHGY7RrjWMcJ1QPgPuMZaHDwIAAA=";
    private static final Log log = LogFactory.getLog(OpeningView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel accountsIcon;
    protected JLabel entrybooksIcon;
    protected JLabel fiscalperiodsIcon;
    protected OpeningViewHandler handler;
    protected JLabel identityIcon;
    protected JButton ok;
    protected JPanel panel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private OpeningView $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performNext() {
            dispose();
        }
        protected void performCancel() {
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OpeningView(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0) {
        super(param0);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView() {
        $initialize();
    }

    public OpeningView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0) {
        super(param0);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0) {
        super(param0);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OpeningView(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public OpeningView(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importSave();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAccountsIcon() {
        return accountsIcon;
    }

    public JLabel getEntrybooksIcon() {
        return entrybooksIcon;
    }

    public JLabel getFiscalperiodsIcon() {
        return fiscalperiodsIcon;
    }

    public OpeningViewHandler getHandler() {
        return handler;
    }

    public JLabel getIdentityIcon() {
        return identityIcon;
    }

    public JButton getOk() {
        return ok;
    }

    public JPanel getPanel() {
        return panel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPanel() {
        if (!allComponentsCreated) {
            return;
        }
        panel.add($JLabel0);
        panel.add($JButton0);
    }

    protected void createAccountsIcon() {
        $objectMap.put("accountsIcon", accountsIcon = new JLabel());
        
        accountsIcon.setName("accountsIcon");
    }

    protected void createEntrybooksIcon() {
        $objectMap.put("entrybooksIcon", entrybooksIcon = new JLabel());
        
        entrybooksIcon.setName("entrybooksIcon");
    }

    protected void createFiscalperiodsIcon() {
        $objectMap.put("fiscalperiodsIcon", fiscalperiodsIcon = new JLabel());
        
        fiscalperiodsIcon.setName("fiscalperiodsIcon");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new OpeningViewHandler(this));
    }

    protected void createIdentityIcon() {
        $objectMap.put("identityIcon", identityIcon = new JLabel());
        
        identityIcon.setName("identityIcon");
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.ui.opening.next"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createPanel() {
        $objectMap.put("panel", panel = new JPanel());
        
        panel.setName("panel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.8, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(identityIcon, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(panel, new GridBagConstraints(1, 0, 1, 4, 0.9, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(accountsIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(entrybooksIcon, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fiscalperiodsIcon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToPanel();
        
        // apply 4 property setters
        identityIcon.setIcon(SwingUtil.createImageIcon("identity.png"));
        accountsIcon.setIcon(SwingUtil.createImageIcon("accounts.png"));
        entrybooksIcon.setIcon(SwingUtil.createImageIcon("entrybooks.png"));
        fiscalperiodsIcon.setIcon(SwingUtil.createImageIcon("fiscalperiods.png"));
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createIdentityIcon();
        createPanel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.ui.opening.welcome"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.ui.opening.import"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAccountsIcon();
        createEntrybooksIcon();
        createFiscalperiodsIcon();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_(""));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("lima.ui.opening.close"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(_("lima.ui.opening.title"));
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}