package org.chorem.lima.ui.lettering;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.common.AccountComboBoxModel;
import org.chorem.lima.ui.common.FinancialPeriodComboBoxModel;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class LetteringView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREDIT_TEXT_FIELD_TEXT = "creditTextField.text";
    public static final String BINDING_DEBIT_TEXTT_FIELD_TEXT = "debitTexttField.text";
    public static final String BINDING_LETTERED_ENABLED = "lettered.enabled";
    public static final String BINDING_NO_LETTERED_ENABLED = "noLettered.enabled";
    public static final String BINDING_ROUND_ENABLED = "round.enabled";
    public static final String BINDING_SOLDE_TEXT_FIELD_TEXT = "soldeTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXTW8cNRjHnSWbZBPaQpKmrVqqFFZIUGk2TVIOJILmbQnRtlTdBUXkALMzTtbJrD14PGTaA/AR+AjlwI0LEjdOiEPPHLggvgJCHJA4IR7PzM50EsdrMjlsVrafn//P3y+P97s/UDXg6NahHUUWD6kgfWztrO3uftA9xI7YxIHDiS8YR8nfSAVV9tCUm7UHAr2215LhjTS8scH6PqOYPhe90kKTgXjs4aCHsRDolWKEEwSNdta9EvkhH1AzUSrq07/+rHztfvVNBaHIB3V1SGV+WFSeyWgLVYgr0DTM9Lnd8Gx6ADI4oQeg94Js2/DsIHhg9/Fn6As03kJjvs0BJtCr5inHjDg+8gUar3fsrocXBHqT8QPL6TGO+5ZH+rYVEssDc7AUYLUG3z4i+Nj3Y8AYhPds6nqYC3THPHw7ickpNewScZ+52BOoYcbZGkTklMn6Tocxb93mkM2stCuygmMZNWiXA2vZ+IkEi8HxmcLo9VAIRuWo6RxOWSsdLluuFHurnIVU1TGbaaq3MSyWDSsB6m6q1OUjioyJ+k7L7mIP4qYLcXHriflsxwEpAjZAl62zKDXVUpjqsH6fUWtNEZB7eukET6DLBQmD9qKK0a7tHCncGKU4EoYu3ZF9N9VOxH23in1TPnGOMN/EXVg9NC8TPoRr4UgwPxEbWTu7m7bAD+NxavCiAlxLwE0S74jF4coXNcqXFBPMyn0I+2qLCv44N7peuDgSv+U5YdzaomF/K/46XM2SQs04x/scLjfFUuSHKDZ59sSRSdNYztJYz7eKi7tEdGCFRZNgD07VXHGXQ0/cUQxTaV7ONK+fmvquamqHS2cKM2wPn+auZpq3FNNcDJjnYt0sF+o7bYczz3toU3mnXik4kHcVXZ0U8gpOj+qC2f3XyULywzoXbyTobGMPiiVhNGUuDWWejsqx1VieQLf/hzIZ+qEP5e96YRdDYbXywppXvpE9uEJDaBbo6t7pWvwIupIqfPVEFZbAuPffuZlff/z9h+ag9C7A3JeVQ597OUBJ9DnzoXwROfWlpO6GgniN+7a/sodqQexJ/Ky4oRDWTrtBHMz3sgy3ZLi1bQc9QFTHf/vp57lPf3kBVZpo0mO227Tl+PdRTfTkCYQNFfnv3osVvXg8AZ8vSW1w6+zD6NT46VVCPULxvC0XCu43/E4EXtxQeJEJ6tae/T3T/v7ewI8R0HftzOG5J9WP0VgyW/wYSd8ZysfHlB/g0GX5e0L1whiR/2f8dDftx5+HqoRHicMonLFVF9Ke7xLqwl6CPGUAjROQ3xLenAFvHFPpXpxBeH7MlIBbo0P8Tlq5zo2SzTrCNSPCk9KEL0sTdFlcL52FGUGXhRlBl8W8wcaY8GSZaCYluASn2pe3rQbyuokY+BXgwttUJ2Y4JzO2X4agM/aN0hrMCDoNt0trMCM81WhomFyIIr1yzlAxnDFMxbIR4ZlGgxlBtxpvl87CjKBbz9XSWayVvrTMCJ4mi43STm6V3g9mhCcawnsGJ6O2z5wwGDwzzw3KkjnDDjOCztBWaUPNCDpDHxgR/ilN0DlpRtA5+ai0k2YEnZOd0k6aEXROmhG+1RA+MTlgnB1vY3LQ09UfE9DFoPCbsqSsiYBxMeTYS85/wPbjMUUWAAA=";
    private static final Log log = LogFactory.getLog(LetteringView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox accountComboBox;
    protected AccountComboBoxModel accountComboBoxModel;
    protected JButton back;
    protected JTextField creditTextField;
    protected JTextField debitTexttField;
    protected LetteringEditModel editModel;
    protected LetteringViewHandler handler;
    protected JButton lettered;
    protected EnumEditor<TypeEntry> lettredEntryComboBox;
    protected LettringSelectionModel lettringSelectionModel;
    protected JButton next;
    protected JButton noLettered;
    protected JXDatePicker pickerDebut;
    protected JXDatePicker pickerFin;
    protected JButton refresh;
    protected JButton round;
    protected JTextField soldeTextField;
    protected LetteringTable table;
    protected LetteringTableModel tableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;
    private Separator $JToolBar$Separator4;
    private Separator $JToolBar$Separator5;
    private JToolBar $JToolBar0;
    private JToolBar $JToolBar1;
    private LetteringView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            handler.init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LetteringView() {
        $initialize();
    }

    public LetteringView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.back(accountComboBox);
    }

    public void doActionPerformed__on__lettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addLetter();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next(accountComboBox);
    }

    public void doActionPerformed__on__noLettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeLetter();
    }

    public void doActionPerformed__on__pickerDebut(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDateStart(pickerDebut.getDate());
    }

    public void doActionPerformed__on__pickerFin(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDateEnd(pickerFin.getDate());
    }

    public void doActionPerformed__on__refresh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAllEntries();
    }

    public void doActionPerformed__on__round(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.roundAndCreateEntry();
    }

    public void doItemStateChanged__on__accountComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAccount((Account)accountComboBoxModel.getSelectedItem());
    }

    public void doItemStateChanged__on__lettredEntryComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setTypeEntry(lettredEntryComboBox.getSelectedItem());
    }

    public void doValueChanged__on__lettringSelectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceAndActions();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getAccountComboBox() {
        return accountComboBox;
    }

    public AccountComboBoxModel getAccountComboBoxModel() {
        return accountComboBoxModel;
    }

    public JButton getBack() {
        return back;
    }

    public JTextField getCreditTextField() {
        return creditTextField;
    }

    public JTextField getDebitTexttField() {
        return debitTexttField;
    }

    public LetteringEditModel getEditModel() {
        return editModel;
    }

    public LetteringViewHandler getHandler() {
        return handler;
    }

    public JButton getLettered() {
        return lettered;
    }

    public EnumEditor<TypeEntry> getLettredEntryComboBox() {
        return lettredEntryComboBox;
    }

    public LettringSelectionModel getLettringSelectionModel() {
        return lettringSelectionModel;
    }

    public JButton getNext() {
        return next;
    }

    public JButton getNoLettered() {
        return noLettered;
    }

    public JXDatePicker getPickerDebut() {
        return pickerDebut;
    }

    public JXDatePicker getPickerFin() {
        return pickerFin;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public JButton getRound() {
        return round;
    }

    public JTextField getSoldeTextField() {
        return soldeTextField;
    }

    public LetteringTable getTable() {
        return table;
    }

    public LetteringTableModel getTableModel() {
        return tableModel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected Separator get$JToolBar$Separator4() {
        return $JToolBar$Separator4;
    }

    protected Separator get$JToolBar$Separator5() {
        return $JToolBar$Separator5;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected JToolBar get$JToolBar1() {
        return $JToolBar1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountComboBox() {
        $objectMap.put("accountComboBox", accountComboBox = new JComboBox());
        
        accountComboBox.setName("accountComboBox");
        accountComboBox.setToolTipText(_("lima.ui.lettering.account"));
        accountComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__accountComboBox"));
    }

    protected void createAccountComboBoxModel() {
        $objectMap.put("accountComboBoxModel", accountComboBoxModel = new AccountComboBoxModel());
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setToolTipText(_("lima.ui.account.buttonback"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createCreditTextField() {
        $objectMap.put("creditTextField", creditTextField = new JTextField());
        
        creditTextField.setName("creditTextField");
        creditTextField.setColumns(15);
        creditTextField.setEnabled(false);
        creditTextField.setFocusable(false);
    }

    protected void createDebitTexttField() {
        $objectMap.put("debitTexttField", debitTexttField = new JTextField());
        
        debitTexttField.setName("debitTexttField");
        debitTexttField.setColumns(15);
        debitTexttField.setEnabled(false);
        debitTexttField.setFocusable(false);
    }

    protected void createEditModel() {
        $objectMap.put("editModel", editModel = new LetteringEditModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new LetteringViewHandler(this));
    }

    protected void createLettered() {
        $objectMap.put("lettered", lettered = new JButton());
        
        lettered.setName("lettered");
        lettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lettered"));
    }

    protected void createLettredEntryComboBox() {
        $objectMap.put("lettredEntryComboBox", lettredEntryComboBox = new EnumEditor<TypeEntry>(TypeEntry.class));
        
        lettredEntryComboBox.setName("lettredEntryComboBox");
        lettredEntryComboBox.setToolTipText(_("lima.ui.lettering.entry"));
        lettredEntryComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__lettredEntryComboBox"));
    }

    protected void createLettringSelectionModel() {
        $objectMap.put("lettringSelectionModel", lettringSelectionModel = new LettringSelectionModel(tableModel));
        
        lettringSelectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__lettringSelectionModel"));
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setToolTipText(_("lima.ui.account.buttonnext"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createNoLettered() {
        $objectMap.put("noLettered", noLettered = new JButton());
        
        noLettered.setName("noLettered");
        noLettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__noLettered"));
    }

    protected void createPickerDebut() {
        $objectMap.put("pickerDebut", pickerDebut = new JXDatePicker());
        
        pickerDebut.setName("pickerDebut");
        pickerDebut.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pickerDebut"));
    }

    protected void createPickerFin() {
        $objectMap.put("pickerFin", pickerFin = new JXDatePicker());
        
        pickerFin.setName("pickerFin");
        pickerFin.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pickerFin"));
    }

    protected void createRefresh() {
        $objectMap.put("refresh", refresh = new JButton());
        
        refresh.setName("refresh");
        refresh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__refresh"));
    }

    protected void createRound() {
        $objectMap.put("round", round = new JButton());
        
        round.setName("round");
        round.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__round"));
    }

    protected void createSoldeTextField() {
        $objectMap.put("soldeTextField", soldeTextField = new JTextField());
        
        soldeTextField.setName("soldeTextField");
        soldeTextField.setColumns(15);
        soldeTextField.setEnabled(false);
        soldeTextField.setFocusable(false);
    }

    protected void createTable() {
        $objectMap.put("table", table = new LetteringTable(handler));
        
        table.setName("table");
        table.setRowHeight(22);
        table.setSortable(false);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new LetteringTableModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JToolBar1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add(lettered);
        $JToolBar0.add(noLettered);
        $JToolBar0.add(round);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JLabel0);
        $JToolBar0.add(accountComboBox);
        $JToolBar0.add(back);
        $JToolBar0.add(next);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add($JLabel1);
        $JToolBar0.add(pickerDebut);
        $JToolBar0.add($JLabel2);
        $JToolBar0.add(pickerFin);
        $JToolBar0.add($JToolBar$Separator2);
        $JToolBar0.add($JLabel3);
        $JToolBar0.add(lettredEntryComboBox);
        $JToolBar0.add($JToolBar$Separator3);
        $JToolBar0.add(refresh);
        // inline complete setup of $JToolBar1
        $JToolBar1.add($JLabel4);
        $JToolBar1.add(debitTexttField);
        $JToolBar1.add($JToolBar$Separator4);
        $JToolBar1.add($JLabel5);
        $JToolBar1.add(creditTextField);
        $JToolBar1.add($JToolBar$Separator5);
        $JToolBar1.add($JLabel6);
        $JToolBar1.add(soldeTextField);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(table);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 23 property setters
        lettered.setIcon(SwingUtil.createActionIcon("lettering"));
        lettered.setToolTipText( _("lima.ui.lettering.buttonLettered") + " (Ctrl+L)");
        noLettered.setIcon(SwingUtil.createActionIcon("un-lettering"));
        noLettered.setToolTipText( _("lima.ui.lettering.buttonNoLettered") + " (Del)");
        round.setIcon(SwingUtil.createActionIcon("balance"));
        round.setToolTipText( _("lima.ui.lettering.buttonEqualize") + " (Ctrl+B)");
        $JLabel0.setIcon(SwingUtil.createActionIcon("choose-account"));
        $JLabel0.setLabelFor(accountComboBox);
        accountComboBox.setModel(accountComboBoxModel);
        accountComboBox.setRenderer(new org.chorem.lima.ui.common.AccountListRenderer());
        back.setIcon(SwingUtil.createActionIcon("previous"));
        next.setIcon(SwingUtil.createActionIcon("next"));
        $JLabel1.setLabelFor(pickerDebut);
        $JLabel2.setLabelFor(pickerFin);
        $JLabel3.setIcon(SwingUtil.createActionIcon("choose-entry"));
        $JLabel3.setLabelFor(lettredEntryComboBox);
        refresh.setIcon(SwingUtil.createActionIcon("refresh"));
        refresh.setToolTipText( _("lima.ui.lettering.buttonRefresh") + " (F5)");
        $JLabel4.setLabelFor(debitTexttField);
        $JLabel5.setLabelFor(creditTextField);
        $JLabel6.setLabelFor(soldeTextField);
        table.setModel(tableModel);
        table.setSelectionModel(lettringSelectionModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createEditModel();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createLettered();
        createNoLettered();
        createRound();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createAccountComboBoxModel();
        createAccountComboBox();
        createBack();
        createNext();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.ui.lettering.beginFinancialPeriod"));
        createPickerDebut();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.ui.lettering.endFinancialPeriod"));
        createPickerFin();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        createLettredEntryComboBox();
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        createRefresh();
        // inline creation of $JToolBar1
        $objectMap.put("$JToolBar1", $JToolBar1 = new JToolBar());
        
        $JToolBar1.setName("$JToolBar1");
        $JToolBar1.setFloatable(false);
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("lima.ui.lettering.selectDebit"));
        createDebitTexttField();
        // inline creation of $JToolBar$Separator4
        $objectMap.put("$JToolBar$Separator4", $JToolBar$Separator4 = new Separator());
        
        $JToolBar$Separator4.setName("$JToolBar$Separator4");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("lima.ui.lettering.selectCredit"));
        createCreditTextField();
        // inline creation of $JToolBar$Separator5
        $objectMap.put("$JToolBar$Separator5", $JToolBar$Separator5 = new Separator());
        
        $JToolBar$Separator5.setName("$JToolBar$Separator5");
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("lima.ui.lettering.selectSolde"));
        createSoldeTextField();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTableModel();
        createLettringSelectionModel();
        createTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LETTERED_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("lettred", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    lettered.setEnabled(editModel.isLettred());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("lettred", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_LETTERED_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("unLettred", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    noLettered.setEnabled(editModel.isUnLettred());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("unLettred", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ROUND_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("equalized", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    round.setEnabled(editModel.isEqualized());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("equalized", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEBIT_TEXTT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("debit", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null && editModel.getDebit() != null) {
                    SwingUtil.setText(debitTexttField, editModel.getDebit().toString());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("debit", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREDIT_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("credit", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null && editModel.getCredit() != null) {
                    SwingUtil.setText(creditTextField, editModel.getCredit().toString());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("credit", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOLDE_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("solde", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null && editModel.getSolde() != null) {
                    SwingUtil.setText(soldeTextField, editModel.getSolde().toString());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("solde", this);
                }
            }
        });
    }

}