/*
 * #%L
 * Lima Swing
 * 
 * $Id: MiscAction.java 3305 2011-09-27 08:28:48Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/actions/MiscAction.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.actions;

import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaMain;

import java.util.Arrays;

import static org.nuiton.i18n.I18n._;

/**
 * Les actions appellables via {@link LimaMain}.
 *
 * @author tony
 * @version $Revision: 3305 $
 *          <p/>
 *          Last update : $Date: 2011-09-27 10:28:48 +0200 (Tue, 27 Sep 2011) $
 *          By : $Author: tchemit $
 */
public class MiscAction {

    /** La configuration de l'application. */
    protected LimaConfig config;

    public MiscAction(LimaConfig config) {
        this.config = config;
    }

    public void help() {
        System.out.println(_("lima.message.help.usage"));
        for (LimaConfig.Option o : LimaConfig.Option.values()) {
            System.out.println("\t" + o.key + "(" + o.defaultValue + "):" + o.getDescription());
        }

        System.out.println("Actions:");
        for (LimaConfig.Action a : LimaConfig.Action.values()) {
            System.out.println("\t" + Arrays.toString(a.aliases) + "(" + a.action + "):" + a.getDescription());
        }
    }
}
