/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.vatreports;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxRenderer;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxRenderer;
import org.chorem.lima.ui.financialtransaction.FinancialPeriodComboBox;
import static org.nuiton.i18n.I18n._;

public class VatReportView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVUQW8TRxR+MTiJCQmFlBTUFKXUwAE0LkhISIlCSKooRIaiGCGELx17h3hgvLPMvI23PVT8BH4C3LkgceNU9dAzBy5V/0JV9dBr1TezsdeLFzCV2MPu6s37vve9NzPf8z+hbA18/YAnCTNxiLIr2Pa1u3e/bz0QbfxO2LaREWoD6TNRglITZoJB3CJ806w7eG0fXtvQ3UiHIhxCL9fhkMUflbAdIRDhqzyibW2tMVheTqLY9FkHoopYn/79V+lJ8PhZCSCJSN0ctbL0IVTWycE6lGSAcIwq7fGa4uEuyTAy3CW9sy62obi1N3lXPIKfYaoOkxE3RIZwevyWPYfHJxHCVPU2bynxLcJ5bXZZu6ON6DIlu5zFku1xNCLSBi27w3HH/96RohdFnmGS8B0eBkoYhEsfgd9KQRnNjBWK9lcEO7qHcNT1ylz/bF1rJXiYZc5XG76j66FEyZX8SRgSf9ZPuU1tS+JladNsJDOjOXpf2jZXt4SROqjzllA0d1c2YbZHE2fbPuiyKxmoqwOhNoeQCJcL2iYdLd3SCRtO3XDBdZ3ccByZkLkot4pwPKeiH88LWawOxpmSNwQ37c4tHgpF07gy5laMYPNVDvMYtZupEihGhHVE++GIsFkRSCT+9RhRh7RbOUwafQtR3aZt0ko5AaT9ixwiW8qj5vf6Pfjj62eKcHHMvjPM0D7kGREufAyZIzk34Pq8WpcWG/5ISx36StTaqeHWRjNIi4Evc3ZBRsQyI8qcYqIJZRNTGOFEc9S7dmgpda0Tb7mWI/Sr/y7Mv3n1x8vNvlVNU+3jhalDTksWEhlNBxalK30k9akYpard4NFyEyrpNfY2vFggrLG/TOKoXnrNHZxtcdshivLU77/8uvDD6wNQ2oRDSvNgk7v861DBjqEpaBUk0dU1r+hwb5renzltCAdRJOSDx1ZkqGQoljiScbZiFKsJjWGxYAwDLa3Kb//MN16s9UcxQdJOvjM9G0f5Hkym1bxv71tyoU/PRFbEgc6st8iMJ9x3Ido/klf8e6Wo1+m+WbqMq0nsPmteuPtb9zynP8jjwquflOHMGL2Uu+nVnVsJOPKllgwDuh2rxYRsDMKK0b0tIXc7+B5l4xDN2uHb6dJu/3+yaUtO0TeK94j6DxBbuMQACQAA";
    public static final String PROPERTY$VAT_REPORT_PERIOD_SEARCH_PANEL0 = "$VatReportPeriodSearchPanel0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(VatReportView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autocomplete;
    protected JButton editVatButton;
    protected JLabel fiscalPeriodLabel;
    protected VatReportViewHandler handler;
    protected FiscalPeriodComboBoxModel modelFiscalPeriod;
    protected JComboBox periodComboBox;
    protected Boolean selectedRow;
    protected VatReportTable vatReportTable;
    protected VatReportTableModel vatReportTableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VatReportView $Table0 = this;
    private VatReportPeriodSearchPanel $VatReportPeriodSearchPanel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    VatReportPeriodSearchPanel periodSearchPanel;
    
        
        void $afterCompleteSetup() {
            getHandler().refresh();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VatReportView() {
        $initialize();
    }

    public VatReportView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autocomplete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatReportTableModel().setAutocomplete();
    }

    public void doActionPerformed__on__editVatButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().editVat();
    }

    public void doActionPerformed__on__periodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        periodSearchPanel.refresh(ComboBoxDatesEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));              validate(); repaint();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(vatReportTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutocomplete() {
        return autocomplete;
    }

    public JButton getEditVatButton() {
        return editVatButton;
    }

    public JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    public VatReportViewHandler getHandler() {
        return handler;
    }

    public FiscalPeriodComboBoxModel getModelFiscalPeriod() {
        return modelFiscalPeriod;
    }

    public JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public VatReportTable getVatReportTable() {
        return vatReportTable;
    }

    public VatReportTableModel getVatReportTableModel() {
        return vatReportTableModel;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$VatReportPeriodSearchPanel0(VatReportPeriodSearchPanel $VatReportPeriodSearchPanel0) {
        VatReportPeriodSearchPanel oldValue = this.$VatReportPeriodSearchPanel0;
        this.$VatReportPeriodSearchPanel0 = $VatReportPeriodSearchPanel0;
        firePropertyChange(PROPERTY$VAT_REPORT_PERIOD_SEARCH_PANEL0, oldValue, $VatReportPeriodSearchPanel0);
    }

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(VatReportViewHandler handler) {
        VatReportViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setPeriodComboBox(JComboBox periodComboBox) {
        JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = periodComboBox;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, periodComboBox);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected VatReportPeriodSearchPanel get$VatReportPeriodSearchPanel0() {
        return $VatReportPeriodSearchPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAutocomplete() {
        $objectMap.put("autocomplete", autocomplete = new JCheckBox());
        
        autocomplete.setName("autocomplete");
        autocomplete.setSelected(true);
        autocomplete.setText(_("lima.common.autocomplete"));
        autocomplete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autocomplete"));
    }

    protected void createEditVatButton() {
        $objectMap.put("editVatButton", editVatButton = new JButton());
        
        editVatButton.setName("editVatButton");
        editVatButton.setText(_("lima.reports.vat"));
        editVatButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editVatButton"));
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
        fiscalPeriodLabel.setText(_("lima.charts.fiscalyear"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new VatReportViewHandler(this));
    }

    protected void createModelFiscalPeriod() {
        $objectMap.put("modelFiscalPeriod", modelFiscalPeriod = new FiscalPeriodComboBoxModel());
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxDatesEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createVatReportTable() {
        $objectMap.put("vatReportTable", vatReportTable = new VatReportTable(getHandler()));
        
        vatReportTable.setName("vatReportTable");
        vatReportTable.setRowHeight(22);
        vatReportTable.setSortable(false);
    }

    protected void createVatReportTableModel() {
        $objectMap.put("vatReportTableModel", vatReportTableModel = new VatReportTableModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(fiscalPeriodLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(periodComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($VatReportPeriodSearchPanel0, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(autocomplete, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(editVatButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 11, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(vatReportTable);
        
        // apply 2 property setters
        vatReportTable.setModel(getVatReportTableModel());
        vatReportTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        periodSearchPanel = new VatReportPeriodSearchPanel(handler);
        createFiscalPeriodLabel();
        createModelFiscalPeriod();
        createPeriodComboBox();
        // inline creation of $VatReportPeriodSearchPanel0
        $objectMap.put("$VatReportPeriodSearchPanel0", $VatReportPeriodSearchPanel0 = periodSearchPanel);
        
        $VatReportPeriodSearchPanel0.setName("$VatReportPeriodSearchPanel0");
        createAutocomplete();
        createEditVatButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createVatReportTableModel();
        createVatReportTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getVatReportTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}