/*
 * #%L
 * Lima :: Swing
 * 
 * $Id: VatChartViewHandler.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/vatchart/VatChartViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.vatchart;

import static org.nuiton.i18n.I18n._;

import java.math.BigDecimal;

import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.VatStatementServiceMonitorable;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.entity.VatStatementImpl;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.enums.VatStatementsChartEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.importexport.ImportExport;
import org.jdesktop.swingx.JXTreeTable;

public class VatChartViewHandler implements ServiceListener {

    /** log. */
    private static final Log log = LogFactory.getLog(VatChartViewHandler.class);

    protected VatStatementServiceMonitorable vatStatementService;
    
    protected VatChartView view;

    protected VatChartViewHandler(VatChartView view) {
        this.view = view;
        
        vatStatementService =
            LimaServiceFactory.getInstance().getService(
                    VatStatementServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
    }
    
    public void addVatStatementMovement(){

        VatChartTreeTableModel treeTableModel =
            (VatChartTreeTableModel) view.getTreeTable().getTreeTableModel();
        
        int selectedRow = view.getTreeTable().getSelectedRow();
        // get current selection path
        TreePath treePath = null;
        if (selectedRow == -1) {
            treePath = null;
        } else {
            treePath = view.getTreeTable().getPathForRow(selectedRow);
        }

        VatStatement newVatChartMovement = new VatStatementImpl();
        VatChartMovementForm vatChartMovementForm =
            new VatChartMovementForm(view);
        VatStatement masterVatStatement = null;
        if (selectedRow != -1) {
            masterVatStatement = (VatStatement)treePath.getLastPathComponent();
        }
        newVatChartMovement.setMasterVatStatement(masterVatStatement);
        vatChartMovementForm.setVatStatement(newVatChartMovement);
        // jaxx constructor don't call super() ?
        vatChartMovementForm.setLocationRelativeTo(view);
        vatChartMovementForm.setVisible(true);
        newVatChartMovement = vatChartMovementForm.getVatStatement();
        
         // null == cancel action
         if (newVatChartMovement != null) {
             newVatChartMovement.setAmount(BigDecimal.ZERO);
             // add it
             try {
                 treeTableModel.addVatStatement(treePath, newVatChartMovement);
            } catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add Vat chart Movement", eee);
                }
                JOptionPane.showMessageDialog(
                        view,
                        eee.getMessage(),
                        _("lima.common.error"),
                        JOptionPane.ERROR_MESSAGE);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add Vat chart Movement", eee);
                }
                JOptionPane.showMessageDialog(
                        view,
                        eee.getMessage(),
                        _("lima.common.error"),
                        JOptionPane.ERROR_MESSAGE);
            }
            refresh();
        }
    }
    
    public void updateVatStatement() {
        
        JXTreeTable treeTable = view.getTreeTable();
        VatChartTreeTableModel treeTableModel =
            (VatChartTreeTableModel) treeTable.getTreeTableModel();

       // get selected account
       int selectedRow = view.treeTable.getSelectedRow();
       TreePath treePath = view.treeTable.getPathForRow(selectedRow); // not null
       VatStatement vatStatement =
           (VatStatement) treePath.getLastPathComponent();   
       //update Account or update SubLedger
       if (vatStatement != null) {
           // get current selection path
           if ( selectedRow != -1) {
               treePath = view.treeTable.getPathForRow(selectedRow);
           } else {
               treePath = new TreePath(treeTableModel.getRoot());
           }
           VatChartMovementForm vatChartMovementForm =
               new VatChartMovementForm(view);
           if (vatStatement.getMasterVatStatement() == null) {
               VatStatement masterVatStatement = new VatStatementImpl();
               vatStatement.setMasterVatStatement(masterVatStatement);
           }
           vatChartMovementForm.setVatStatement(vatStatement);
           // jaxx constructor don't call super() ?
           vatChartMovementForm.setLocationRelativeTo(view);
           vatChartMovementForm.setVisible(true);
           // null == cancel action
           vatStatement = vatChartMovementForm.getVatStatement();
           //if action confirmed
           if (vatStatement != null){
               // update it
               try {
                   treeTableModel.updateVatStatement(
                           treePath, vatStatement);
               } catch (LimaException eee) {
                   if (log.isErrorEnabled()) {
                       log.error("Can't add update", eee);
                   }
                   JOptionPane.showMessageDialog(
                           view,
                           eee.getMessage(),
                           _("lima.common.error"),
                           JOptionPane.ERROR_MESSAGE);
               }
           }
       }
        refresh();
    }
    
    public void importVatStatementChart(){
        VatChartImportForm form =
            new VatChartImportForm(); 
        form.setLocationRelativeTo(view);
        form.setVisible(true);

        Object value = form.getRadioButtons().getSelectedValue();
        // if action confirmed
        if (value != null){
            if (form.getDeleteVatStatementChart().isSelected()){
                try {
                    vatStatementService.removeAllVatStatement();
                    
                } catch (LimaException eee) {
                    if (log.isDebugEnabled()){
                        log.debug("Can't delete financial statement chart", eee);
                    }
                }
            }
            VatStatementsChartEnum defaultVatStatementsEnum = 
                (VatStatementsChartEnum) value;
            ImportExport importExport = ImportExport.getInstance(view);
            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT,
                    defaultVatStatementsEnum.getFilePath(), true);
            refresh();
        }
    }
    
    /**
     * Ask for user to remove for selected account, and remove it if confirmed.
     */
    public void removeVatStatement() {
         JXTreeTable treeTable = view.getTreeTable();
         VatChartTreeTableModel treeTableModel =
             (VatChartTreeTableModel) treeTable.getTreeTableModel();

        // Any row selected
        int selectedRow = view.treeTable.getSelectedRow();
        if ( selectedRow != -1) {
            int n = JOptionPane.showConfirmDialog(view,
                    _("lima.charts.vatstatement.question.remove"),
                    _("lima.common.confirmation"),
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
            if (n == JOptionPane.YES_OPTION) {
                // update view of treetable
                TreePath treePath = treeTable.getPathForRow(selectedRow);
                VatStatement vatStatement =
                    (VatStatement) treePath.getLastPathComponent();
                if (!treeTableModel.isLeaf(vatStatement)) {
                    JOptionPane.showMessageDialog(
                            view,
                            _("lima.charts.vatstatement.deleteparent"),
                            _("lima.common.info"),
                            JOptionPane.INFORMATION_MESSAGE);
                } else {
                    try{
                        treeTableModel.removeVatStatementObject(
                                treePath, vatStatement);
                    } catch (LimaException eee) {
                        if (log.isErrorEnabled()) {
                            log.error("Can't delete account", eee);
                        }
                        JOptionPane.showMessageDialog(
                                view,
                                eee.getMessage(),
                                _("lima.common.error"),
                                JOptionPane.ERROR_MESSAGE);
                    }
                }
            }
            refresh();
        }
    }
    
    public void refresh(){
        JXTreeTable treeTable = view.getTreeTable();
        VatChartTreeTableModel treeTableModel =
            (VatChartTreeTableModel) treeTable.getTreeTableModel();
        try {
            treeTableModel.refreshTree();
        } catch (LimaException eee) {
            if(log.isDebugEnabled()){
                log.debug("Can't refresh model", eee);
            }
        }
        //refresh view
        view.repaint();
    }

	@Override
	public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("VatStatements")
                || methodeName.contains("importAll")
                || methodeName.contains("importAs")){
            refresh();
        }		
	}

    
}
