/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.opening;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.opening.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class CreateIdentityPanel extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_IDENTITY = "identity";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADDRESS2_TEXT_FIELD_TEXT = "address2TextField.text";
    public static final String BINDING_ADDRESS_TEXT_FIELD_TEXT = "addressTextField.text";
    public static final String BINDING_BUSINESS_NUMBER_TEXT_FIELD_TEXT = "businessNumberTextField.text";
    public static final String BINDING_CITY_TEXT_FIELD_TEXT = "cityTextField.text";
    public static final String BINDING_CLASSIFICATION_CODE_TEXT_FIELD_TEXT = "classificationCodeTextField.text";
    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_EMAIL_TEXT_FIELD_TEXT = "emailTextField.text";
    public static final String BINDING_NAME_TEXT_FIELD_TEXT = "nameTextField.text";
    public static final String BINDING_PHONE_NUMBER_TEXT_FIELD_TEXT = "phoneNumberTextField.text";
    public static final String BINDING_VAT_NUMBER_TEXT_FIELD_TEXT = "vatNumberTextField.text";
    public static final String BINDING_ZIP_CODE_TEXT_FIELD_TEXT = "zipCodeTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVTU8TQRjHp1VeCuILagWBiArxYNwiCEjAtxQJYH1Fo7EHne6O7Zh9GWdncfVg/Ah+BL17MfHmyXjw7MGL8SsY48Gr8Zltt6Uwq0uGw9LOPP/f85+ns8/z9gfq8Dk6+hiHocEDV1CHGKuX7t27XnlMTLFIfJNTJjyO6n+ZLMqWUa/VXPcFOl4uSXmhIS8UPYd5LnE3qOdLqMcXz2zi1wgRAo20K0zfL6w1t+dDFvCY2jSlor7+9TP7ynr5JotQyMDdOBxl9H+q1kl2llCWWgL1Q6Z1XLCxWwUbnLpV8Nsn14o29v1r2CFP0AvUVUKdDHOACXQs/ZEjRqQPmUDdY6s3sEvsCYEMj1cNs+Zx4hg2dbARUMNjxIX8RpETLMiKBUgqnkUKxiJKp0BdNexaNuECnVQgaENkxOrlenRL3x2HCHRkM2CTdkPSsdu4YhPwPdBWYf+p9BvtychcK8vYaglXopP2y1qGjdD6qgzqb8b2uVDj2yQUS5TY8Ivk2wTNjXZRz9iiZwYOGIUUgxsVAgRGvMm2ODotvx9qhx2IrzT13LZ8h5OSRpSRrfRJBX0vtixOfD8deTKBPKUg72uQJ9OhpxLQZ1Smn1NW9CySjnwmgTytIPeZcLXSYacTsDMK7KFK4FMXinEtcCqEp0swk5BgVpGgfx2L7bBnE9hnFewhU/YJ+oiaWN7B9IU/m5BkTnXLWQ3a1HaOMLeJnovfoQkFfjdxMLX/Be5tvT4TMZmjobaOAtPAaE2DVrvOlFEHD2AZWlB56wC5BVv10TGwaXRIYLT7J7//64fv75fieZGH3AeVoRvGHfRxxqEvc0Fl6j31YREIaheuYjZfRjmf2DAro1k4rDC21tgGc5Bvn5QbUm4sY78GiI6ubx8/5R9+2YGyS6jH9rC1hGX8CsqJGrzbNc+2QnbhYuRo19NueO6V3gTaKRsdXMsF6tpw8UexgOlVCQQ5H0IZhhVlaHqp5D7/3r/27mJcigxYG0wMb5Wj4z7qrGeLhmdjLiqHZS/zSWB5rfmnmogZ+T/PGhfsQfQ0t55VLsNd2L1gYYFHK9S1oM/DKeV6NbIvP9EobjAdTT4eqQlH0hMcNeGotodxbQ8ntD2c1PZwStvDaW0PU9oeZrU9zGl7OKft4YK2h6K2h8vaHla0PVzR9nBd28NNbQ93tD3cBcJf19IJNAAOAAA=";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    public static final String PROPERTY$DOCUMENT5 = "$Document5";
    public static final String PROPERTY$DOCUMENT6 = "$Document6";
    public static final String PROPERTY$DOCUMENT7 = "$Document7";
    public static final String PROPERTY$DOCUMENT8 = "$Document8";
    public static final String PROPERTY$DOCUMENT9 = "$Document9";
    public static final String PROPERTY$DOCUMENT10 = "$Document10";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.opening.CreateIdentityPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextField address2TextField;
    protected javax.swing.JTextField addressTextField;
    protected javax.swing.JTextField businessNumberTextField;
    protected javax.swing.JTextField cityTextField;
    protected javax.swing.JTextField classificationCodeTextField;
    protected javax.swing.JTextField descriptionTextField;
    protected javax.swing.JTextField emailTextField;
    protected org.chorem.lima.ui.identity.IdentityHandler handler;
    protected org.chorem.lima.entity.Identity identity;
    protected javax.swing.JTextField nameTextField;
    protected javax.swing.JTextField phoneNumberTextField;
    protected javax.swing.JTextField vatNumberTextField;
    protected javax.swing.JTextField zipCodeTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CreateIdentityPanel $JPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.text.Document $Document1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.text.Document $Document2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.text.Document $Document3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.text.Document $Document4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.text.Document $Document5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.text.Document $Document6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.text.Document $Document7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.text.Document $Document8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.text.Document $Document9;
    private javax.swing.JLabel $JLabel10;
    private javax.swing.text.Document $Document10;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateIdentityPanel() {
        $initialize();
    }

    public CreateIdentityPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document10(javax.swing.event.DocumentEvent event) {
        getIdentity().setEmail(getEmailTextField().getText());
    }

    public void doRemoveUpdate__on__$Document10(javax.swing.event.DocumentEvent event) {
        getIdentity().setEmail(getEmailTextField().getText());
    }

    public void doInsertUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getIdentity().setAddress(getAddressTextField().getText());
    }

    public void doRemoveUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getIdentity().setAddress(getAddressTextField().getText());
    }

    public void doInsertUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getIdentity().setDescription(getDescriptionTextField().getText());
    }

    public void doRemoveUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getIdentity().setDescription(getDescriptionTextField().getText());
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getIdentity().setName(getNameTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getIdentity().setName(getNameTextField().getText());
    }

    public void doInsertUpdate__on__$Document6(javax.swing.event.DocumentEvent event) {
        getIdentity().setBusinessNumber(getBusinessNumberTextField().getText());
    }

    public void doRemoveUpdate__on__$Document6(javax.swing.event.DocumentEvent event) {
        getIdentity().setBusinessNumber(getBusinessNumberTextField().getText());
    }

    public void doInsertUpdate__on__$Document5(javax.swing.event.DocumentEvent event) {
        getIdentity().setCity(getCityTextField().getText());
    }

    public void doRemoveUpdate__on__$Document5(javax.swing.event.DocumentEvent event) {
        getIdentity().setCity(getCityTextField().getText());
    }

    public void doInsertUpdate__on__$Document4(javax.swing.event.DocumentEvent event) {
        getIdentity().setZipCode(getZipCodeTextField().getText());
    }

    public void doRemoveUpdate__on__$Document4(javax.swing.event.DocumentEvent event) {
        getIdentity().setZipCode(getZipCodeTextField().getText());
    }

    public void doInsertUpdate__on__$Document3(javax.swing.event.DocumentEvent event) {
        getIdentity().setAddress2(getAddress2TextField().getText());
    }

    public void doRemoveUpdate__on__$Document3(javax.swing.event.DocumentEvent event) {
        getIdentity().setAddress2(getAddress2TextField().getText());
    }

    public void doInsertUpdate__on__$Document9(javax.swing.event.DocumentEvent event) {
        getIdentity().setPhoneNumber(getPhoneNumberTextField().getText());
    }

    public void doRemoveUpdate__on__$Document9(javax.swing.event.DocumentEvent event) {
        getIdentity().setPhoneNumber(getPhoneNumberTextField().getText());
    }

    public void doInsertUpdate__on__$Document8(javax.swing.event.DocumentEvent event) {
        getIdentity().setClassificationCode(getClassificationCodeTextField().getText());
    }

    public void doRemoveUpdate__on__$Document8(javax.swing.event.DocumentEvent event) {
        getIdentity().setClassificationCode(getClassificationCodeTextField().getText());
    }

    public void doInsertUpdate__on__$Document7(javax.swing.event.DocumentEvent event) {
        getIdentity().setVatNumber(getVatNumberTextField().getText());
    }

    public void doRemoveUpdate__on__$Document7(javax.swing.event.DocumentEvent event) {
        getIdentity().setVatNumber(getVatNumberTextField().getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextField getAddress2TextField() {
        return address2TextField;
    }

    public javax.swing.JTextField getAddressTextField() {
        return addressTextField;
    }

    public javax.swing.JTextField getBusinessNumberTextField() {
        return businessNumberTextField;
    }

    public javax.swing.JTextField getCityTextField() {
        return cityTextField;
    }

    public javax.swing.JTextField getClassificationCodeTextField() {
        return classificationCodeTextField;
    }

    public javax.swing.JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public javax.swing.JTextField getEmailTextField() {
        return emailTextField;
    }

    public org.chorem.lima.ui.identity.IdentityHandler getHandler() {
        return handler;
    }

    public org.chorem.lima.entity.Identity getIdentity() {
        return identity;
    }

    public javax.swing.JTextField getNameTextField() {
        return nameTextField;
    }

    public javax.swing.JTextField getPhoneNumberTextField() {
        return phoneNumberTextField;
    }

    public javax.swing.JTextField getVatNumberTextField() {
        return vatNumberTextField;
    }

    public javax.swing.JTextField getZipCodeTextField() {
        return zipCodeTextField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$Document1(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document1;
        this.$Document1 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, newValue);
    }

    public void set$Document2(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document2;
        this.$Document2 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, newValue);
    }

    public void set$Document3(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document3;
        this.$Document3 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, newValue);
    }

    public void set$Document4(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document4;
        this.$Document4 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, newValue);
    }

    public void set$Document5(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document5;
        this.$Document5 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT5, oldValue, newValue);
    }

    public void set$Document6(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document6;
        this.$Document6 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT6, oldValue, newValue);
    }

    public void set$Document7(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document7;
        this.$Document7 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT7, oldValue, newValue);
    }

    public void set$Document8(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document8;
        this.$Document8 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT8, oldValue, newValue);
    }

    public void set$Document9(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document9;
        this.$Document9 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT9, oldValue, newValue);
    }

    public void set$Document10(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document10;
        this.$Document10 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT10, oldValue, newValue);
    }

    public void setHandler(org.chorem.lima.ui.identity.IdentityHandler newValue) {
        org.chorem.lima.ui.identity.IdentityHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setIdentity(org.chorem.lima.entity.Identity newValue) {
        org.chorem.lima.entity.Identity oldValue = this.identity;
        this.identity = newValue;
        firePropertyChange(PROPERTY_IDENTITY, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.text.Document get$Document1() {
        return $Document1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.text.Document get$Document2() {
        return $Document2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.text.Document get$Document3() {
        return $Document3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.text.Document get$Document4() {
        return $Document4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.text.Document get$Document5() {
        return $Document5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.text.Document get$Document6() {
        return $Document6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.text.Document get$Document7() {
        return $Document7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.text.Document get$Document8() {
        return $Document8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.text.Document get$Document9() {
        return $Document9;
    }

    protected javax.swing.JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected javax.swing.text.Document get$Document10() {
        return $Document10;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddress2TextField() {
        $objectMap.put("address2TextField", address2TextField = new javax.swing.JTextField());
        
        address2TextField.setName("address2TextField");
        address2TextField.setColumns(15);
    }

    protected void createAddressTextField() {
        $objectMap.put("addressTextField", addressTextField = new javax.swing.JTextField());
        
        addressTextField.setName("addressTextField");
        addressTextField.setColumns(15);
    }

    protected void createBusinessNumberTextField() {
        $objectMap.put("businessNumberTextField", businessNumberTextField = new javax.swing.JTextField());
        
        businessNumberTextField.setName("businessNumberTextField");
        businessNumberTextField.setColumns(15);
    }

    protected void createCityTextField() {
        $objectMap.put("cityTextField", cityTextField = new javax.swing.JTextField());
        
        cityTextField.setName("cityTextField");
        cityTextField.setColumns(15);
    }

    protected void createClassificationCodeTextField() {
        $objectMap.put("classificationCodeTextField", classificationCodeTextField = new javax.swing.JTextField());
        
        classificationCodeTextField.setName("classificationCodeTextField");
        classificationCodeTextField.setColumns(15);
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new javax.swing.JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createEmailTextField() {
        $objectMap.put("emailTextField", emailTextField = new javax.swing.JTextField());
        
        emailTextField.setName("emailTextField");
        emailTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new org.chorem.lima.ui.identity.IdentityHandler());
    }

    protected void createIdentity() {
        $objectMap.put("identity", identity = handler.getIdentity());
    }

    protected void createNameTextField() {
        $objectMap.put("nameTextField", nameTextField = new javax.swing.JTextField());
        
        nameTextField.setName("nameTextField");
        nameTextField.setColumns(15);
    }

    protected void createPhoneNumberTextField() {
        $objectMap.put("phoneNumberTextField", phoneNumberTextField = new javax.swing.JTextField());
        
        phoneNumberTextField.setName("phoneNumberTextField");
        phoneNumberTextField.setColumns(15);
    }

    protected void createVatNumberTextField() {
        $objectMap.put("vatNumberTextField", vatNumberTextField = new javax.swing.JTextField());
        
        vatNumberTextField.setName("vatNumberTextField");
        vatNumberTextField.setColumns(15);
    }

    protected void createZipCodeTextField() {
        $objectMap.put("zipCodeTextField", zipCodeTextField = new javax.swing.JTextField());
        
        zipCodeTextField.setName("zipCodeTextField");
        zipCodeTextField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(address2TextField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cityTextField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel6, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel7, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberTextField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel8, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel9, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel10, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailTextField, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createHandler();
        createIdentity();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.identity.name"));
        createNameTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getNameTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.identity.description"));
        createDescriptionTextField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getDescriptionTextField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.identity.address"));
        createAddressTextField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = getAddressTextField().getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("lima.identity.address2"));
        createAddress2TextField();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = getAddress2TextField().getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("lima.identity.zipCode"));
        createZipCodeTextField();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = getZipCodeTextField().getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("lima.identity.city"));
        createCityTextField();
        // inline creation of $Document5
        $objectMap.put("$Document5", $Document5 = getCityTextField().getDocument());
        
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document5"));
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document5"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("lima.identity.businessNumber"));
        createBusinessNumberTextField();
        // inline creation of $Document6
        $objectMap.put("$Document6", $Document6 = getBusinessNumberTextField().getDocument());
        
        $Document6.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document6"));
        $Document6.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document6"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("lima.identity.vatNumber"));
        createVatNumberTextField();
        // inline creation of $Document7
        $objectMap.put("$Document7", $Document7 = getVatNumberTextField().getDocument());
        
        $Document7.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document7"));
        $Document7.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document7"));
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new javax.swing.JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("lima.identity.classificationCode"));
        createClassificationCodeTextField();
        // inline creation of $Document8
        $objectMap.put("$Document8", $Document8 = getClassificationCodeTextField().getDocument());
        
        $Document8.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document8"));
        $Document8.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document8"));
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new javax.swing.JLabel());
        
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("lima.identity.phoneNumber"));
        createPhoneNumberTextField();
        // inline creation of $Document9
        $objectMap.put("$Document9", $Document9 = getPhoneNumberTextField().getDocument());
        
        $Document9.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document9"));
        $Document9.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document9"));
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new javax.swing.JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(_("lima.identity.email"));
        createEmailTextField();
        // inline creation of $Document10
        $objectMap.put("$Document10", $Document10 = getEmailTextField().getDocument());
        
        $Document10.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document10"));
        $Document10.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document10"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(nameTextField, getIdentity().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(descriptionTextField, getIdentity().getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADDRESS_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("address", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(addressTextField, getIdentity().getAddress());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("address", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADDRESS2_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("address2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(address2TextField, getIdentity().getAddress2());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("address2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZIP_CODE_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("zipCode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(zipCodeTextField, getIdentity().getZipCode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("zipCode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CITY_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("city", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(cityTextField, getIdentity().getCity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("city", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSINESS_NUMBER_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("businessNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(businessNumberTextField, getIdentity().getBusinessNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("businessNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VAT_NUMBER_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("vatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(vatNumberTextField, getIdentity().getVatNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("vatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLASSIFICATION_CODE_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("classificationCode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(classificationCodeTextField, getIdentity().getClassificationCode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("classificationCode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PHONE_NUMBER_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("phoneNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(phoneNumberTextField, getIdentity().getPhoneNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("phoneNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("email", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    jaxx.runtime.SwingUtil.setText(emailTextField, getIdentity().getEmail());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("email", this);
                }
            }
        });
    }

}