/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.Date;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedViewHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class FinancialTransactionUnbalancedTable
extends JXTable
implements KeyListener {
    private static final long serialVersionUID = 3133690382049594727L;
    protected FinancialTransactionUnbalancedViewHandler handler;
    private Highlighter colorTransaction;
    private ColorHighlighter colorBalance;

    public FinancialTransactionUnbalancedTable(FinancialTransactionUnbalancedViewHandler handler) {
        this.handler = handler;
        this.addKeyListener(this);
        this.setDefaultEditor(Date.class, new DateTableCellEditor());
        this.setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        this.setDefaultEditor(Account.class, new AccountTableCellEditor());
        this.addColorTransaction();
        this.addColorNonBalancedTransaction();
    }

    protected void addColorTransaction() {
        if (this.colorTransaction != null) {
            this.removeHighlighter(this.colorTransaction);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return adapter.getValueAt(adapter.row, 0) instanceof Date;
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        this.addHighlighter(this.colorTransaction);
    }

    protected void addColorNonBalancedTransaction() {
        if (this.colorBalance != null) {
            this.removeHighlighter((Highlighter)this.colorBalance);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                BigDecimal currentBalance;
                boolean isHighlighted = false;
                Object value = adapter.getValueAt(adapter.row, 8);
                if (value instanceof BigDecimal && (currentBalance = (BigDecimal)value).doubleValue() != 0.0) {
                    isHighlighted = true;
                }
                return isHighlighted;
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, new Color(255, 198, 209), null);
        this.addHighlighter(this.colorTransaction);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 || e.getKeyCode() == 12 && e.getModifiers() == 2) {
            this.handler.deleteSelectedRow();
        }
        if (e.getKeyCode() == 155 || e.getKeyCode() == 10 && e.getModifiers() == 2) {
            this.handler.addEmptyEntry();
        }
        if (e.getKeyChar() == '\t') {
            int x = this.getSelectedColumn();
            int y = this.getSelectedRow();
            int max_x = this.getColumnCount() - 1;
            int max_y = this.getRowCount() - 1;
            if (x == max_x && y == max_y) {
                this.handler.addEmptyEntry();
                this.setColumnSelectionInterval(0, 0);
                this.setRowSelectionInterval(max_y + 1, max_y + 1);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

