/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.utils.DailySortedMap;

public class TimerTask
implements Cloneable,
Comparable<TimerTask>,
Serializable {
    private static final long serialVersionUID = -7590755569706702695L;
    protected String uuid = UUID.randomUUID().toString();
    protected int number = -1;
    protected String name;
    protected Date creationDate;
    protected boolean closed;
    protected TimerTask parent;
    protected SortedMap<Date, Long> allDaysTimes = new DailySortedMap<Long>();
    protected SortedMap<Date, String> allDaysAnnotations = new TreeMap<Date, String>();
    protected List<TimerTask> subTasks = new ArrayList<TimerTask>();
    protected List<TimerAlert> alerts = new ArrayList<TimerAlert>();

    public TimerTask() {
    }

    public TimerTask(String name) {
        this();
        this.name = name;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public TimerTask getParent() {
        return this.parent;
    }

    protected void setParent(TimerTask parent) {
        if (parent == this) {
            throw new IllegalArgumentException("Parent can't be current task");
        }
        this.parent = parent;
    }

    public List<TimerTask> getSubTasks() {
        return this.subTasks;
    }

    public boolean addTask(TimerTask t) {
        t.setParent(this);
        boolean result = this.subTasks.add(t);
        return result;
    }

    public void setTime(Date date, Long time) {
        this.allDaysTimes.put(date, time);
    }

    public long getTime(Date date) {
        long result = 0L;
        Long t = (Long)this.allDaysTimes.get(date);
        if (t != null) {
            result = t;
        }
        return result;
    }

    public SortedMap<Date, Long> getAllDaysAndTimes() {
        return this.allDaysTimes;
    }

    public void addAnnotation(Date date, String note) {
        this.allDaysAnnotations.put(date, note);
    }

    public SortedMap<Date, String> getAllDaysAnnotations() {
        return this.allDaysAnnotations;
    }

    public void addAlert(TimerAlert alert) {
        this.alerts.add(alert);
    }

    public List<TimerAlert> getAlerts() {
        return this.alerts;
    }

    public void setAlert(List<TimerAlert> alerts) {
        this.alerts = alerts;
    }

    public String toString() {
        return this.name + this.subTasks.toString();
    }

    public int hashCode() {
        int result = this.uuid.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimerTask)) {
            return false;
        }
        return this.uuid.equals(((TimerTask)o).uuid);
    }

    public TimerTask clone() {
        TimerTask task;
        try {
            task = (TimerTask)super.clone();
            task.creationDate = this.creationDate == null ? null : (Date)this.creationDate.clone();
            task.allDaysTimes = new DailySortedMap<Long>(this.allDaysTimes);
            task.allDaysAnnotations = new TreeMap<Date, String>(this.allDaysAnnotations);
            task.subTasks = new ArrayList<TimerTask>(this.subTasks);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Can't clone", e);
        }
        return task;
    }

    @Override
    public int compareTo(TimerTask o) {
        int result = this.getName() == null ? -1 : (o.getName() == null ? 1 : this.getName().compareTo(o.getName()));
        return result;
    }
}

