/*
 * #%L
 * jTimer
 * 
 * $Id: ProjectsAndTasksTable.java 2938 2013-09-24 07:36:39Z tchemit $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin, Chatellier Eric, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.jtimer.ui.treetable;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.treetable.dnd.TimerTaskTransferHandler;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTreeTable;

/**
 * ProjectAndTaskTable.
 * 
 * Just redefine JXTreeTable setting up a specific model
 * 
 * @see org.jdesktop.swingx.JXTreeTable
 * 
 * @author chatellier
 * @version $Revision: 2938 $
 * 
 * Last update : $Date: 2013-09-24 09:36:39 +0200 (Tue, 24 Sep 2013) $
 * By : $Author: tchemit $
 */
public class ProjectsAndTasksTable extends JXTreeTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -6909972377431117193L;

    /** Table model. */
    protected ProjectsAndTasksModel treeTableModel;

    /** Table renderer. */
    protected ProjectsAndTasksCellRenderer treeCellRenderer;

    /**
     * Constructor.
     * 
     * @param application application
     * @param core timer core
     */
    public ProjectsAndTasksTable(Application application, TimerCore core) {

        // start with init i18n of table column name
        ApplicationContext ctxt = application.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        ResourceMap resourceMap = mgr
                .getResourceMap(ProjectsAndTasksTable.class);
        // init list
        List<String> columnIdentifiers = new ArrayList<String>();
        columnIdentifiers.add(resourceMap
                .getString("projectsAndTaskColumnName"));
        columnIdentifiers.add(resourceMap.getString("todayTimeColumnName"));
        columnIdentifiers.add(resourceMap.getString("totalTimeColumnName"));

        // set model
        treeTableModel = new ProjectsAndTasksModel(this, core, columnIdentifiers);

        // set renderer
        treeCellRenderer = new ProjectsAndTasksCellRenderer(this, core);

        setTreeCellRenderer(treeCellRenderer);
        setTreeTableModel(treeTableModel);

        // hack (work for white based theme)
        // swingx bug : https://swingx.dev.java.net/issues/show_bug.cgi?id=964
        setBackground(Color.WHITE);

        //treeTableModel.setSortColumn("Projects & Tasks");
        core.getData().addDataEventListener(treeTableModel);

        // enable drag n drop
        setDragEnabled(true);
        setTransferHandler(new TimerTaskTransferHandler(application, core.getData()));

        { // add action to collapse (left arrow) selected node
            Action action = new AbstractAction("collapseSelectedNode") {
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedRow = getSelectedRow();
                    if (selectedRow != -1) {
                        collapseRow(selectedRow);
                    }
                }
            };

            getInputMap(WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(
                    KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 0),
                    action.getValue(Action.NAME));
            getActionMap().put(action.getValue(Action.NAME), action);
        }
        { // add action to expand (right arrow) selected node
            Action action = new AbstractAction("expandSelectedNode") {
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedRow = getSelectedRow();
                    if (selectedRow != -1) {
                        expandRow(selectedRow);
                    }
                }
            };

            getInputMap(WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(
                    KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 0),
                    action.getValue(Action.NAME));
            getActionMap().put(action.getValue(Action.NAME), action);
        }
    }

    /**
     * Change show closed task property.
     * 
     * @param closed new closed state
     * 
     * @see ProjectsAndTasksModel#setShowClosed(boolean)
     */
    public void setShowClosed(boolean closed) {
        treeTableModel.setShowClosed(closed);
    }

    /**
     * Get tasks corresponding to selected rows
     * 
     * @return tasks list (never <tt>null</tt>)
     */
    public List<TimerTask> getSelectedTasks() {

        List<TimerTask> results = new ArrayList<TimerTask>();

        // oula, c long de retouver la tache selectionnee
        TreePath[] paths = getTreeSelectionModel().getSelectionPaths();

        if (paths != null) {
            for (TreePath path : paths) {

                // s'il y a une selection...
                if (path != null) {
                    Object[] pathWay = path.getPath();

                    if (pathWay.length >= 3) { // 1 = root, 2=project , 3+=task
                        // le last en la derniere feuille selmectionnee, donc la
                        // tache
                        TimerTask task = (TimerTask) pathWay[pathWay.length - 1];

                        results.add(task);
                    }
                }
            }
        }
        return results;
    }

    /**
     * Get tasks or projects corresponding to selected rows
     * 
     * @return project or task list (never <tt>null</tt>)
     */
    public List<TimerTask> getSelectedElements() {

        List<TimerTask> results = new ArrayList<TimerTask>();

        // oula, c long de retouver la tache selectionnee
        TreePath[] paths = getTreeSelectionModel().getSelectionPaths();

        if (paths != null) {
            for (TreePath path : paths) {

                // s'il y a une selection...
                if (path != null) {
                    Object[] pathWay = path.getPath();

                    if (pathWay.length >= 2) { // 1 = root, 2=project , 3+=task
                        // le last est la derniere feuille selectionnee, donc la
                        // tache
                        TimerTask task = (TimerTask) pathWay[pathWay.length - 1];

                        results.add(task);
                    }
                }
            }
        }
        return results;
    }

    /**
     * Get projects corresponding to selected rows.
     * 
     * @return projects list (never <tt>null</tt>)
     */
    public List<TimerProject> getSelectedProjects() {

        List<TimerProject> results = new ArrayList<TimerProject>();

        // oula, c long de retouver la tache selectionnee
        TreePath[] paths = getTreeSelectionModel().getSelectionPaths();

        if (paths != null) {
            for (TreePath path : paths) {

                // s'il y a une selection...
                if (path != null) {
                    Object[] pathWay = path.getPath();

                    if (pathWay.length == 2) { // 1 = root, 2=project , 3+=task
                        // le last est la derniere feuille selectionnee, donc la
                        // tache
                        TimerProject project = (TimerProject) pathWay[pathWay.length - 1];

                        results.add(project);
                    }
                }
            }
        }

        return results;
    }
}
