/*
 * #%L
 * jTimer
 * 
 * $Id: User32.java 2892 2013-01-30 09:33:44Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2011 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.jtimer.ui.system.win32;

import java.util.Arrays;
import java.util.List;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;

/**
 * Win User32 JNA Interface.
 * 
 * TODO it not the same code as jna's User32 class.
 * 
 * @author chatellier
 * @version $Revision: 2892 $
 *
 * @see <a href="http://msdn.microsoft.com/en-us/library/ms646272">Windows API</a>
 * 
 * Last update : $Date: 2013-01-30 10:33:44 +0100 (Wed, 30 Jan 2013) $
 * By : $Author: echatellier $
 */
public interface User32 extends StdCallLibrary {

    /** Instance. */
    User32 INSTANCE = (User32) Native.loadLibrary("user32", User32.class);

    /**
     * Contains the time of the last input.
     */
    class LASTINPUTINFO extends Structure {
        public int cbSize = 8;

        // / Tick count of when the last input event was received.
        public int dwTime;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList(new String[] { "cbSize", "dwTime"});
        }
    }

    /**
     * Retrieves the time of the last input event.
     * 
     * @param result time of the last input event, in milliseconds
     * @return boolean flag
     */
    boolean GetLastInputInfo(LASTINPUTINFO result);
}
