/*
 * #%L
 * jTimer
 * 
 * $Id: TimerProject.java 2778 2011-09-05 08:12:54Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2011 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.jtimer.entities;

/**
 * Represent a project.
 * 
 * @author chatellier
 * @version $Revision: 2778 $
 * 
 * Last update : $Date: 2011-09-05 10:12:54 +0200 (Mon, 05 Sep 2011) $
 * By : $Author: echatellier $
 */
public class TimerProject extends TimerTask {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8953488997256237790L;

    /** Synchronized project name prefix. */
    public static final String SYNCHRONIZED_PROJECT_NAME_PREFIX = "#";

    /**
     * Constructor.
     */
    public TimerProject() {
    }

    /**
     * Constructor with name.
     * 
     * @param name project name
     */
    public TimerProject(String name) {
        super(name);
    }

    /**
     * Is synchronized.
     * 
     * @return the synchronize
     */
    public boolean isSynchronized() {

        boolean sync = false;

        if (name != null && name.startsWith(SYNCHRONIZED_PROJECT_NAME_PREFIX)) {
            sync = true;
        }

        return sync;
    }

    /**
     * Clone project.
     * 
     * @return project copy
     */
    @Override
    public TimerProject clone() {

        // Can't use clone() from super class
        // Result object have to be 
        TimerProject newProject = (TimerProject) super.clone();

        return newProject;
    }
}
