/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.ws;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.entities.ConnectionData;
import org.chorem.jtimer.ws.ConnectionDataHandler;
import org.chorem.jtimer.ws.ProjectManagement;
import org.chorem.jtimer.ws.exception.WebServiceException;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class SwingConnectionInformationHandler
extends Dialog
implements ConnectionDataHandler,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -4178930926937567471L;
    private static Log log = LogFactory.getLog(SwingConnectionInformationHandler.class);
    protected JList list;
    protected JButton okButton;
    protected JButton selectedButton;
    protected LocalStorage localStorage;
    protected ResourceMap resourceMap;

    public SwingConnectionInformationHandler(SingleFrameApplication application) {
        super((Frame)application.getMainFrame(), true);
        this.setName(SwingConnectionInformationHandler.class.getName());
        ApplicationContext ctxt = application.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        this.resourceMap = mgr.getResourceMap(SwingConnectionInformationHandler.class);
        this.localStorage = application.getContext().getLocalStorage();
    }

    protected String getStorageName(String resourceName) {
        return ConnectionDataHandler.class.getName() + "." + resourceName + ".xml";
    }

    @Override
    public ConnectionData getConnectionInformation(ProjectManagement managementService) {
        ConnectionData data = null;
        try {
            data = (ConnectionData)this.localStorage.load(this.getStorageName(managementService.getResourceName()));
            if (data != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("found user connection information  (login=" + data.getLogin() + ")"));
                }
            } else {
                data = this.createNewConnectionInformation(managementService);
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection information not found for current user, ask it", (Throwable)e);
            }
            data = this.createNewConnectionInformation(managementService);
        }
        return data;
    }

    protected ConnectionData createNewConnectionInformation(ProjectManagement managementService) {
        ConnectionData data;
        block4: {
            if (log.isInfoEnabled()) {
                log.info((Object)"Connection information not found for current user, ask it");
            }
            if ((data = this.askUserForInformation(managementService)) != null) {
                try {
                    this.localStorage.save((Object)data, this.getStorageName(managementService.getResourceName()));
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't save info for user", (Throwable)e);
                }
            }
        }
        return data;
    }

    protected ConnectionData askUserForInformation(ProjectManagement managementService) {
        ConnectionData data;
        block4: {
            data = null;
            try {
                LoginListData loginData;
                Map<String, String> idLogins = managementService.getIdAndLoginsMap();
                ArrayList<LoginListData> v = new ArrayList<LoginListData>();
                for (Map.Entry<String, String> entry : idLogins.entrySet()) {
                    v.add(new LoginListData(entry.getValue(), entry.getKey()));
                }
                Collections.sort(v);
                this.buildUI(managementService);
                this.list.setListData(v.toArray());
                this.setVisible(true);
                if (this.okButton.equals(this.selectedButton) && (loginData = (LoginListData)this.list.getSelectedValue()).getId() != null) {
                    data = new ConnectionData();
                    data.setLogin(loginData.getId());
                }
            }
            catch (WebServiceException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't contact remote service", (Throwable)e);
            }
        }
        return data;
    }

    protected void buildUI(ProjectManagement managementService) {
        String title = this.resourceMap.getString("askInformationTitle", new Object[0]);
        this.setTitle(title);
        this.setLayout(new GridBagLayout());
        JLabel labelInfo = new JLabel(this.resourceMap.getString("askInformationMessage", new Object[]{managementService.getResourceName()}));
        this.add((Component)labelInfo, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        JScrollPane jsp = new JScrollPane(this.list);
        this.add((Component)jsp, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.okButton = new JButton(this.resourceMap.getString("ok", new Object[0]));
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 10, 0));
        JButton cancelButton = new JButton(this.resourceMap.getString("cancel", new Object[0]));
        cancelButton.addActionListener(this);
        this.add((Component)cancelButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 10, 0));
        Dimension dim = this.getToolkit().getScreenSize();
        this.setSize(450, 420);
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selectedButton = (JButton)e.getSource();
        this.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.okButton.setEnabled(true);
    }

    protected class LoginListData
    implements Comparable<LoginListData> {
        protected String login;
        protected String id;

        public LoginListData(String login, String id) {
            this.login = login;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.login;
        }

        @Override
        public int compareTo(LoginListData o) {
            return this.login.compareTo(o.login);
        }
    }
}

