/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.tasks;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.chorem.jtimer.ui.system.SystemInfo;
import org.chorem.jtimer.ui.system.SystemInfoFactory;
import org.chorem.jtimer.ui.system.UnsupportedSystemInfoException;
import org.chorem.jtimer.ui.tasks.IdleDialog;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;

public class RunTaskJob
extends Task<Void, Void> {
    private static Log log = LogFactory.getLog(RunTaskJob.class);
    protected JTimer parentApp;
    protected TimerTask managedTask;
    protected TimerDataManager dataManager;
    protected SystemInfo systemInfo;
    protected Collection<TimerAlert> alreadyTrownAlerts;
    protected AtomicLong lastUserActivity;
    protected AtomicBoolean bWantToStop;

    public RunTaskJob(JTimer parentApp, TimerTask managedTask, TimerDataManager dataManager) {
        super((Application)parentApp);
        this.parentApp = parentApp;
        this.bWantToStop = new AtomicBoolean(false);
        this.managedTask = managedTask;
        this.dataManager = dataManager;
        this.alreadyTrownAlerts = new HashSet<TimerAlert>();
        this.checkAlreadyThrownAlerts(managedTask);
        try {
            this.systemInfo = SystemInfoFactory.getSystemInfo();
        }
        catch (UnsupportedSystemInfoException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get system info", (Throwable)e);
            }
            this.systemInfo = null;
        }
    }

    protected void checkAlreadyThrownAlerts(TimerTask task) {
        Date now = new Date();
        for (TimerAlert alert : task.getAlerts()) {
            if (alert.getType().equals((Object)TimerAlert.Type.REACH_DAILY_TIME) && TimerTaskHelper.getTotalTime(task, now) > alert.getDuration()) {
                this.alreadyTrownAlerts.add(alert.clone());
                continue;
            }
            if (!alert.getType().equals((Object)TimerAlert.Type.REACH_TOTAL_TIME) || TimerTaskHelper.getAllTotalTime(task) <= alert.getDuration()) continue;
            this.alreadyTrownAlerts.add(alert.clone());
        }
        if (task.getParent() != null) {
            this.checkAlreadyThrownAlerts(task.getParent());
        }
    }

    public TimerTask getTask() {
        return this.managedTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground() throws Exception {
        this.parentApp.startedTask(this.managedTask);
        this.lastUserActivity = new AtomicLong(System.currentTimeMillis());
        long configIdleTime = JTimer.config.getIdleTime() * 1000L;
        boolean dontWantToStop = true;
        while (dontWantToStop) {
            long oldUserActivity = this.lastUserActivity.getAndSet(System.currentTimeMillis());
            long delta = this.lastUserActivity.get() - oldUserActivity;
            this.addTaskDelta(this.lastUserActivity.get(), delta);
            long idleTime = 0L;
            if (this.systemInfo != null) {
                idleTime = this.systemInfo.getIdleTime();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User is idle since " + idleTime / 1000L + " s"));
                }
            }
            if (delta >= configIdleTime || idleTime >= configIdleTime) {
                long userIdleTime = Math.max(delta, idleTime);
                this.addTaskDelta(this.lastUserActivity.get() + delta, -userIdleTime);
                JTimer parentApplication = (JTimer)this.getApplication();
                parentApplication.preIdleDetect();
                int option = IdleDialog.showIdleDialog(this.lastUserActivity.get() - userIdleTime);
                parentApplication.postIdleDetect();
                oldUserActivity = this.lastUserActivity.getAndSet(System.currentTimeMillis());
                delta = this.lastUserActivity.get() - oldUserActivity;
                switch (option) {
                    case 0: {
                        ((JTimer)this.getApplication()).stopTask(this.managedTask);
                        break;
                    }
                    case 1: {
                        this.addTaskDelta(oldUserActivity - userIdleTime, delta + userIdleTime);
                    }
                }
            }
            Thread.sleep(1000L);
            AtomicBoolean atomicBoolean = this.bWantToStop;
            synchronized (atomicBoolean) {
                dontWantToStop = !this.bWantToStop.get();
            }
        }
        return null;
    }

    protected void addTaskDelta(long from, long delta) {
        long localDelta = delta;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding delta to task : " + delta));
        }
        if (localDelta < 0L) {
            Date currentDate = new Date(from);
            while (localDelta < 0L) {
                Date todayMidnight = DateUtils.truncate((Date)currentDate, (int)5);
                long msToMidnight = currentDate.getTime() - todayMidnight.getTime();
                long toRemove = Math.min(-localDelta, msToMidnight);
                this.dataManager.changeTaskTime(this.managedTask, currentDate, this.managedTask.getTime(currentDate) - toRemove);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" remove delta to task on " + currentDate + " : " + toRemove));
                }
                localDelta += toRemove;
                currentDate = DateUtils.addMilliseconds((Date)todayMidnight, (int)-1);
            }
        } else {
            Date currentDate = new Date(from);
            while (localDelta > 0L) {
                Date today235959 = DateUtils.truncate((Date)currentDate, (int)5);
                today235959 = DateUtils.addDays((Date)today235959, (int)1);
                today235959 = DateUtils.addMilliseconds((Date)today235959, (int)-1);
                long msToMidnight = today235959.getTime() - currentDate.getTime();
                long toAdd = Math.min(localDelta, msToMidnight);
                this.dataManager.changeTaskTime(this.managedTask, currentDate, this.managedTask.getTime(currentDate) + toAdd);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" adding delta to task on " + currentDate + " : " + toAdd));
                }
                localDelta -= toAdd;
                currentDate = DateUtils.addMilliseconds((Date)today235959, (int)1);
            }
        }
        this.checkTaskAlerts(this.managedTask);
    }

    protected void checkTaskAlerts(TimerTask task) {
        Date now = new Date();
        for (TimerAlert alert : task.getAlerts()) {
            if (this.alreadyTrownAlerts.contains(alert)) continue;
            if (alert.getType().equals((Object)TimerAlert.Type.REACH_DAILY_TIME) && TimerTaskHelper.getTotalTime(task, now) >= alert.getDuration()) {
                this.displayAlert(task, TimerAlert.Type.REACH_DAILY_TIME, alert.getDuration());
                this.alreadyTrownAlerts.add(alert.clone());
                continue;
            }
            if (!alert.getType().equals((Object)TimerAlert.Type.REACH_TOTAL_TIME) || TimerTaskHelper.getAllTotalTime(task) < alert.getDuration()) continue;
            this.displayAlert(task, TimerAlert.Type.REACH_TOTAL_TIME, alert.getDuration());
            this.alreadyTrownAlerts.add(alert.clone());
        }
        if (task.getParent() != null) {
            this.checkTaskAlerts(task.getParent());
        }
    }

    protected void displayAlert(final TimerTask task, final TimerAlert.Type alertType, final long alertDuration) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String alertMessage = null;
                String formattedTime = DurationFormatUtils.formatDuration((long)alertDuration, (String)"HH:mm:ss");
                if (TimerAlert.Type.REACH_DAILY_TIME.equals((Object)alertType)) {
                    alertMessage = RunTaskJob.this.getResourceMap().getString("alert.dailyAlertMessage", new Object[]{task.getName(), formattedTime});
                } else if (TimerAlert.Type.REACH_TOTAL_TIME.equals((Object)alertType)) {
                    alertMessage = RunTaskJob.this.getResourceMap().getString("alert.totalAlertMessage", new Object[]{task.getName(), formattedTime});
                }
                JOptionPane.showMessageDialog(null, alertMessage, RunTaskJob.this.getResourceMap().getString("alert.title", new Object[0]), 1, RunTaskJob.this.getResourceMap().getIcon("alert.alertIcon"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantToStop() {
        AtomicBoolean atomicBoolean = this.bWantToStop;
        synchronized (atomicBoolean) {
            this.bWantToStop.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopping() {
        boolean stopping;
        AtomicBoolean atomicBoolean = this.bWantToStop;
        synchronized (atomicBoolean) {
            stopping = this.bWantToStop.get();
        }
        return stopping;
    }
}

