/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.systray;

import java.awt.AWTException;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.widget.JPopupTrayIcon;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;

public class SystrayManager
implements ActionListener,
DataEventListener,
MouseListener,
Runnable,
WindowListener {
    private static Log log = LogFactory.getLog(SystrayManager.class);
    protected JTimer parent;
    protected ResourceMap resourceMap;
    protected Image idleImage;
    protected Image runningImage;
    protected Image idleDetectImage;
    protected JPopupTrayIcon trayIcon;
    protected int nbTasksRunning = 0;
    protected JPopupMenu popup;
    protected JMenuItem showItem;
    protected JMenuItem stopItem;

    public SystrayManager(JTimer parent) {
        this.parent = parent;
        ApplicationContext ctxt = parent.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        this.resourceMap = mgr.getResourceMap(SystrayManager.class);
        this.idleImage = this.resourceMap.getImageIcon("idleImage").getImage();
        this.runningImage = this.resourceMap.getImageIcon("runningImage").getImage();
        this.idleDetectImage = this.resourceMap.getImageIcon("idleDetectImage").getImage();
        this.buildPopupMenu();
    }

    private void buildPopupMenu() {
        this.popup = new JPopupMenu();
        this.showItem = new JMenuItem(this.resourceMap.getString("hideMenuText", new Object[0]));
        this.showItem.addActionListener(this);
        this.showItem.setActionCommand("showHide");
        this.popup.add(this.showItem);
        this.popup.addSeparator();
        this.stopItem = new JMenuItem(this.resourceMap.getString("stopMenuText", new Object[0]));
        this.stopItem.addActionListener(this);
        this.stopItem.setActionCommand("stop");
        this.stopItem.setEnabled(false);
        this.popup.add(this.stopItem);
        this.popup.addSeparator();
        JMenuItem quitItem = new JMenuItem(this.resourceMap.getString("quitMenuText", new Object[0]));
        quitItem.addActionListener(this);
        quitItem.setActionCommand("quit");
        this.popup.add(quitItem);
    }

    public void install() {
        for (WindowListener l : this.parent.getMainFrame().getWindowListeners()) {
            this.parent.getMainFrame().removeWindowListener(l);
        }
        this.parent.getMainFrame().addWindowListener(this);
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        block3: {
            if (SystemTray.isSupported()) {
                SystemTray tray = SystemTray.getSystemTray();
                this.trayIcon = new JPopupTrayIcon(this.idleImage, this.resourceMap.getString("tooltipIdleText", new Object[0]), this.popup);
                this.trayIcon.setImageAutoSize(true);
                this.trayIcon.addMouseListener(this);
                try {
                    tray.add(this.trayIcon);
                }
                catch (AWTException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"Error while setting system tray", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void addProject(TimerProject project) {
    }

    @Override
    public void addTask(TimerTask task) {
    }

    @Override
    public void dataLoaded(Collection<TimerProject> projects) {
    }

    @Override
    public void deleteProject(TimerProject project) {
    }

    @Override
    public void deleteTask(TimerTask task) {
    }

    @Override
    public void modifyProject(TimerProject project) {
    }

    @Override
    public void modifyTask(TimerTask task) {
    }

    @Override
    public void changeClosedState(TimerTask task) {
    }

    @Override
    public void startTask(TimerTask task) {
        this.startStopTask(task, true);
    }

    @Override
    public void stopTask(TimerTask task) {
        this.startStopTask(task, false);
    }

    protected void startStopTask(TimerTask task, boolean start) {
        if (this.trayIcon != null) {
            this.nbTasksRunning = start ? ++this.nbTasksRunning : --this.nbTasksRunning;
            String message = null;
            if (this.nbTasksRunning == 0) {
                message = this.resourceMap.getString("tooltipIdleText", new Object[0]);
                this.trayIcon.setImage(this.idleImage);
            } else {
                this.trayIcon.setImage(this.runningImage);
                message = this.nbTasksRunning == 1 ? this.resourceMap.getString("tooltipRunningTaskText", new Object[]{this.nbTasksRunning}) : this.resourceMap.getString("tooltipRunningTasksText", new Object[]{this.nbTasksRunning});
            }
            this.trayIcon.setToolTip(message);
            this.stopItem.setEnabled(this.nbTasksRunning > 0);
        }
    }

    public void preIdleDetect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre idle detect");
        }
        if (this.trayIcon != null) {
            this.trayIcon.setImage(this.idleDetectImage);
        }
    }

    public void postIdleDetect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Post idle detect");
        }
        if (this.trayIcon != null) {
            if (this.nbTasksRunning == 0) {
                this.trayIcon.setImage(this.idleImage);
            } else {
                this.trayIcon.setImage(this.runningImage);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("showHide".equals(actionCommand)) {
            if (this.parent.getMainFrame().isVisible()) {
                this.parent.hide();
                this.showItem.setText(this.resourceMap.getString("showMenuText", new Object[0]));
            } else {
                this.parent.show();
                this.showItem.setText(this.resourceMap.getString("hideMenuText", new Object[0]));
            }
        } else if ("stop".equals(actionCommand)) {
            this.parent.stopAllTasks();
        } else if ("quit".equals(actionCommand)) {
            this.parent.quit(e);
        }
    }

    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {
    }

    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {
    }

    @Override
    public void moveTask(TimerTask task) {
    }

    @Override
    public void preMoveTask(TimerTask task) {
    }

    @Override
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1 && e.getButton() == 1) {
            if (this.parent.getMainFrame().isVisible()) {
                this.showItem.setText(this.resourceMap.getString("showMenuText", new Object[0]));
                this.parent.hide();
            } else {
                this.showItem.setText(this.resourceMap.getString("hideMenuText", new Object[0]));
                this.parent.show();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.trayIcon != null && JTimer.config.isCloseToSystray()) {
            this.parent.hide();
            this.showItem.setText(this.resourceMap.getString("showMenuText", new Object[0]));
        } else {
            this.parent.exit(e);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

