/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.alert;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.ui.widget.DurationEditor;

public class AlertCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = -363052829182024180L;
    protected Component editor;

    @Override
    public Object getCellEditorValue() {
        Object value = null;
        if (this.editor instanceof JComboBox) {
            value = ((JComboBox)this.editor).getSelectedItem();
        } else if (this.editor instanceof DurationEditor) {
            value = ((DurationEditor)this.editor).getDuration();
        }
        return value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        switch (column) {
            case 0: {
                JComboBox<TimerAlert.Type> combo = new JComboBox<TimerAlert.Type>();
                combo.addItem(TimerAlert.Type.REACH_DAILY_TIME);
                combo.addItem(TimerAlert.Type.REACH_TOTAL_TIME);
                combo.setSelectedItem(value);
                combo.addItemListener(this);
                this.editor = combo;
                break;
            }
            case 1: {
                DurationEditor durationEditor = new DurationEditor(9999);
                long duration = (Long)value;
                durationEditor.setDuration(duration);
                durationEditor.addPropertyChangeListener("duration", this);
                durationEditor.setSize(100, 30);
                this.editor = durationEditor;
                break;
            }
        }
        if (isSelected) {
            this.editor.setBackground(table.getSelectionBackground());
        }
        return this.editor;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.stopCellEditing();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.stopCellEditing();
    }
}

