/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.data.DataViolationException;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DateSelectionModel;

public class TimerTaskEditor
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -3612429715471081966L;
    private static Log log = LogFactory.getLog(TimerTaskEditor.class);
    protected ResourceMap resourceMap;
    protected JTextField titleText;
    protected JXMonthView monthView;
    protected JSpinner spinnerH;
    protected JSpinner spinnerM;
    protected JSpinner spinnerS;
    protected JTextArea annotationText;
    protected ChangeListener spinnerListener;
    protected DocumentListener titleChangeListener;
    protected DocumentListener annotationChangeListener;
    protected TimerTask task;
    protected TimerTask cloneTask;
    protected TimerCore core;
    protected TimerDataManager dataManager;
    protected boolean isTitleChanged;
    protected boolean isAnnotationChanged;
    protected Set<Date> dateChanged = new HashSet<Date>();
    protected Set<Date> annotationChanged = new HashSet<Date>();
    protected Calendar selectedDay;
    protected JButton applyButton;
    protected JButton revertButton;

    public TimerTaskEditor(JTimer application, TimerTask task, TimerCore core) {
        super(application.getMainFrame());
        this.setModal(true);
        this.setName(null);
        this.task = task;
        this.cloneTask = task.clone();
        this.core = core;
        this.dataManager = core.getData();
        ApplicationContext ctxt = application.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        this.resourceMap = mgr.getResourceMap(TimerTaskEditor.class);
        this.setTitle(this.resourceMap.getString("editor.title", new Object[0]));
        this.buildUI();
        this.updateFlaggedDates();
        Calendar yesterDay = Calendar.getInstance();
        yesterDay.add(6, -1);
        this.setSelectedDay(yesterDay.getTime());
    }

    protected void buildUI() {
        KeyStroke cancelStroke = KeyStroke.getKeyStroke("ESCAPE");
        this.getRootPane().getInputMap(2).put(cancelStroke, "CANCEL");
        this.getRootPane().getActionMap().put("CANCEL", new AbstractAction(){
            private static final long serialVersionUID = -3871353493857041286L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TimerTaskEditor.this.cancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TimerTaskEditor.this.cancel();
            }
        });
        this.getContentPane().setLayout(new BorderLayout(1, 0));
        this.getContentPane().add((Component)this.createContentPanel(), "Center");
        this.getContentPane().add((Component)this.createCommandPanel(), "South");
        this.pack();
    }

    protected JPanel createCommandPanel() {
        this.applyButton = new JButton(this.resourceMap.getString("apply.Action.text", new Object[0]));
        this.applyButton.setActionCommand("apply");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.revertButton = new JButton(this.resourceMap.getString("revert.Action.text", new Object[0]));
        this.revertButton.setActionCommand("revert");
        this.revertButton.addActionListener(this);
        this.revertButton.setEnabled(false);
        JButton cancelButton = new JButton(this.resourceMap.getString("cancel.Action.text", new Object[0]));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2, 1, 0));
        panel.add(this.applyButton);
        panel.add(this.revertButton);
        panel.add(cancelButton);
        return panel;
    }

    protected JPanel createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.titleChangeListener = new TextChangeListener();
        this.annotationChangeListener = new TextChangeListener();
        this.titleText = new JTextField();
        this.titleText.getDocument().addDocumentListener(this.titleChangeListener);
        panel.add((Component)this.titleText, "North");
        panel.add((Component)this.createJXMonthView(), "Center");
        panel.add((Component)this.createEditionPanel(), "South");
        return panel;
    }

    protected JPanel createEditionPanel() {
        JLabel spinnerLabel = new JLabel(this.resourceMap.getString("label.time.text", new Object[0]));
        JPanel spinnerPanel = this.createSpinnersPanel();
        JLabel annotationLabel = new JLabel(this.resourceMap.getString("label.annotation.text", new Object[0]));
        this.annotationText = new JTextArea();
        this.annotationText.getDocument().addDocumentListener(this.annotationChangeListener);
        this.annotationText.setRows(4);
        this.annotationText.setLineWrap(true);
        this.annotationText.setWrapStyleWord(true);
        JScrollPane annotationPane = new JScrollPane(this.annotationText, 20, 31);
        SpringLayout layout = new SpringLayout();
        JPanel panel = new JPanel(layout);
        panel.add(spinnerLabel);
        panel.add(annotationLabel);
        panel.add(spinnerPanel);
        panel.add(annotationPane);
        JLabel largerLabel = spinnerLabel.getText().length() < annotationLabel.getText().length() ? annotationLabel : spinnerLabel;
        layout.putConstraint("North", (Component)spinnerLabel, 2, "North", (Component)panel);
        layout.putConstraint("West", (Component)spinnerLabel, 2, "West", (Component)panel);
        layout.putConstraint("North", (Component)spinnerPanel, 2, "North", (Component)panel);
        layout.putConstraint("West", (Component)spinnerPanel, 2, "East", (Component)largerLabel);
        layout.putConstraint("North", (Component)annotationLabel, 1, "South", (Component)spinnerPanel);
        layout.putConstraint("West", (Component)annotationLabel, 2, "West", (Component)panel);
        layout.putConstraint("North", (Component)annotationPane, 1, "South", (Component)spinnerPanel);
        layout.putConstraint("West", (Component)annotationPane, 2, "East", (Component)largerLabel);
        layout.putConstraint("South", (Component)panel, 2, "South", (Component)annotationPane);
        layout.putConstraint("East", (Component)panel, 2, "East", (Component)annotationPane);
        return panel;
    }

    protected JXMonthView createJXMonthView() {
        this.monthView = new JXMonthView();
        this.monthView.setTraversable(true);
        this.monthView.setFirstDayOfWeek(2);
        this.monthView.setFlaggedDayForeground(Color.BLUE);
        this.monthView.setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_SELECTION);
        Calendar yesterdayCalendar = Calendar.getInstance();
        yesterdayCalendar.add(6, -1);
        this.monthView.setUpperBound(yesterdayCalendar.getTime());
        this.monthView.setSelectionDate(yesterdayCalendar.getTime());
        this.monthView.setDayForeground(1, Color.RED);
        this.monthView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("monthViewCommit".equals(e.getActionCommand())) {
                    TimerTaskEditor.this.setSelectedDay(TimerTaskEditor.this.monthView.getFirstSelectionDate());
                }
            }
        });
        return this.monthView;
    }

    protected JPanel createSpinnersPanel() {
        this.spinnerH = new JSpinner(new SpinnerNumberModel(0, 0, 24, 1));
        this.spinnerH.setEditor(new JSpinner.NumberEditor(this.spinnerH, "00"));
        this.spinnerM = new JSpinner(new SpinnerNumberModel(0, -1, 60, 1));
        this.spinnerM.setEditor(new JSpinner.NumberEditor(this.spinnerM, "00"));
        this.spinnerM.setPreferredSize(this.spinnerH.getPreferredSize());
        this.spinnerS = new JSpinner(new SpinnerNumberModel(0, -1, 60, 1));
        this.spinnerS.setEditor(new JSpinner.NumberEditor(this.spinnerS, "00"));
        this.spinnerS.setPreferredSize(this.spinnerH.getPreferredSize());
        this.spinnerListener = new SpinnerListener();
        this.spinnerH.addChangeListener(this.spinnerListener);
        this.spinnerM.addChangeListener(this.spinnerListener);
        this.spinnerS.addChangeListener(this.spinnerListener);
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
        panel.add(this.spinnerH);
        panel.add(new JLabel(":"));
        panel.add(this.spinnerM);
        panel.add(new JLabel(":"));
        panel.add(this.spinnerS);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("cancel".equals(e.getActionCommand())) {
            this.cancel();
        } else if ("apply".equals(e.getActionCommand())) {
            this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.apply();
            }
            catch (DataViolationException ex) {
                this.revert();
            }
            this.getRootPane().setCursor(Cursor.getPredefinedCursor(0));
        } else if ("revert".equals(e.getActionCommand())) {
            this.revert();
        }
    }

    public Calendar getSelectedDay() {
        return this.selectedDay;
    }

    public void setSelectedDay(Date date) {
        if (date != null) {
            this.displayTask(date);
        } else {
            Calendar yesterDay = Calendar.getInstance();
            yesterDay.add(6, -1);
            this.displayTask(yesterDay.getTime());
        }
    }

    protected void displayTask(Date date) {
        this.selectedDay = Calendar.getInstance();
        this.selectedDay.setTime(date);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Displaying information on: " + date));
        }
        this.spinnerH.removeChangeListener(this.spinnerListener);
        this.spinnerM.removeChangeListener(this.spinnerListener);
        long time = this.cloneTask.getTime(date);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time - (long)cal.get(15));
        this.spinnerH.setValue(cal.get(11));
        this.spinnerM.setValue(cal.get(12));
        this.spinnerS.setValue(cal.get(13));
        this.spinnerH.addChangeListener(this.spinnerListener);
        this.spinnerM.addChangeListener(this.spinnerListener);
        this.annotationText.getDocument().removeDocumentListener(this.annotationChangeListener);
        this.annotationText.setText("");
        List<String> notes = TimerTaskHelper.getAnnotation(this.cloneTask, date);
        String carriage = "";
        for (String note : notes) {
            this.annotationText.setText(carriage + this.annotationText.getText() + note);
            carriage = "\n";
        }
        this.annotationText.setCaretPosition(0);
        this.annotationText.getDocument().addDocumentListener(this.annotationChangeListener);
        this.titleText.getDocument().removeDocumentListener(this.titleChangeListener);
        this.titleText.setText(this.cloneTask.getName());
        this.titleText.setCaretPosition(0);
        this.titleText.getDocument().addDocumentListener(this.titleChangeListener);
    }

    protected void updateTask(TextChangeListener issuer) {
        if (issuer == this.titleChangeListener) {
            this.isTitleChanged = true;
        } else if (issuer == this.annotationChangeListener) {
            this.isAnnotationChanged = true;
        }
        this.updateTask();
    }

    protected void updateTask() {
        long seconds = (Integer)this.spinnerH.getValue() * 60 * 60 + (Integer)this.spinnerM.getValue() * 60 + (Integer)this.spinnerS.getValue();
        this.cloneTask.setTime(this.getSelectedDay().getTime(), seconds * 1000L);
        if (this.isAnnotationChanged) {
            TimerTaskHelper.removeAnnotation(this.cloneTask, this.getSelectedDay().getTime());
            String note = this.annotationText.getText();
            if (note != null) {
                Calendar cal = this.getSelectedDay();
                StringTokenizer st = new StringTokenizer(note, "\n");
                while (st.hasMoreTokens()) {
                    cal.add(13, 1);
                    this.cloneTask.addAnnotation(cal.getTime(), st.nextToken());
                }
                this.annotationChanged.add(this.getSelectedDay().getTime());
            }
            this.isAnnotationChanged = false;
        }
        if (this.isTitleChanged) {
            this.cloneTask.setName(this.titleText.getText());
        }
        this.dateChanged.add(this.getSelectedDay().getTime());
        this.applyButton.setEnabled(true);
        this.revertButton.setEnabled(true);
        this.updateFlaggedDates();
    }

    public void updateFlaggedDates() {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (Date date : this.cloneTask.getAllDaysAndTimes().keySet()) {
            if (this.cloneTask.getTime(date) <= 0L) continue;
            dates.add(date);
        }
        for (Date date : this.cloneTask.getAllDaysAnnotations().keySet()) {
            dates.add(date);
        }
        this.monthView.setFlaggedDates(dates.toArray(new Date[dates.size()]));
    }

    protected void revert() {
        this.cloneTask = this.task.clone();
        this.dateChanged.clear();
        this.annotationChanged.clear();
        this.applyButton.setEnabled(false);
        this.revertButton.setEnabled(false);
        this.isTitleChanged = false;
        this.isAnnotationChanged = false;
        this.displayTask(this.getSelectedDay().getTime());
        this.updateFlaggedDates();
    }

    protected void apply() {
        if (this.isTitleChanged) {
            this.dataManager.editTask(this.task, this.cloneTask.getName());
        }
        for (Date date : this.dateChanged) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Applying changes on: " + date));
            }
            this.dataManager.changeTaskTime(this.task, date, this.cloneTask.getTime(date));
            if (!this.annotationChanged.contains(date)) continue;
            TimerTaskHelper.removeAnnotation(this.task, date);
            Map<Date, String> annotations = TimerTaskHelper.getAnnotationMap(this.cloneTask, date);
            for (Date date2 : annotations.keySet()) {
                this.dataManager.addAnnotation(this.task, date2, annotations.get(date2));
            }
        }
        this.dateChanged.clear();
        this.annotationChanged.clear();
        this.applyButton.setEnabled(false);
        this.revertButton.setEnabled(false);
        this.isTitleChanged = false;
        this.isAnnotationChanged = false;
    }

    protected void cancel() {
        this.dispose();
    }

    protected class TextChangeListener
    implements DocumentListener {
        protected TextChangeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TimerTaskEditor.this.updateTask(this);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TimerTaskEditor.this.updateTask(this);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TimerTaskEditor.this.updateTask(this);
        }
    }

    protected class SpinnerListener
    implements ChangeListener {
        protected SpinnerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == TimerTaskEditor.this.spinnerM) {
                int value = ((SpinnerNumberModel)TimerTaskEditor.this.spinnerM.getModel()).getNumber().intValue();
                if (value >= 60) {
                    if (TimerTaskEditor.this.spinnerH.getNextValue() != null) {
                        TimerTaskEditor.this.spinnerM.setValue(value - 60);
                        TimerTaskEditor.this.spinnerH.setValue(TimerTaskEditor.this.spinnerH.getNextValue());
                    } else {
                        TimerTaskEditor.this.spinnerM.setValue(value - 1);
                    }
                } else if (value < 0) {
                    if (TimerTaskEditor.this.spinnerH.getPreviousValue() != null) {
                        TimerTaskEditor.this.spinnerM.setValue(value + 60);
                        TimerTaskEditor.this.spinnerH.setValue(TimerTaskEditor.this.spinnerH.getPreviousValue());
                    } else {
                        TimerTaskEditor.this.spinnerM.setValue(0);
                    }
                }
            } else if (e.getSource() == TimerTaskEditor.this.spinnerS) {
                int value = ((SpinnerNumberModel)TimerTaskEditor.this.spinnerS.getModel()).getNumber().intValue();
                if (value >= 60) {
                    if (TimerTaskEditor.this.spinnerM.getNextValue() != null) {
                        TimerTaskEditor.this.spinnerS.setValue(value - 60);
                        TimerTaskEditor.this.spinnerM.setValue(TimerTaskEditor.this.spinnerM.getNextValue());
                    } else {
                        TimerTaskEditor.this.spinnerS.setValue(value - 1);
                    }
                } else if (value < 0) {
                    int hour = ((SpinnerNumberModel)TimerTaskEditor.this.spinnerH.getModel()).getNumber().intValue();
                    int minute = ((SpinnerNumberModel)TimerTaskEditor.this.spinnerM.getModel()).getNumber().intValue();
                    if (hour != 0 || minute != 0) {
                        TimerTaskEditor.this.spinnerS.setValue(value + 60);
                        TimerTaskEditor.this.spinnerM.setValue(TimerTaskEditor.this.spinnerM.getPreviousValue());
                    } else {
                        TimerTaskEditor.this.spinnerS.setValue(0);
                    }
                }
            }
            TimerTaskEditor.this.updateTask();
        }
    }
}

