/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui;

import java.awt.GridLayout;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;

public class StatusBar
extends JPanel
implements DataEventListener {
    private static final long serialVersionUID = -1283108564414026297L;
    protected ResourceMap resourceMap;
    protected TimerDataManager dataManager;
    protected JLabel lblMessage;
    protected JLabel lblTime;
    protected int nbTasksRunning = 0;

    public StatusBar(Application application, TimerDataManager dataManager) {
        super(new GridLayout());
        ApplicationContext ctxt = application.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        this.resourceMap = mgr.getResourceMap(StatusBar.class);
        this.lblMessage = new JLabel(this.resourceMap.getString("loadingMessage", new Object[0]));
        this.lblMessage.setBorder(BorderFactory.createEtchedBorder());
        this.add(this.lblMessage);
        this.lblTime = new JLabel(this.resourceMap.getString("todayTotalMessage", new Object[]{"--"}));
        this.lblTime.setBorder(BorderFactory.createEtchedBorder());
        this.lblTime.setHorizontalAlignment(0);
        this.add(this.lblTime);
        this.dataManager = dataManager;
    }

    protected void updateTodayTime() {
        long duration = 0L;
        for (TimerProject p : this.dataManager.getProjectsList()) {
            duration += TimerTaskHelper.getTotalTime(p, new Date());
        }
        this.lblTime.setText(this.resourceMap.getString("todayTotalMessage", new Object[]{DurationFormatUtils.formatDuration((long)duration, (String)"HH:mm:ss")}));
    }

    @Override
    public void addProject(TimerProject project) {
        this.updateTodayTime();
    }

    @Override
    public void addTask(TimerTask task) {
        this.updateTodayTime();
    }

    @Override
    public void dataLoaded(Collection<TimerProject> projects) {
        this.lblMessage.setText(this.resourceMap.getString("idleMessage", new Object[0]));
        this.modifyTask(null);
    }

    @Override
    public void deleteProject(TimerProject project) {
        this.updateTodayTime();
    }

    @Override
    public void deleteTask(TimerTask task) {
        this.updateTodayTime();
    }

    @Override
    public void modifyProject(TimerProject project) {
    }

    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {
        this.modifyTask(task);
    }

    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {
    }

    @Override
    public void modifyTask(TimerTask task) {
        this.updateTodayTime();
    }

    @Override
    public void changeClosedState(TimerTask task) {
    }

    @Override
    public void startTask(TimerTask task) {
        this.startStopTask(task, true);
    }

    @Override
    public void stopTask(TimerTask task) {
        this.startStopTask(task, false);
    }

    protected void startStopTask(TimerTask task, boolean start) {
        this.nbTasksRunning = start ? ++this.nbTasksRunning : --this.nbTasksRunning;
        String message = null;
        message = this.nbTasksRunning == 0 ? this.resourceMap.getString("idleMessage", new Object[0]) : (this.nbTasksRunning == 1 ? this.resourceMap.getString("runningTaskMessage", new Object[]{this.nbTasksRunning}) : this.resourceMap.getString("runningTasksMessage", new Object[]{this.nbTasksRunning}));
        this.lblMessage.setText(message);
    }

    @Override
    public void moveTask(TimerTask task) {
    }

    @Override
    public void preMoveTask(TimerTask task) {
    }

    @Override
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }
}

