/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimerActions;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

public class JTimerConfig {
    private static final Log log = LogFactory.getLog(JTimerConfig.class);
    protected static final int STEP_BEFORE_UI = 0;
    protected static final int STEP_AFTER_UI = 1;
    protected ApplicationConfig appConfig = new ApplicationConfig();

    public JTimerConfig() {
        for (JTimerOption jTimerOption : JTimerOption.values()) {
            if (jTimerOption.defaultValue == null) continue;
            this.appConfig.setDefaultOption(jTimerOption.key, jTimerOption.defaultValue);
        }
        for (Enum enum_ : JTimerAction.values()) {
            for (String alias : ((JTimerAction)enum_).aliases) {
                this.appConfig.addActionAlias(alias, ((JTimerAction)enum_).action);
            }
        }
    }

    public void parse(String ... args) {
        block2: {
            try {
                this.appConfig.parse(args);
            }
            catch (ArgumentsParserException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't parse configuration", (Throwable)ex);
            }
        }
    }

    public void putObject(Object o) {
        this.appConfig.putObject(o);
    }

    public void doAction(int step) {
        block2: {
            try {
                this.appConfig.doAction(step);
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't run command line actions", (Throwable)ex);
            }
        }
    }

    public Class getServiceClass() {
        Class serviceClass;
        block2: {
            serviceClass = null;
            try {
                serviceClass = this.appConfig.getOptionAsClass(JTimerOption.SERVICE_CLASS.key);
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't find service class implementation, sync will not work", (Throwable)ex);
            }
        }
        return serviceClass;
    }

    public String getServiceEndpoint() {
        return this.appConfig.getOption(JTimerOption.SERVICE_ENDPOINT.key);
    }

    public String getServiceResource() {
        return this.appConfig.getOption(JTimerOption.SERVICE_RESOURCE.key);
    }

    public Class getIOSaverClass() {
        return this.appConfig.getOptionAsClass(JTimerOption.IO_SAVER_CLASS.key);
    }

    public String getIOSaverDirectory() {
        return this.appConfig.getOption(JTimerOption.IO_SAVER_DIRECTORY.key);
    }

    public long getIOSaverAutoSaveDelay() {
        return this.appConfig.getOptionAsLong(JTimerOption.IO_SAVER_AUTOSAVEDELAY.key);
    }

    public long getIdleTime() {
        return this.appConfig.getOptionAsLong(JTimerOption.UI_IDLE_TIME.key);
    }

    public boolean isShowClosed() {
        return this.appConfig.getOptionAsBoolean(JTimerOption.UI_SHOW_CLOSED.key);
    }

    public void setShowClosed(boolean showClosed) {
        this.appConfig.setOption(JTimerOption.UI_SHOW_CLOSED.key, String.valueOf(showClosed));
        this.appConfig.saveForUser(new String[0]);
    }

    public boolean isCloseToSystray() {
        return this.appConfig.getOptionAsBoolean(JTimerOption.UI_CLOSE_TO_SYSTRAY.key);
    }

    public void setCloseToSystray(boolean closeToSystray) {
        this.appConfig.setOption(JTimerOption.UI_CLOSE_TO_SYSTRAY.key, String.valueOf(closeToSystray));
        this.appConfig.saveForUser(new String[0]);
    }

    public int getReportFirstDayOfWeek() {
        return this.appConfig.getOptionAsInt(JTimerOption.UI_REPORT_FIRSTDAYOFWEEK.key);
    }

    public void setReportFirstDayOfWeek(int firstDayOfWeek) {
        this.appConfig.setOption(JTimerOption.UI_REPORT_FIRSTDAYOFWEEK.key, String.valueOf(firstDayOfWeek));
        this.appConfig.saveForUser(new String[0]);
    }

    protected static enum JTimerAction {
        HELP("Show help", JTimerActions.class.getName() + "#help", "--help", "-h"),
        VERSION("Display application version", JTimerActions.class.getName() + "#version", "--version", "-v"),
        START("Start task", JTimerActions.class.getName() + "#start", "--start", "-s");

        protected String description;
        protected String action;
        protected String[] aliases;

        private JTimerAction(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }
    }

    protected static enum JTimerOption {
        CONFIG_FILENAME("config.file", "jtimer.properties"),
        SERVICE_CLASS("jtimer.service.class", null),
        SERVICE_ENDPOINT("jtimer.service.endpoint", null),
        SERVICE_RESOURCE("jtimer.service.resource", "JTimer"),
        IO_SAVER_CLASS("jtimer.io.saver.class", "org.chorem.jtimer.io.GTimerIncrementalSaver"),
        IO_SAVER_DIRECTORY("jtimer.io.saver.directory", "${user.home}/.gtimer"),
        IO_SAVER_AUTOSAVEDELAY("jtimer.io.saver.autosavedelay", "300"),
        UI_IDLE_TIME("jtimer.ui.idletime", "300"),
        UI_SHOW_CLOSED("jtimer.ui.showclosed", "false"),
        UI_CLOSE_TO_SYSTRAY("jtimer.ui.closetosystray", "true"),
        UI_REPORT_FIRSTDAYOFWEEK("jtimer.ui.report.firstdayofweek", "0");

        protected String key;
        protected String defaultValue;

        private JTimerOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }
    }
}

